/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatCheckDataService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.exportactions.CheckDataAction;
import fr.ifremer.tutti.service.genericformat.exportactions.CreateAccidentalCatchRowsAction;
import fr.ifremer.tutti.service.genericformat.exportactions.CreateCatchBatchRowsAction;
import fr.ifremer.tutti.service.genericformat.exportactions.CreateIndividualObservationRowsAction;
import fr.ifremer.tutti.service.genericformat.exportactions.CreateMarineLitterRowsAction;
import fr.ifremer.tutti.service.genericformat.exportactions.CreateOperationRowsAction;
import fr.ifremer.tutti.service.genericformat.exportactions.CreateParameterRowsAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportCruiseActionSupport;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportFishingOperationActionSupport;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportGearCaracteristicAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportProtocolAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportReferentialGearAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportReferentialPersonAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportReferentialSpeciesAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportReferentialVesselAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportSampleCategoryModelAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportSpeciesUsedAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportSurveyAction;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportTechnicalActionSupport;
import fr.ifremer.tutti.service.genericformat.exportactions.FinalizeExportAction;
import fr.ifremer.tutti.service.genericformat.exportactions.FlushOperationAction;
import fr.ifremer.tutti.service.genericformat.exportactions.GenerateExportArchiveAction;
import fr.ifremer.tutti.service.genericformat.exportactions.LoadDataAction;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericFormatExportActionEngine {
    private static final Log log = LogFactory.getLog(GenericFormatExportActionEngine.class);
    private final List<ExportCruiseActionSupport> cruiseActions;
    private final List<ExportFishingOperationActionSupport> fishingOperationsActions;
    private final List<ExportTechnicalActionSupport> loadActions;
    private final List<ExportTechnicalActionSupport> technicalActions;

    public GenericFormatExportActionEngine(TuttiServiceContext serviceContext) {
        this.loadActions = this.createLoadActions(serviceContext);
        this.cruiseActions = this.createCruiseActions(serviceContext);
        this.fishingOperationsActions = this.createFishingOperationActions(serviceContext);
        this.technicalActions = this.createTechnicalActions(serviceContext);
    }

    public void executeLoadActions(GenericFormatExportContext exportContext) {
        for (ExportTechnicalActionSupport action : this.loadActions) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Execute " + action.getClass().getSimpleName()));
            }
            action.execute(exportContext);
        }
    }

    public void executeCruiseActions(GenericFormatExportContext exportContext, Cruise cruise) {
        for (ExportCruiseActionSupport action : this.cruiseActions) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Execute " + action.getClass().getSimpleName() + " on cruise " + cruise.getId()));
            }
            action.execute(exportContext, cruise);
        }
    }

    public void executeOperationActions(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        for (ExportFishingOperationActionSupport action : this.fishingOperationsActions) {
            if (action.doExecute(exportContext, operationContext)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Execute " + action.getClass().getSimpleName() + " on operation " + operationContext.getOperation().getId()));
                }
                action.execute(exportContext, operationContext);
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Skip    " + action.getClass().getSimpleName() + " on operation " + operationContext.getOperation().getId()));
        }
    }

    public void executeTechnicalActions(GenericFormatExportContext exportContext) {
        for (ExportTechnicalActionSupport action : this.technicalActions) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Execute " + action.getClass().getSimpleName()));
            }
            action.execute(exportContext);
        }
    }

    private List<ExportTechnicalActionSupport> createLoadActions(TuttiServiceContext serviceContext) {
        ArrayList<ExportTechnicalActionSupport> actions = new ArrayList<ExportTechnicalActionSupport>();
        actions.add(new LoadDataAction(serviceContext.getService(PersistenceService.class)));
        actions.add(new CheckDataAction(serviceContext.getService(GenericFormatCheckDataService.class)));
        return actions;
    }

    private List<ExportCruiseActionSupport> createCruiseActions(TuttiServiceContext serviceContext) {
        PersistenceService persistenceService = serviceContext.getService(PersistenceService.class);
        String countryId = serviceContext.getConfig().getExportCountryId();
        ArrayList<ExportCruiseActionSupport> actions = new ArrayList<ExportCruiseActionSupport>();
        actions.add(new ExportSurveyAction(persistenceService, countryId));
        actions.add(new ExportGearCaracteristicAction(persistenceService));
        return actions;
    }

    private List<ExportFishingOperationActionSupport> createFishingOperationActions(TuttiServiceContext serviceContext) {
        PersistenceService persistenceService = serviceContext.getService(PersistenceService.class);
        ArrayList<ExportFishingOperationActionSupport> actions = new ArrayList<ExportFishingOperationActionSupport>();
        actions.add(new CreateOperationRowsAction(persistenceService));
        actions.add(new CreateParameterRowsAction());
        actions.add(new CreateCatchBatchRowsAction(persistenceService));
        actions.add(new CreateMarineLitterRowsAction(persistenceService));
        actions.add(new CreateIndividualObservationRowsAction(persistenceService));
        actions.add(new CreateAccidentalCatchRowsAction(persistenceService));
        actions.add(new FlushOperationAction());
        return actions;
    }

    private List<ExportTechnicalActionSupport> createTechnicalActions(TuttiServiceContext serviceContext) {
        ArrayList<ExportTechnicalActionSupport> actions = new ArrayList<ExportTechnicalActionSupport>();
        actions.add(new ExportProtocolAction(serviceContext.getService(ProtocolImportExportService.class)));
        actions.add(new ExportSampleCategoryModelAction());
        actions.add(new ExportSpeciesUsedAction());
        actions.add(new ExportReferentialGearAction(serviceContext.getService(ReferentialTemporaryGearService.class)));
        actions.add(new ExportReferentialPersonAction(serviceContext.getService(ReferentialTemporaryPersonService.class)));
        actions.add(new ExportReferentialSpeciesAction(serviceContext.getService(ReferentialTemporarySpeciesService.class)));
        actions.add(new ExportReferentialVesselAction(serviceContext.getService(ReferentialTemporaryVesselService.class)));
        actions.add(new FinalizeExportAction());
        actions.add(new GenerateExportArchiveAction());
        return actions;
    }
}

