/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ResourceResolver;
import org.nuiton.util.StringUtil;

public class FasterCachedResourceResolver
extends ResourceResolver {
    private static final Log log = LogFactory.getLog(FasterCachedResourceResolver.class);
    protected boolean offline;

    public FasterCachedResourceResolver() {
        this(null);
    }

    public FasterCachedResourceResolver(String base) {
        super(base);
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @Override
    protected Source findHrefSource(String path) {
        long t0 = System.nanoTime();
        String resource = "META-INF/cache/" + path;
        if (this.verbose) {
            log.info((Object)("will discover " + resource));
        }
        URL url = this.cl.getResource(resource);
        StreamSource source = null;
        if (url != null) {
            if (this.verbose) {
                log.info((Object)url.toString());
            }
            source = new StreamSource(url.toString());
        }
        if (source == null) {
            if (this.offline) {
                throw new IllegalStateException("offline - could not find extact resource at location " + resource);
            }
            log.warn((Object)("could not find extact resource at location " + resource));
        }
        if (this.verbose) {
            log.info((Object)("resolved in " + StringUtil.convertTime(System.nanoTime() - t0)));
        }
        return source;
    }
}

