/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.type.WeightUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class WeightCleaningService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(WeightCleaningService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected SampleCategoryModel sampleCategoryModel;
    protected PersistenceService.FrequencyFunction speciesFrequencyFunction;
    protected PersistenceService.FrequencyFunction benthosFrequencyFunction;
    protected WeightUnit benthosWeightUnit;
    protected WeightUnit speciesWeightUnit;
    private String speciesBatchPrefix;
    private String benthosBatchPrefix;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.sampleCategoryModel = context.getSampleCategoryModel();
        this.speciesFrequencyFunction = this.persistenceService.newSpeciesFrequenciesFunction();
        this.benthosFrequencyFunction = this.persistenceService.newBenthosFrequenciesFunction();
        this.benthosWeightUnit = context.getConfig().getBenthosWeightUnit();
        this.speciesWeightUnit = context.getConfig().getSpeciesWeightUnit();
        this.speciesBatchPrefix = I18n.t((String)"tutti.service.operations.cleanWeights.species.batch", (Object[])new Object[0]);
        this.benthosBatchPrefix = I18n.t((String)"tutti.service.operations.cleanWeights.benthos.batch", (Object[])new Object[0]);
    }

    public String errorsToString(Multimap<String, String> errors) {
        StringBuilder errorsStr = new StringBuilder("<ul style=\"font-size:11\">");
        for (String error : errors.keySet()) {
            errorsStr.append("<li>");
            Collection strings = errors.get((Object)error);
            errorsStr.append(error);
            if (strings.size() == 1) {
                errorsStr.append(" ").append((String)strings.iterator().next());
            } else {
                errorsStr.append("<ul>");
                for (String s : strings) {
                    errorsStr.append("<li>");
                    errorsStr.append(s);
                    errorsStr.append("</li>");
                }
                errorsStr.append("</ul>");
            }
            errorsStr.append("</li>");
        }
        errorsStr.append("</ul>");
        return errorsStr.toString();
    }

    public Multimap<String, String> checkFishingOperation(Integer fishingOperationId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check fishingOperation: " + fishingOperationId));
        }
        LinkedHashMultimap result = LinkedHashMultimap.create();
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (withCatchBatch) {
            BatchContainer<SpeciesBatch> speciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, true);
            for (SpeciesBatch batch : speciesBatch.getChildren()) {
                this.checkBatch(this.speciesBatchPrefix, this.speciesWeightUnit, batch, (Multimap<String, String>)result, this.speciesFrequencyFunction);
            }
            BatchContainer<SpeciesBatch> benthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, true);
            for (SpeciesBatch batch : benthosBatch.getChildren()) {
                this.checkBatch(this.benthosBatchPrefix, this.benthosWeightUnit, batch, (Multimap<String, String>)result, this.benthosFrequencyFunction);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
        }
        return result;
    }

    public boolean cleanFishingOperation(Integer fishingOperationId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will clean fishingOperation: " + fishingOperationId));
        }
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        boolean result = false;
        if (withCatchBatch) {
            HashSet<SpeciesBatch> speciesToSave = new HashSet<SpeciesBatch>();
            BatchContainer<SpeciesBatch> speciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, true);
            for (SpeciesBatch batch : speciesBatch.getChildren()) {
                this.cleanBatch(this.speciesBatchPrefix, this.speciesWeightUnit, batch, speciesToSave, this.speciesFrequencyFunction);
            }
            HashSet<SpeciesBatch> benthosToSave = new HashSet<SpeciesBatch>();
            BatchContainer<SpeciesBatch> benthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, true);
            for (SpeciesBatch batch : benthosBatch.getChildren()) {
                this.cleanBatch(this.benthosBatchPrefix, this.benthosWeightUnit, batch, benthosToSave, this.benthosFrequencyFunction);
            }
            if (!speciesToSave.isEmpty() || !benthosToSave.isEmpty()) {
                result = true;
                FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
                for (SpeciesBatch toSave : speciesToSave) {
                    toSave.setFishingOperation(fishingOperation);
                    this.persistenceService.saveSpeciesBatch(toSave);
                }
                for (SpeciesBatch toSave : benthosToSave) {
                    toSave.setFishingOperation(fishingOperation);
                    this.persistenceService.saveBenthosBatch(toSave);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
        }
        return result;
    }

    protected void checkBatch(String batchPrefix, WeightUnit weightUnit, SpeciesBatch batch, Multimap<String, String> result, PersistenceService.FrequencyFunction frequencyFunction) {
        if (!batch.isChildBatchsEmpty()) {
            for (SpeciesBatch childBatch : batch.getChildBatchs()) {
                String message = this.checkSampleCategoryWeightRedundant(weightUnit, batch, childBatch);
                this.addMessageIfNotExist(message, batchPrefix, weightUnit, childBatch, result);
                this.checkBatch(batchPrefix, weightUnit, childBatch, result, frequencyFunction);
            }
        } else {
            String message = this.checkWeightRedundant(weightUnit, batch);
            this.addMessageIfNotExist(message, batchPrefix, weightUnit, batch, result);
            message = this.checkFrequencyWeightRedundant(weightUnit, batch, frequencyFunction);
            this.addMessageIfNotExist(message, batchPrefix, weightUnit, batch, result);
        }
    }

    protected void cleanBatch(String batchPrefix, WeightUnit weightUnit, SpeciesBatch batch, Set<SpeciesBatch> result, PersistenceService.FrequencyFunction frequencyFunction) {
        if (!batch.isChildBatchsEmpty()) {
            for (SpeciesBatch childBatch : batch.getChildBatchs()) {
                String message = this.checkSampleCategoryWeightRedundant(weightUnit, batch, childBatch);
                this.cleanBatch(batchPrefix, weightUnit, childBatch, result, frequencyFunction);
                if (message == null) continue;
                this.buildLabelAndLogMessage(message, batchPrefix, weightUnit, childBatch);
                batch.setSampleCategoryWeight(null);
                result.add(batch);
            }
        } else {
            boolean removeWeight = false;
            String message = this.checkFrequencyWeightRedundant(weightUnit, batch, frequencyFunction);
            if (message != null) {
                this.buildLabelAndLogMessage(message, batchPrefix, weightUnit, batch);
                removeWeight = true;
            }
            if ((message = this.checkWeightRedundant(weightUnit, batch)) != null) {
                this.buildLabelAndLogMessage(message, batchPrefix, weightUnit, batch);
                removeWeight = true;
            }
            if (removeWeight) {
                batch.setWeight(null);
                result.add(batch);
            }
        }
    }

    protected String checkSampleCategoryWeightRedundant(WeightUnit weightUnit, SpeciesBatch parentBatch, SpeciesBatch batch) {
        Preconditions.checkNotNull((Object)parentBatch);
        String result = null;
        Float sampleCategoryWeight = batch.getSampleCategoryWeight();
        Float parentSampleCategoryWeight = parentBatch.getSampleCategoryWeight();
        if (sampleCategoryWeight != null && parentSampleCategoryWeight != null && WeightUnit.KG.isEquals(parentSampleCategoryWeight.floatValue(), sampleCategoryWeight.floatValue())) {
            result = I18n.t((String)"tutti.service.operations.cleanWeights.error.redundant.sampleCategoryWeight", (Object[])new Object[]{weightUnit.fromEntity(sampleCategoryWeight) + weightUnit.getShortLabel(), this.getCategoryLabel(batch), this.getCategoryLabel(parentBatch)});
        }
        return result;
    }

    protected String checkFrequencyWeightRedundant(WeightUnit weightUnit, SpeciesBatch batch, PersistenceService.FrequencyFunction frequencyFunction) {
        List frequencies;
        Float frequenciesWeigth;
        Preconditions.checkState((boolean)batch.isChildBatchsEmpty());
        String result = null;
        Float weight = batch.getWeight();
        if (weight != null && (frequenciesWeigth = this.persistenceService.countFrequenciesWeight(frequencies = (List)frequencyFunction.apply(batch), true)) != null && WeightUnit.KG.isEquals(weight.floatValue(), frequenciesWeigth.floatValue())) {
            result = I18n.t((String)"tutti.service.operations.cleanWeights.error.redundant.frequencyWeight", (Object[])new Object[]{weightUnit.fromEntity(weight) + weightUnit.getShortLabel(), this.getCategoryLabel(batch)});
        }
        return result;
    }

    protected String checkWeightRedundant(WeightUnit weightUnit, SpeciesBatch batch) {
        Preconditions.checkState((boolean)batch.isChildBatchsEmpty());
        String result = null;
        Float weight = batch.getWeight();
        Float sampleCategoryWeight = batch.getSampleCategoryWeight();
        if (weight != null && sampleCategoryWeight != null && WeightUnit.KG.isEquals(weight.floatValue(), sampleCategoryWeight.floatValue())) {
            result = I18n.t((String)"tutti.service.operations.cleanWeights.error.redundant.weight", (Object[])new Object[]{weightUnit.fromEntity(weight) + weightUnit.getShortLabel(), this.getCategoryLabel(batch)});
        }
        return result;
    }

    protected String getBatchLabel(String type, WeightUnit weightUnit, SpeciesBatch batch) {
        StringBuilder sb = new StringBuilder("[ " + type);
        String species = this.decoratorService.getDecoratorByType(Species.class).toString((Object)batch.getSpecies());
        sb.append(" ").append(species);
        ArrayList<String> categories = new ArrayList<String>();
        SpeciesBatch b = batch;
        while (b.getParentBatch() != null) {
            String categoryValue = this.decoratorService.getDecorator(b.getSampleCategoryValue()).toString((Object)b.getSampleCategoryValue());
            categories.add(0, categoryValue + " / " + weightUnit.fromEntity(b.getSampleCategoryWeight()));
            b = b.getParentBatch();
        }
        for (String category : categories) {
            sb.append(" - ").append(category);
        }
        sb.append(" ]");
        return sb.toString();
    }

    protected String getCategoryLabel(SpeciesBatch batch) {
        SampleCategoryModelEntry category = this.sampleCategoryModel.getCategoryById(batch.getSampleCategoryId());
        return category.getLabel();
    }

    protected String buildLabelAndLogMessage(String message, String batchPrefix, WeightUnit weightUnit, SpeciesBatch b) {
        String label = this.getBatchLabel(batchPrefix, weightUnit, b);
        if (log.isInfoEnabled()) {
            log.info((Object)(label + " " + message));
        }
        return label;
    }

    protected void addMessageIfNotExist(String message, String batchPrefix, WeightUnit weightUnit, SpeciesBatch b, Multimap<String, String> result) {
        String label;
        if (message != null && !result.containsEntry((Object)(label = this.buildLabelAndLogMessage(message, batchPrefix, weightUnit, b)), (Object)message)) {
            result.put((Object)label, (Object)message);
        }
    }
}

