/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.type.WeightUnit;
import org.nuiton.i18n.I18n;

public class BenthosWeightComputingException
extends TuttiWeightComputingException {
    public static BenthosWeightComputingException forValidationMessage(WeightUnit weightUnit, String message, String species, String categoryLabel, String categoryValue, Float weight, Float sampleCategoryWeight, int thisIndex) {
        String errorMessage = I18n.t((String)message, (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(weight.floatValue()), weightUnit.renderFromEntityWithShortLabel(sampleCategoryWeight.floatValue())});
        return new BenthosWeightComputingException(errorMessage, "weight", thisIndex);
    }

    public static BenthosWeightComputingException forIncoherentTotalSorted(WeightUnit weightUnit, Float speciesTotalSortedWeight, Float speciesTotalComputedSortedWeight) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentTotalSorted", (Object[])new Object[]{weightUnit.renderFromEntityWithShortLabel(speciesTotalSortedWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(speciesTotalComputedSortedWeight.floatValue())});
        return new BenthosWeightComputingException(errorMessage);
    }

    public static BenthosWeightComputingException forIncoherentParentCategoryWeight(WeightUnit weightUnit, String species, String categoryLabel, String categoryValue, Float categoryWeight, Float sum, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentParentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(categoryWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(sum.floatValue())});
        return new BenthosWeightComputingException(errorMessage, "sampleCategoryWeight", thisIndex);
    }

    public static BenthosWeightComputingException forIncoherentRowWeightFrequency(WeightUnit weightUnit, String species, String categoryLabel, String categoryValue, Float frequencyWeight, Float rowWeight, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentRowWeightFrequency", (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(frequencyWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(rowWeight.floatValue())});
        return new BenthosWeightComputingException(errorMessage, "weight", thisIndex);
    }

    public static BenthosWeightComputingException forIncoherentCategoryWeight(WeightUnit weightUnit, String species, String categoryLabel, String categoryValue, Float frequencyWeight, Float categoryWeight, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, weightUnit.renderFromEntityWithShortLabel(frequencyWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(categoryWeight.floatValue())});
        return new BenthosWeightComputingException(errorMessage, "sampleCategoryWeight", thisIndex);
    }

    public static BenthosWeightComputingException forNoWeight(String species, String categoryLabel, String categoryValue, int thisIndex) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.noWeight", (Object[])new Object[]{species, categoryLabel, categoryValue});
        return new BenthosWeightComputingException(errorMessage, "sampleCategoryWeight", thisIndex);
    }

    private BenthosWeightComputingException(String message) {
        super(message);
    }

    private BenthosWeightComputingException(String message, String property, int index) {
        super(message, property, index);
    }
}

