/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db.actions;

import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.service.UpdateSchemaContextSupport;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.db.actions.CloseDbAction;
import fr.ifremer.tutti.ui.swing.content.db.actions.ExportDbAction;
import fr.ifremer.tutti.ui.swing.update.TuttiDbUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.update.Updates;
import java.io.File;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.version.Version;

public class OpenDbAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(OpenDbAction.class);
    protected UpdateSchemaContext updateSchemaContext;
    protected boolean updateReferentiel;
    protected String jdbcUrl;
    protected ApplicationInfo updateDbVersion;

    public OpenDbAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.SELECT_CRUISE);
        this.setActionDescription(I18n.t((String)"tutti.dbManager.action.openDb.tip", (Object[])new Object[0]));
    }

    public void setUpdateReferentiel(boolean updateReferentiel) {
        this.updateReferentiel = updateReferentiel;
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            this.jdbcUrl = null;
            this.updateSchemaContext = null;
            this.updateDbVersion = null;
            this.updateReferentiel &= this.getContext().checkUpdateDataReachable(false);
            if (this.updateReferentiel) {
                this.updateDbVersion = Updates.getDatabaseUpdateVersion(this.getConfig());
                if (this.updateDbVersion != null && this.updateDbVersion.newVersion != null) {
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.dbManager.updatedb.found", (Object[])new Object[]{this.updateDbVersion.newVersion}), I18n.t((String)"tutti.common.askBeforeUpdate.help", (Object[])new Object[0]));
                    int i = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"tutti.dbManager.title.confirm.updatedb", (Object[])new Object[0]), 2, 3);
                    this.updateReferentiel = i == 0;
                }
            }
        }
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will open db...");
        }
        this.jdbcUrl = this.getConfig().getJdbcUrl();
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(3 + (this.updateReferentiel ? 1 : 0));
        progressionModel.increments(I18n.t((String)"tutti.openDb.step.open", (Object[])new Object[]{this.jdbcUrl}));
        try {
            this.getContext().openPersistenceService();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not open db", (Throwable)e);
            }
            this.getContext().closePersistenceService();
            throw new ApplicationBusinessException(I18n.t((String)"tutti.dbManager.action.openDb.couldNotOpen", (Object[])new Object[0]));
        }
        progressionModel.increments(I18n.t((String)"tutti.openDb.step.checkSchemaVersion", (Object[])new Object[0]));
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        TuttiConfiguration config = this.getConfig();
        this.updateSchemaContext = new UpdateSchemaContext(config.getDbBackupDirectory());
        persistenceService.prepareUpdateSchemaContext(this.updateSchemaContext);
        Version schemaVersion = this.updateSchemaContext.getSchemaVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected database version: " + schemaVersion));
        }
        Version schemaVersionIfUpdate = this.updateSchemaContext.getSchemaVersionIfUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected schema application version:" + schemaVersionIfUpdate));
        }
        boolean updateSchema = this.updateSchemaContext.isWillUpdate();
        if (this.updateSchemaContext.isCloseDb()) {
            progressionModel.increments(I18n.t((String)"tutti.importDb.step.closeDb", (Object[])new Object[0]));
            this.getActionEngine().runInternalAction(this.getHandler(), CloseDbAction.class);
            this.setScreen(TuttiScreen.MANAGE_DB);
            super.doAction();
            return;
        }
        if (updateSchema) {
            progressionModel.adaptTotal(progressionModel.getTotal() + 3 + 1);
            ApplicationUIAction backupAction = this.getActionFactory().createUIAction(this.getHandler(), ExportDbAction.class);
            ((ExportDbAction)backupAction.getLogicAction()).setProgressionModel(this.getProgressionModel());
            ((ExportDbAction)backupAction.getLogicAction()).setFile(this.updateSchemaContext.getFile());
            ((ExportDbAction)backupAction.getLogicAction()).setNoUI(true);
            this.getActionEngine().runInternalAction(backupAction.getLogicAction());
            String message = I18n.t((String)"tutti.openDb.step.will.migrateSchema", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
            progressionModel.increments(message);
            this.sendMessage(message);
            this.getContext().getPersistenceService().updateSchema();
        }
        if (this.updateReferentiel) {
            progressionModel.increments(I18n.t((String)"tutti.openDb.step.updateReferential", (Object[])new Object[0]));
            progressionModel.setMessage(I18n.t((String)"tutti.dbManager.action.upgradeDb.check", (Object[])new Object[0]));
            File current = config.getDataDirectory();
            String url = config.getUpdateDataUrl();
            TuttiDbUpdaterCallBack callback = new TuttiDbUpdaterCallBack(url, this, progressionModel);
            Updates.doUpdate(config, callback, current);
            if (callback.isDbUpdated()) {
                progressionModel.setMessage(I18n.t((String)"tutti.dbManager.action.upgradeDb.reloading", (Object[])new Object[0]));
            } else {
                this.sendMessage(I18n.t((String)"tutti.dbManager.action.upgradeDb.upToDate", (Object[])new Object[0]));
            }
        }
        String message = I18n.t((String)"tutti.openDb.step.check.dbContext", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
        progressionModel.increments(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check db context");
        }
        this.getContext().checkDbContext();
        super.doAction();
    }

    public void postSuccessAction() {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        ((MainUIHandler)this.handler).changeTitle();
        if (this.updateSchemaContext.isCloseDb()) {
            this.sendMessage(I18n.t((String)"tutti.flash.info.db.not.opened", (Object[])new Object[]{this.jdbcUrl}));
        } else {
            this.sendMessage(I18n.t((String)"tutti.flash.info.db.opened", (Object[])new Object[]{this.jdbcUrl}));
        }
    }

    @Override
    public void postFailedAction(Throwable error) {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postFailedAction(error);
    }

    public class UpdateSchemaContext
    extends UpdateSchemaContextSupport {
        private boolean closeDb;
        private File file;
        private final File dbBackupDirectory;

        public UpdateSchemaContext(File dbBackupDirectory) {
            this.dbBackupDirectory = dbBackupDirectory;
        }

        @Override
        protected boolean askUserToMigrate(Version schemaVersion, Version schemaVersionIfUpdate) {
            boolean continueAction;
            String message = I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(((MainUIHandler)OpenDbAction.this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), 2, 3);
            boolean bl = continueAction = i == 0;
            if (continueAction) {
                this.file = OpenDbAction.this.saveFile(this.dbBackupDirectory, "tutti-db-" + ExportDbAction.df.format(new Date()), "zip", I18n.t((String)"tutti.dbManager.title.choose.dbBackupFile", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.chooseDbBackupFile", (Object[])new Object[0]), new String[]{"^.*\\.zip", I18n.t((String)"tutti.common.file.zip", (Object[])new Object[0])});
                if (this.file == null) {
                    this.closeDb = true;
                    continueAction = false;
                    OpenDbAction.this.displayWarningMessage(I18n.t((String)"tutti.dbManager.title.choose.dbBackupFile", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.upgradeDb.no.backup.db.choosen", (Object[])new Object[0]));
                } else {
                    continueAction = true;
                }
            } else {
                this.closeDb = true;
            }
            return continueAction;
        }

        @Override
        public void init(Version schemaVersion, Version schemaVersionIfUpdate) {
            super.init(schemaVersion, schemaVersionIfUpdate);
            if (this.isSchemaVersionTooHigh()) {
                OpenDbAction.this.displayWarningMessage(I18n.t((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.not.update.message", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate}));
            }
        }

        public boolean isCloseDb() {
            return this.closeDb;
        }

        public File getFile() {
            return this.file;
        }
    }
}

