/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util.tree;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.service.util.tree.BatchTreeHelperSupport;
import java.io.Serializable;
import java.text.MessageFormat;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class SpeciesBatchTreeHelperSupport
extends BatchTreeHelperSupport {
    private final String prefix;
    private final QualitativeValueId sortingType;
    private final short rootBatchRankOrder;

    protected SpeciesBatchTreeHelperSupport(String prefix, QualitativeValueId sortingType, short rootBatchRankOrder) {
        this.prefix = prefix;
        this.sortingType = sortingType;
        this.rootBatchRankOrder = rootBatchRankOrder;
    }

    public void setBatchParents(Integer sampleCategoryId, Serializable sampleCategoryValue, SortingBatch target, Integer parentBatchId, CatchBatch catchBatch) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)catchBatch);
        target.setRootBatch(catchBatch);
        if (parentBatchId != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, parentBatchId);
        } else {
            if (!sampleCategoryId.equals(PmfmId.SORTED_UNSORTED.getValue())) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species or benthos batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", PmfmId.SORTED_UNSORTED.getValue(), sampleCategoryId));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(sampleCategoryValue);
            if (QualitativeValueId.SORTED_VRAC.getValue().equals(qualitativeValueId)) {
                parentBatch = this.getVracAliveItemizedRootBatch(catchBatch);
                if (parentBatch == null) {
                    SortingBatch vracSpeciesBatch;
                    SortingBatch vracBatch = this.getVracBatch(catchBatch);
                    if (vracBatch == null) {
                        vracBatch = this.getOrCreateVracBatch(catchBatch, null, null);
                    }
                    if ((vracSpeciesBatch = this.getVracRootBatch(vracBatch)) == null) {
                        vracSpeciesBatch = this.getOrCreateVracRootBatch(catchBatch, vracBatch, null);
                    }
                    parentBatch = this.getOrCreateVracAliveItemizedRootBatch(catchBatch, vracSpeciesBatch);
                }
            } else if (QualitativeValueId.SORTED_HORS_VRAC.getValue().equals(qualitativeValueId)) {
                parentBatch = this.getHorsVracRootBatch(catchBatch);
                if (parentBatch == null) {
                    SortingBatch horsVracBatch = this.getOrCreateHorsVracBatch(catchBatch);
                    parentBatch = this.getOrCreateHorsVracRootBatch(catchBatch, horsVracBatch);
                }
            } else {
                throw new DataIntegrityViolationException("Should have Vrac / Hors Vrac qualitative value, but had: " + qualitativeValueId);
            }
        }
        Preconditions.checkNotNull((Object)parentBatch);
        target.setParentBatch((Batch)parentBatch);
    }

    public SortingBatch getVracAliveItemizedRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > " + this.prefix + " > Alive Itemized", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue(), SORTING_TYPE_ID, this.sortingType.getValue(), SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue());
    }

    public SortingBatch getHorsVracRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > " + this.prefix, PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), SORTING_TYPE_ID, this.sortingType.getValue());
    }

    public SortingBatch getVracRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > " + this.prefix, SORTING_TYPE_ID, this.sortingType.getValue());
    }

    public SortingBatch getVracAliveNotItemizedRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > " + this.prefix + " > Alive not itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_NOT_ITEMIZED.getValue());
    }

    public SortingBatch getVracInertRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > " + this.prefix + " > Inert (not alive)", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_INERT.getValue());
    }

    public SortingBatch getVracAliveItemizedRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > " + this.prefix + "> Alive itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue());
    }

    public SortingBatch getHorsVracRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > " + this.prefix, SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue());
    }

    public SortingBatch getOrCreateVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > " + this.prefix, SORTING_TYPE_ID, this.sortingType.getValue(), totalWeight, this.rootBatchRankOrder);
    }

    public SortingBatch getOrCreateVracAliveNotItemizedRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > " + this.prefix + " > Alive Not Itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_NOT_ITEMIZED.getValue(), totalWeight, (short)1);
    }

    public SortingBatch getOrCreateVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > " + this.prefix + " > Inert", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_INERT.getValue(), totalWeight, (short)2);
    }

    public SortingBatch getOrCreateVracAliveItemizedRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > " + this.prefix + " > Alive Itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue(), (short)3);
    }

    public SortingBatch getOrCreateHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, "Hors Vrac > " + this.prefix, SORTING_TYPE_ID, this.sortingType.getValue(), this.rootBatchRankOrder);
    }

    private Integer convertSampleCategoryValueIntoQualitativeId(Serializable value) {
        if (value == null) {
            return null;
        }
        Integer qualitativeValueId = null;
        if (value instanceof CaracteristicQualitativeValue) {
            CaracteristicQualitativeValue cqValue = (CaracteristicQualitativeValue)value;
            qualitativeValueId = cqValue.getIdAsInt();
        } else if (value instanceof String) {
            qualitativeValueId = Integer.valueOf((String)((Object)value));
        }
        return qualitativeValueId;
    }
}

