/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.service.batch.TuttiCatchBatchValidator;
import fr.ifremer.tutti.persistence.service.util.tree.BatchTreeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.stereotype.Component;

@Component(value="scientificCruiseCatchBatchValidator")
public class ScientificCruiseCatchBatchValidator
implements TuttiCatchBatchValidator {
    private static final Log log = LogFactory.getLog(ScientificCruiseCatchBatchValidator.class);
    @Resource(name="batchTreeHelper")
    protected BatchTreeHelper batchTreeHelper;

    public boolean isEnable(CatchBatch catchBatch) {
        return catchBatch.getFishingOperation() != null;
    }

    public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
        ArrayList errors = Lists.newArrayList();
        this.validateCatchBatch(catchBatch, errors);
        return errors;
    }

    @Override
    public List<CatchBatchValidationError> validateSpecies(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> species) {
        ArrayList errors = Lists.newArrayList();
        Map<Integer, SampleCategoryModelEntry> categoriesById = sampleCategoryModel.getCategoryMap();
        for (SpeciesBatch speciesBatch : species.getChildren()) {
            this.validateSampleCategoriesUniverse(sampleCategoryModel, errors, speciesBatch, I18n.n((String)"tutti.persistence.batch.validation.invalid.species.sampleCategoryId", (Object[])new Object[0]));
            if (!errors.isEmpty()) continue;
            this.validateSampleCategoriesOrder(categoriesById, errors, speciesBatch, null, I18n.n((String)"tutti.persistence.batch.validation.invalid.species.sampleCategoryId.order", (Object[])new Object[0]));
        }
        return errors;
    }

    @Override
    public List<CatchBatchValidationError> validateBenthos(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> benthos) {
        ArrayList errors = Lists.newArrayList();
        Map<Integer, SampleCategoryModelEntry> categoriesById = sampleCategoryModel.getCategoryMap();
        for (SpeciesBatch benthosBatch : benthos.getChildren()) {
            this.validateSampleCategoriesUniverse(sampleCategoryModel, errors, benthosBatch, I18n.n((String)"tutti.persistence.batch.validation.invalid.benthos.sampleCategoryId", (Object[])new Object[0]));
            if (!errors.isEmpty()) continue;
            this.validateSampleCategoriesOrder(categoriesById, errors, benthosBatch, null, I18n.n((String)"tutti.persistence.batch.validation.invalid.benthos.sampleCategoryId.order", (Object[])new Object[0]));
        }
        return errors;
    }

    protected void validateCatchBatch(CatchBatch batch, List<CatchBatchValidationError> errors) {
        SortingBatch vracBatch = this.batchTreeHelper.getVracBatch(batch);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to validate Vrac batch model " + vracBatch));
        }
        if (vracBatch == null) {
            this.addError(errors, I18n.n((String)"tutti.persistence.batch.validation.vracNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch aliveItemizedBatch;
            SortingBatch inertBatch;
            SortingBatch livingNotItemizedBatch;
            SortingBatch speciesBatch = this.batchTreeHelper.getSpeciesVracRootBatch(vracBatch);
            SortingBatch benthosBatch = this.batchTreeHelper.getBenthosVracRootBatch(vracBatch);
            if (speciesBatch == null) {
                if (benthosBatch == null) {
                    this.addError(errors, I18n.n((String)"tutti.persistence.batch.validation.vracSpeciesNotFound", (Object[])new Object[0]));
                } else {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracSpeciesNotFound", (Object[])new Object[0]));
                }
            } else {
                livingNotItemizedBatch = this.batchTreeHelper.getSpeciesVracAliveNotItemizedRootBatch(speciesBatch);
                if (livingNotItemizedBatch == null) {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracSpeciesLifeNotFound", (Object[])new Object[0]));
                }
                if ((inertBatch = this.batchTreeHelper.getSpeciesVracInertRootBatch(speciesBatch)) == null) {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracSpeciesInertNotFound", (Object[])new Object[0]));
                }
                if ((aliveItemizedBatch = this.batchTreeHelper.getSpeciesVracAliveItemizedRootBatch(speciesBatch)) == null) {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracSpeciesAliveItemizedNotFound", (Object[])new Object[0]));
                }
            }
            if (benthosBatch == null) {
                if (speciesBatch == null) {
                    this.addError(errors, I18n.n((String)"tutti.persistence.batch.validation.vracBenthosNotFound", (Object[])new Object[0]));
                } else {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracBenthosNotFound", (Object[])new Object[0]));
                }
            } else {
                livingNotItemizedBatch = this.batchTreeHelper.getBenthosVracAliveNotItemizedRootBatch(benthosBatch);
                if (livingNotItemizedBatch == null) {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracBenthosLifeNotFound", (Object[])new Object[0]));
                }
                if ((inertBatch = this.batchTreeHelper.getBenthosVracInertRootBatch(benthosBatch)) == null) {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracBenthosInertNotFound", (Object[])new Object[0]));
                }
                if ((aliveItemizedBatch = this.batchTreeHelper.getBenthosVracAliveItemizedRootBatch(benthosBatch)) == null) {
                    this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.vracBenthosAliveItemizedNotFound", (Object[])new Object[0]));
                }
            }
        }
        SortingBatch horsVracBatch = this.batchTreeHelper.getHorsVracBatch(batch);
        if (horsVracBatch == null) {
            this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.horsVracNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch marineLitterBatch;
            SortingBatch benthosBatch;
            SortingBatch speciesBatch = this.batchTreeHelper.getSpeciesHorsVracRootBatch(horsVracBatch);
            if (speciesBatch == null) {
                this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.horsVracSpeciesNotFound", (Object[])new Object[0]));
            }
            if ((benthosBatch = this.batchTreeHelper.getBenthosHorsVracRootBatch(horsVracBatch)) == null) {
                this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.horsVracBenthosNotFound", (Object[])new Object[0]));
            }
            if ((marineLitterBatch = this.batchTreeHelper.getMarineLitterRootBatch(horsVracBatch)) == null) {
                this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.horsVracMarineLitterNotFound", (Object[])new Object[0]));
            }
        }
        SortingBatch unsortedBatch = this.batchTreeHelper.getRejectedBatch(batch);
        if (unsortedBatch == null) {
            this.addWarning(errors, I18n.n((String)"tutti.persistence.batch.validation.unsortedNotFound", (Object[])new Object[0]));
        }
    }

    protected void validateSampleCategoriesUniverse(SampleCategoryModel sampleCategoryModel, List<CatchBatchValidationError> errors, SpeciesBatch aBatch, String messageKey) {
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        if (!sampleCategoryModel.containsCategoryId(sampleCategoryId)) {
            this.addError(errors, messageKey, aBatch.getId(), aBatch.getSpecies().getName(), sampleCategoryId);
        }
        if (!aBatch.isChildBatchsEmpty()) {
            for (SpeciesBatch speciesAbleBatch : aBatch.getChildBatchs()) {
                this.validateSampleCategoriesUniverse(sampleCategoryModel, errors, speciesAbleBatch, messageKey);
            }
        }
    }

    protected void validateSampleCategoriesOrder(Map<Integer, SampleCategoryModelEntry> categoriesById, List<CatchBatchValidationError> errors, SpeciesBatch aBatch, SampleCategoryModelEntry lastSampleCategory, String messageKey) {
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        SampleCategoryModelEntry actualCategory = categoriesById.get(sampleCategoryId);
        if (lastSampleCategory != null && actualCategory.getOrder() < lastSampleCategory.getOrder()) {
            this.addError(errors, messageKey, aBatch.getId(), aBatch.getSpecies().getName(), actualCategory.getLabel(), lastSampleCategory.getLabel());
            return;
        }
        lastSampleCategory = actualCategory;
        if (!aBatch.isChildBatchsEmpty()) {
            for (SpeciesBatch speciesAbleBatch : aBatch.getChildBatchs()) {
                this.validateSampleCategoriesOrder(categoriesById, errors, speciesAbleBatch, lastSampleCategory, messageKey);
            }
        }
    }

    protected void addError(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n.t((String)messageKey, (Object[])new Object[0]), 2);
        errors.add(error);
    }

    protected void addError(List<CatchBatchValidationError> errors, String messageKey, Object ... params) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n.t((String)messageKey, (Object[])params), 2);
        errors.add(error);
    }

    protected void addWarning(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n.t((String)messageKey, (Object[])new Object[0]), 1);
        errors.add(error);
    }
}

