/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.ClobReader;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;

public class OdaClob
extends OdaDriverObject
implements IClob {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String COMMA_SEPARATOR = ", ";

    protected OdaClob(IClob clob, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)clob, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaClob( Clob , " + connection + " )\t";
        this.logMethodCalled(context);
    }

    private IClob getDriverClob() {
        return (IClob)this.getObject();
    }

    public Reader getCharacterStream() throws OdaException {
        this.logMethodCalled("OdaClob.getCharacterStream()\t");
        try {
            this.setContextClassloader();
            Reader ret = this.getDriverClob().getCharacterStream();
            this.logMethodExitWithReturn("OdaClob.getCharacterStream()\t", ret);
            Reader reader = ret;
            return reader;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IClob.getCharacterStream()");
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public String getSubString(long position, int length) throws OdaException {
        String context = "OdaClob.getSubString( " + position + COMMA_SEPARATOR + length + " )\t";
        this.logMethodCalled(context);
        String ret = null;
        try {
            this.setContextClassloader();
            ret = this.getDriverClob().getSubString(position, length);
            this.logMethodExitWithReturnLen(context, ret);
            String string = ret;
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            ret = this.getSubStringFromReader(position, length);
            if (ret == null) {
                this.handleUnsupportedOp(uoException, "IClob.getSubString()");
                return null;
            }
            this.logMethodExitWithReturnLen(context, ret);
            String string = ret;
            return string;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public long length() throws OdaException {
        this.logMethodCalled("OdaClob.length()\t");
        try {
            this.setContextClassloader();
            long ret = this.getDriverClob().length();
            this.logMethodExitWithReturn("OdaClob.length()\t", ret);
            long l = ret;
            return l;
        }
        catch (UnsupportedOperationException uoException) {
            long l = this.handleUnsupportedOpAndRetZero(uoException, "IClob.length()");
            return l;
        }
        catch (RuntimeException rtException) {
            long l = this.handleErrorAndReturnZero(rtException);
            return l;
        }
        catch (OdaException odaException) {
            long l = this.handleErrorAndReturnZero(odaException);
            return l;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    private String getSubStringFromReader(long startPos, int length) {
        String context = "OdaClob.getSubStringFromReader( " + startPos + COMMA_SEPARATOR + length + " )\t";
        String ret = null;
        try {
            try {
                this.setContextClassloader();
                ClobReader reader = new ClobReader(this, this.getReaderBufferSize());
                ret = reader.getSubString(startPos, length);
            }
            catch (RuntimeException rte) {
                this.handleError(rte);
                this.resetContextClassloader();
            }
            catch (IOException e) {
                this.log(context, e.toString());
                this.resetContextClassloader();
            }
            catch (OdaException ex) {
                this.log(context, ex.toString());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
        return ret;
    }

    protected int getReaderBufferSize() {
        return 2048;
    }
}

