/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.v1.PageHintReaderV1;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.internal.document.v3.PageHintReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.FixedLayoutPageHintReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class PageHintReader
implements IPageHintReader {
    IPageHintReader reader;
    IPageHint cachedHint;

    public PageHintReader(IReportDocument document) throws IOException {
        String version = document.getProperty("page hint version");
        this.reader = "1".equals(version) ? new PageHintReaderV1(document) : ("2".equals(version) ? new PageHintReaderV2(document.getArchive()) : ("4".equals(version) ? new FixedLayoutPageHintReader(document.getArchive()) : new PageHintReaderV3(document.getArchive())));
    }

    @Override
    public int getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public long getTotalPage() throws IOException {
        return this.reader.getTotalPage();
    }

    @Override
    public Collection<PageVariable> getPageVariables() throws IOException {
        return this.reader.getPageVariables();
    }

    @Override
    public IPageHint getPageHint(long pageNumber) throws IOException {
        if (this.cachedHint != null && this.cachedHint.getPageNumber() == pageNumber) {
            return this.cachedHint;
        }
        this.cachedHint = this.reader.getPageHint(pageNumber);
        return this.cachedHint;
    }

    @Override
    public long getPageOffset(long pageNumber, String masterPage) throws IOException {
        return this.reader.getPageOffset(pageNumber, masterPage);
    }
}

