/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSurvey;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportSurveyAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportSurveyAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportSurveyAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.cruises", (Object[])new Object[0]));
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import survey.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.cruises", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getSurveyFileResult();
        try (CsvConsumerForSurvey consumer = this.importContext.loadSurveys(true);){
            for (ImportRow row : consumer) {
                consumer.validateRow(row, this.importContext);
                consumer.prepareRowForPersist(row);
                SurveyRow bean = (SurveyRow)row.getBean();
                Cruise cruise = bean.getCruise();
                Collection<AttachmentRow> attachmentRows = this.importContext.popAttachmentRows(ObjectTypeCode.SCIENTIFIC_CRUISE, bean.getObjectId());
                CruiseDataModel selectionCruiseData = this.importContext.getImportRequest().getSelectedCruise(cruise);
                if (selectionCruiseData == null) {
                    this.skipCruise(cruise);
                    continue;
                }
                this.processCruise(cruise, attachmentRows, selectionCruiseData);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close survey.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }

    protected void skipCruise(Cruise cruise) {
        String cruiseStr = this.importContext.decorate(cruise);
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.skipNotSelected.cruise", (Object[])new Object[]{cruiseStr}));
        this.importContext.addSkippedCruise(cruise);
    }

    protected void processCruise(Cruise cruise, Collection<AttachmentRow> attachmentRows, CruiseDataModel selectionCruiseData) {
        Set<FishingOperation> existingFishingOperations;
        Cruise savedCruise;
        String cruiseStr = this.importContext.decorate(cruise);
        CruiseDataModel existingCruiseData = this.importContext.getImportRequest().getExistingCruiseData(cruise);
        if (existingCruiseData == null) {
            this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.create.cruise", (Object[])new Object[]{cruiseStr}));
            savedCruise = this.addCruise(cruise, attachmentRows);
            existingFishingOperations = null;
        } else {
            if (this.importContext.getImportRequest().isUpdateCruises()) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.update.cruise", (Object[])new Object[]{cruiseStr}));
                savedCruise = this.updateCruise(cruise, attachmentRows);
            } else {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.skip.cruise", (Object[])new Object[]{cruiseStr}));
                savedCruise = cruise;
            }
            existingFishingOperations = this.persistenceHelper.getFishingOperations(existingCruiseData.getIdAsInt());
        }
        this.importContext.addImportedCruise(savedCruise, selectionCruiseData, existingCruiseData, existingFishingOperations);
    }

    public Cruise addCruise(Cruise cruise, Collection<AttachmentRow> attachmentRows) {
        String cruiseStr = this.importContext.decorate(cruise);
        boolean createCruise = TuttiEntities.isNew((TuttiEntity)cruise);
        Preconditions.checkState((boolean)createCruise, (Object)("In addCruise method, can't update existing cruise: " + cruiseStr));
        if (log.isInfoEnabled()) {
            log.info((Object)("Create cruise: " + cruiseStr));
        }
        Cruise savedCruise = this.persistenceHelper.createCruise(cruise);
        boolean importAttachments = this.importContext.getImportRequest().isImportAttachments();
        if (importAttachments && CollectionUtils.isNotEmpty(attachmentRows)) {
            this.persistenceHelper.persistAttachments(savedCruise.getIdAsInt(), attachmentRows);
        }
        return savedCruise;
    }

    public Cruise updateCruise(Cruise cruise, Collection<AttachmentRow> attachmentRows) {
        String cruiseStr = this.importContext.decorate(cruise);
        boolean createCruise = TuttiEntities.isNew((TuttiEntity)cruise);
        Preconditions.checkState((!createCruise ? 1 : 0) != 0, (Object)("In updateCruise method, can't create new cruise: " + cruiseStr));
        Preconditions.checkState((boolean)this.importContext.getImportRequest().isUpdateCruises(), (Object)("In updateCruise method, must be allowed to update cruise: " + cruiseStr));
        if (log.isInfoEnabled()) {
            log.info((Object)("Update existing cruise: " + cruiseStr));
        }
        Cruise savedCruise = this.persistenceHelper.saveCruise(cruise);
        boolean importAttachments = this.importContext.getImportRequest().isImportAttachments();
        if (importAttachments) {
            this.persistenceHelper.deleteAllAttachments(ObjectTypeCode.SCIENTIFIC_CRUISE, cruise.getIdAsInt());
            this.persistenceHelper.persistAttachments(savedCruise.getIdAsInt(), attachmentRows);
        }
        return savedCruise;
    }
}

