/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.computable;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXUtil;

public class ComputableDataTableCell
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    public static TableCellRenderer newRender(TableCellRenderer renderer, WeightUnit weightUnit, Color computedDataColor) {
        return new TuttiComputedOrNotDataTableCellRenderer(weightUnit, renderer, computedDataColor);
    }

    public static TableCellEditor newEditor(WeightUnit weightUnit, Color computedDataColor) {
        return new TuttiComputedOrNotDataTableCellEditor(weightUnit, computedDataColor);
    }

    private static class TuttiComputedOrNotDataTableCellRenderer
    implements TableCellRenderer {
        private final WeightUnit weightUnit;
        protected final TableCellRenderer delegate;
        protected Color computedDataColor;

        private TuttiComputedOrNotDataTableCellRenderer(WeightUnit weightUnit, TableCellRenderer delegate, Color computedDataColor) {
            this.weightUnit = weightUnit;
            this.delegate = delegate;
            this.computedDataColor = computedDataColor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            Color foreground;
            Font font;
            ComputableData data = (ComputableData)((Object)value);
            Float dataValue = (Float)data.getData();
            if (dataValue == null) {
                dataValue = (Float)data.getComputedData();
                font = TuttiUI.TEXTFIELD_COMPUTED_FONT;
                foreground = this.computedDataColor;
                text = this.weightUnit.renderWeight(dataValue);
            } else {
                font = TuttiUI.TEXTFIELD_NORMAL_FONT;
                foreground = Color.BLACK;
                text = JAXXUtil.getStringValue((Object)dataValue);
            }
            Component component = this.delegate.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            if (isSelected) {
                font = font.deriveFont(1);
            }
            component.setFont(font);
            component.setForeground(foreground);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(4);
            }
            return component;
        }
    }

    public static class TuttiComputedOrNotDataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    AncestorListener {
        private static final long serialVersionUID = 1L;
        private final ComputableDataEditor<Float> numberEditor = new ComputableDataEditor();
        private ComputableData<Float> data;

        public TuttiComputedOrNotDataTableCellEditor(WeightUnit weightUnit, Color computedDataColor) {
            this.numberEditor.setComputedDataColor(computedDataColor);
            this.numberEditor.getTextField().setHorizontalAlignment(4);
            this.numberEditor.getTextField().addFocusListener(this);
            this.numberEditor.getTextField().addAncestorListener(this);
            this.numberEditor.getTextField().setBorder(new LineBorder(Color.GRAY, 2));
            this.numberEditor.setSelectAllTextOnError(true);
            this.numberEditor.setNumberType(Float.class);
            this.numberEditor.setUseSign(false);
            this.numberEditor.init();
            this.numberEditor.setWeightUnit(weightUnit);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.data = (ComputableData)((Object)value);
            this.numberEditor.setNumberValue(this.data.getData());
            return this.numberEditor;
        }

        public ComputableDataEditor getNumberEditor() {
            return this.numberEditor;
        }

        public ComputableData<Float> getCellEditorValue() {
            return this.data;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(() -> {
                this.numberEditor.getTextField().requestFocus();
                this.numberEditor.getTextField().selectAll();
            });
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SwingUtilities.invokeLater(() -> {
                this.numberEditor.getTextField().requestFocus();
                this.numberEditor.getTextField().selectAll();
            });
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public boolean stopCellEditing() {
            boolean result = super.stopCellEditing();
            if (result) {
                this.data.setData((Float)this.numberEditor.getModel().getNumberValue());
                this.numberEditor.setBean(null);
                this.data = null;
            }
            return result;
        }
    }
}

