/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.caracteristics;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.nuiton.decorator.Decorator;

public class CaracteristicValueEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    protected int caracteristicColumn;
    protected TableCellEditor editor;
    protected Decorator<CaracteristicQualitativeValue> decorator;

    public CaracteristicValueEditor(TuttiUIContext context) {
        this(0, context);
    }

    public CaracteristicValueEditor(int caracteristicColumn, TuttiUIContext context) {
        this.caracteristicColumn = caracteristicColumn;
        DecoratorService decoratorService = context.getDecoratorService();
        this.decorator = decoratorService.getDecoratorByType(CaracteristicQualitativeValue.class);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Caracteristic caracteristic = (Caracteristic)table.getModel().getValueAt(row, this.caracteristicColumn);
        if (caracteristic != null) {
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)false);
                    editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
                    editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
                    this.editor = editor;
                    break;
                }
                case QUALITATIVE: {
                    JComboBox comboBox = new JComboBox();
                    comboBox.setRenderer(new DecoratorListCellRenderer(this.decorator));
                    ArrayList data = Lists.newArrayList(caracteristic.getQualitativeValue());
                    if (!data.isEmpty() && data.get(0) != null) {
                        data.add(0, null);
                    }
                    SwingUtil.fillComboBox(comboBox, (Collection)data, null);
                    ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(this.decorator);
                    BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
                    this.editor = new ComboBoxCellEditor(comboBox);
                    break;
                }
                case TEXT: {
                    this.editor = table.getDefaultEditor(Object.class);
                }
            }
        }
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

