/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.cruise.CruiseCache;
import fr.ifremer.tutti.service.sampling.CalcifiedPiecesSamplingAlgorithmEntryNotFoundException;
import fr.ifremer.tutti.service.sampling.CruiseSamplingCache;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingCacheRequest;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingStatus;
import fr.ifremer.tutti.service.sampling.SizeNotDefinedOnIndividualObservationException;
import fr.ifremer.tutti.service.sampling.ZoneNotDefinedOnFishingOperationException;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualObservationUICache
implements Closeable {
    private static final Log log = LogFactory.getLog(IndividualObservationUICache.class);
    private final CruiseSamplingCache cruiseSamplingCache;
    private final boolean useCruiseSamplingCache;
    private final SpeciesFrequencyUIModel uiModel;
    private boolean speciesDefinedInCalcifiedPiecesSampling;
    private Zone fishingOperationZone;

    public IndividualObservationUICache(CruiseCache cruiseCache, SpeciesFrequencyUIModel uiModel) {
        this.useCruiseSamplingCache = cruiseCache.useSamplingCache();
        this.cruiseSamplingCache = cruiseCache.getSamplingCruiseCache().orElse(null);
        this.uiModel = uiModel;
    }

    public boolean useCruiseSamplingCache() {
        return this.useCruiseSamplingCache;
    }

    public boolean isSpeciesDefinedInCalcifiedPiecesSampling() {
        return this.speciesDefinedInCalcifiedPiecesSampling;
    }

    public boolean isFishingOperationWithZone() {
        return this.fishingOperationZone != null;
    }

    public void initFishingOperation(FishingOperation fishingOperation) {
        Objects.requireNonNull(fishingOperation);
        if (this.useCruiseSamplingCache) {
            Optional optionalZone = this.cruiseSamplingCache.tryFindZone(fishingOperation);
            if (log.isInfoEnabled()) {
                log.info((Object)("Init fishing operation zone: " + optionalZone));
            }
            this.fishingOperationZone = optionalZone.orElse(null);
        }
    }

    public void init(Species species, List<IndividualObservationBatchRowModel> individualObservations, boolean addToCache) {
        Objects.requireNonNull(species);
        Objects.requireNonNull(individualObservations);
        if (this.useCruiseSamplingCache) {
            this.speciesDefinedInCalcifiedPiecesSampling = this.cruiseSamplingCache.isSpeciesDefined(species);
        }
        if (addToCache) {
            this.addIndividualObservations(individualObservations);
        }
    }

    @Override
    public void close() {
        this.fishingOperationZone = null;
    }

    public IndividualObservationSamplingStatus getIndividualObservationSamplingStatus(IndividualObservationBatchRowModel row) throws CalcifiedPiecesSamplingAlgorithmEntryNotFoundException, SizeNotDefinedOnIndividualObservationException, ZoneNotDefinedOnFishingOperationException {
        Objects.requireNonNull(row);
        IndividualObservationSamplingCacheRequest samplingCacheRequest = this.uiModel.toSamplingCacheRequest(row);
        return this.cruiseSamplingCache.getIndividualObservationSamplingStatus(samplingCacheRequest);
    }

    public void addIndividualObservations(Collection<IndividualObservationBatchRowModel> individualObservationRows) {
        Objects.requireNonNull(individualObservationRows);
        individualObservationRows.stream().filter(IndividualObservationBatchRowModel::withSize).forEach(row -> {
            IndividualObservationSamplingCacheRequest samplingCacheRequest = this.uiModel.toSamplingCacheRequest((IndividualObservationBatchRowModel)row);
            this.addIndividualObservation(samplingCacheRequest);
        });
    }

    public void removeIndividualObservations(Collection<IndividualObservationBatchRowModel> individualObservationRows) {
        Objects.requireNonNull(individualObservationRows);
        individualObservationRows.stream().filter(IndividualObservationBatchRowModel::withSize).forEach(row -> {
            block2: {
                IndividualObservationSamplingCacheRequest samplingCacheRequest = this.uiModel.toSamplingCacheRequest((IndividualObservationBatchRowModel)row);
                try {
                    this.removeIndividualObservation(samplingCacheRequest);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block2;
                    log.error((Object)"Could not remove individual observation", (Throwable)e);
                }
            }
        });
    }

    public void addIndividualObservation(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Objects.requireNonNull(samplingCacheRequest);
        if (this.useCruiseSamplingCache && samplingCacheRequest.withLengthClass()) {
            this.cruiseSamplingCache.addIndividualObservation(samplingCacheRequest);
        }
    }

    public void removeIndividualObservation(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Objects.requireNonNull(samplingCacheRequest);
        if (this.useCruiseSamplingCache && samplingCacheRequest.withLengthClass()) {
            this.cruiseSamplingCache.removeIndividualObservation(samplingCacheRequest);
        }
    }

    public void addSampling(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Objects.requireNonNull(samplingCacheRequest);
        String samplingCode = samplingCacheRequest.getSamplingCode();
        Objects.requireNonNull(samplingCode);
        if (this.useCruiseSamplingCache && samplingCacheRequest.withLengthClass()) {
            this.cruiseSamplingCache.addSampling(samplingCacheRequest);
        }
    }

    public void removeSampling(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Objects.requireNonNull(samplingCacheRequest);
        String samplingCode = samplingCacheRequest.getSamplingCode();
        Objects.requireNonNull(samplingCode);
        if (this.useCruiseSamplingCache && samplingCacheRequest.withLengthClass()) {
            this.cruiseSamplingCache.removeSampling(samplingCacheRequest);
        }
    }
}

