/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.sampling.SamplingCodePrefix;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.SamplingCodeCellEditor;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.SamplingCodeCellRenderer;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowState;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationToFrequencyEngine;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationToSamplingCacheEngine;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.MaturityColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class IndividualObservationBatchTableHandler
implements Closeable {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchTableHandler.class);
    private final SpeciesFrequencyUIHandler uiHandler;
    private final JXTable individualObservationTable;
    private final SpeciesFrequencyUIModel model;
    private final IndividualObservationBatchUIModel individualObservationsModel;
    private final SpeciesFrequencyTableModel frequencyTableModel;
    private final IndividualObservationBatchTableModel individualObservationTableModel;
    private final Map<String, Caracteristic> maturityCaracteristics;
    private final Decorator<Species> speciesDecorator;
    private final Decorator<Caracteristic> caracteristicDecorator;
    private final Decorator<Caracteristic> caracteristicTipDecorator;
    private final IndividualObservationToFrequencyEngine individualObservationToFrequencyEngine;
    private final IndividualObservationToSamplingCacheEngine individualObservationToSamplingCacheEngine;
    private final PropertyChangeListener individualObservationRowSizeChangedListener;
    private final PropertyChangeListener individualObservationRowWeightChangedListener;
    private final PropertyChangeListener individualObservationRowSamplingCodeChangedListener;
    private final PropertyChangeListener individualObservationRowCaracteristicsChangedListener;
    protected final CaracteristicMapCellComponent.CaracteristicMapCellEditor otherCaracteristicsEditor;

    public IndividualObservationBatchTableHandler(SpeciesFrequencyUI ui) {
        this.model = ui.getModel();
        this.individualObservationsModel = ui.getModel().getIndividualObservationModel();
        this.uiHandler = ui.getHandler();
        this.speciesDecorator = this.uiHandler.getDecorator(Species.class, "withSurveyCodeNoName");
        this.caracteristicDecorator = this.uiHandler.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
        this.caracteristicTipDecorator = this.uiHandler.getDecorator(Caracteristic.class, "withUnit");
        this.individualObservationTable = ui.getObsTable();
        this.frequencyTableModel = this.uiHandler.getTableModel();
        this.individualObservationToFrequencyEngine = new IndividualObservationToFrequencyEngine(this.model);
        this.individualObservationToSamplingCacheEngine = new IndividualObservationToSamplingCacheEngine(this.model);
        ArrayList maturityCaracteristics = new ArrayList(this.uiHandler.getDataContext().getMaturityCaracteristics());
        this.maturityCaracteristics = TuttiEntities.splitById(maturityCaracteristics);
        this.individualObservationRowSizeChangedListener = event -> {
            IndividualObservationBatchRowModel source = (IndividualObservationBatchRowModel)event.getSource();
            Float oldSize = (Float)event.getOldValue();
            Float weight = source.getWeight();
            CaracteristicQualitativeValue maturity = this.individualObservationsModel.getMaturityValue(source);
            CaracteristicQualitativeValue gender = this.individualObservationsModel.getGender(source);
            String samplingCode = source.getSamplingCode();
            boolean oldValid = source.computeValid(oldSize != null, weight != null);
            boolean newValid = source.computeValid();
            IndividualObservationBatchRowState oldState = new IndividualObservationBatchRowState(oldSize, weight, maturity, gender, samplingCode, oldValid);
            IndividualObservationBatchRowState newState = new IndividualObservationBatchRowState(source.getSize(), weight, maturity, gender, samplingCode, newValid);
            this.onSamplingRowChanged(source, oldState, newState);
            this.onRowChangedForFrequencies(source, oldState, newState);
            this.individualObservationsModel.recomputeRowValidState(source);
            this.model.recomputeCanEditLengthStep();
            this.model.setModify(true);
        };
        this.individualObservationRowWeightChangedListener = event -> {
            IndividualObservationBatchRowModel source = (IndividualObservationBatchRowModel)event.getSource();
            if (source.withSize()) {
                Float oldWeight = (Float)event.getOldValue();
                Float size = source.getSize();
                CaracteristicQualitativeValue maturity = this.individualObservationsModel.getMaturityValue(source);
                CaracteristicQualitativeValue gender = this.individualObservationsModel.getGender(source);
                String samplingCode = source.getSamplingCode();
                boolean oldValid = source.computeValid(size != null, oldWeight != null);
                boolean newValid = source.computeValid();
                IndividualObservationBatchRowState oldState = new IndividualObservationBatchRowState(size, oldWeight, maturity, gender, samplingCode, oldValid);
                IndividualObservationBatchRowState newState = new IndividualObservationBatchRowState(size, source.getWeight(), maturity, gender, samplingCode, newValid);
                this.onSamplingRowChanged(source, oldState, newState);
                this.onRowChangedForFrequencies(source, oldState, newState);
            } else {
                this.individualObservationsModel.recomputeRowValidState(source);
            }
            this.model.recomputeCanEditLengthStep();
            this.model.setModify(true);
        };
        this.individualObservationRowSamplingCodeChangedListener = event -> {
            IndividualObservationBatchRowModel source = (IndividualObservationBatchRowModel)event.getSource();
            if (source.withSize()) {
                String oldSamplingCode = (String)event.getOldValue();
                Float size = source.getSize();
                Float weight = source.getWeight();
                CaracteristicQualitativeValue maturity = this.individualObservationsModel.getMaturityValue(source);
                CaracteristicQualitativeValue gender = this.individualObservationsModel.getGender(source);
                boolean validState = source.computeValid();
                IndividualObservationBatchRowState oldState = new IndividualObservationBatchRowState(size, weight, maturity, gender, oldSamplingCode, validState);
                IndividualObservationBatchRowState newState = new IndividualObservationBatchRowState(size, weight, maturity, gender, source.getSamplingCode(), validState);
                this.onSamplingRowChanged(source, oldState, newState);
            } else {
                this.individualObservationsModel.recomputeRowValidState(source);
            }
            this.model.setModify(true);
        };
        this.individualObservationRowCaracteristicsChangedListener = event -> {
            IndividualObservationBatchRowModel source = (IndividualObservationBatchRowModel)event.getSource();
            if (source.withSize()) {
                CaracteristicQualitativeValue newMaturity;
                CaracteristicQualitativeValue oldMaturity;
                CaracteristicQualitativeValue newGender;
                CaracteristicMap oldCaracteristicMap = (CaracteristicMap)event.getOldValue();
                CaracteristicQualitativeValue oldGender = this.individualObservationsModel.getGender(oldCaracteristicMap);
                if (!Objects.equals(oldGender, newGender = this.individualObservationsModel.getGender(source))) {
                    Float size = source.getSize();
                    Float weight = source.getWeight();
                    CaracteristicQualitativeValue maturity = this.individualObservationsModel.getMaturityValue(source);
                    String samplingCode = source.getSamplingCode();
                    boolean validState = source.computeValid();
                    IndividualObservationBatchRowState oldState = new IndividualObservationBatchRowState(size, weight, maturity, oldGender, samplingCode, validState);
                    IndividualObservationBatchRowState newState = new IndividualObservationBatchRowState(size, weight, maturity, newGender, samplingCode, validState);
                    this.onSamplingRowChanged(source, oldState, newState);
                } else if (this.individualObservationsModel.withMaturityCaracteristic() && !Objects.equals(oldMaturity = this.individualObservationsModel.getMaturityValue(oldCaracteristicMap), newMaturity = this.individualObservationsModel.getMaturityValue(source))) {
                    Float size = source.getSize();
                    Float weight = source.getWeight();
                    CaracteristicQualitativeValue gender = this.individualObservationsModel.getGender(source);
                    String samplingCode = source.getSamplingCode();
                    boolean validState = source.computeValid();
                    IndividualObservationBatchRowState oldState = new IndividualObservationBatchRowState(size, weight, oldMaturity, gender, samplingCode, validState);
                    IndividualObservationBatchRowState newState = new IndividualObservationBatchRowState(size, weight, newMaturity, gender, samplingCode, validState);
                    this.onSamplingRowChanged(source, oldState, newState);
                }
            } else {
                this.individualObservationsModel.recomputeRowValidState(source);
            }
            this.model.setModify(true);
        };
        this.individualObservationTable.setColumnControlVisible(true);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.uiHandler.addIntegerColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.RANK, "\\d{0,10}", (JTable)this.individualObservationTable);
        this.uiHandler.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.SIZE, "\\d{0,6}(\\.\\d{0,3})?", (JTable)this.individualObservationTable);
        WeightUnit individualObservationWeightUnit = this.uiHandler.getConfig().getIndividualObservationWeightUnit();
        this.uiHandler.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.WEIGHT, individualObservationWeightUnit, (JTable)this.individualObservationTable);
        Caracteristic sexCaracteristic = this.individualObservationsModel.getSexCaracteristic();
        this.uiHandler.addCaracteristicColumnToModel(this.individualObservationTable, (TableColumnModelExt)columnModel, sexCaracteristic);
        ArrayList<Caracteristic> defaultCaracteristic = new ArrayList<Caracteristic>(this.individualObservationsModel.getProtocolIndividualObservationCaracteristics());
        defaultCaracteristic.remove(sexCaracteristic);
        for (Caracteristic caracteristic : defaultCaracteristic) {
            this.uiHandler.addCaracteristicColumnToModel(this.individualObservationTable, (TableColumnModelExt)columnModel, caracteristic);
        }
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator = this.uiHandler.getDecorator(CaracteristicQualitativeValue.class, null);
        this.uiHandler.addComboDataColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.MATURITY, caracteristicQualitativeDecorator, new ArrayList());
        this.otherCaracteristicsEditor = CaracteristicMapCellComponent.newEditor(ui, new HashSet<Caracteristic>());
        this.uiHandler.addColumnToModel((TableColumnModel)columnModel, this.otherCaracteristicsEditor, CaracteristicMapCellComponent.newRender(this.uiHandler.getContext()), IndividualObservationBatchTableModel.OTHER_CARACTERISTICS);
        this.uiHandler.addColumnToModel((TableColumnModel)columnModel, SamplingCodeCellEditor.newEditor(this.model), SamplingCodeCellRenderer.newRender(), IndividualObservationBatchTableModel.SAMPLING_CODE);
        this.uiHandler.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(ui), CommentCellRenderer.newRender(), IndividualObservationBatchTableModel.COMMENT);
        this.uiHandler.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(ui), AttachmentCellRenderer.newRender(this.uiHandler.getDecorator(Attachment.class, null)), IndividualObservationBatchTableModel.ATTACHMENT);
        Function<IndividualObservationBatchRowModel, Void> installListenersOnRow = row -> {
            row.addPropertyChangeListener("size", this.individualObservationRowSizeChangedListener);
            row.addPropertyChangeListener("weight", this.individualObservationRowWeightChangedListener);
            row.addPropertyChangeListener("samplingCode", this.individualObservationRowSamplingCodeChangedListener);
            row.addPropertyChangeListener("caracteristics", this.individualObservationRowCaracteristicsChangedListener);
            row.addPropertyChangeListener("defaultCaracteristics", this.individualObservationRowCaracteristicsChangedListener);
            return null;
        };
        Function<IndividualObservationBatchRowModel, Void> uninstallListenersOnRow = row -> {
            row.removePropertyChangeListener("size", this.individualObservationRowSizeChangedListener);
            row.removePropertyChangeListener("weight", this.individualObservationRowWeightChangedListener);
            row.removePropertyChangeListener("samplingCode", this.individualObservationRowSamplingCodeChangedListener);
            row.removePropertyChangeListener("caracteristics", this.individualObservationRowCaracteristicsChangedListener);
            row.removePropertyChangeListener("defaultCaracteristics", this.individualObservationRowCaracteristicsChangedListener);
            return null;
        };
        this.individualObservationTableModel = new IndividualObservationBatchTableModel(individualObservationWeightUnit, this.model, (TableColumnModelExt)columnModel, installListenersOnRow, uninstallListenersOnRow);
        this.individualObservationsModel.setIndividualObservationTableModel(this.individualObservationTableModel);
        this.individualObservationTable.setModel((TableModel)((Object)this.individualObservationTableModel));
        this.individualObservationTable.setColumnModel((TableColumnModel)columnModel);
        this.individualObservationTable.getTableHeader().setReorderingAllowed(false);
        this.uiHandler.addHighlighters(this.individualObservationTable);
        Color cellWithValueColor = this.uiHandler.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{IndividualObservationBatchTableModel.COMMENT}), (renderer, adapter) -> {
            String value = (String)adapter.getValue();
            return StringUtils.isNotBlank((CharSequence)value);
        }}), (Color)cellWithValueColor);
        this.individualObservationTable.addHighlighter(commentHighlighter);
        this.uiHandler.installTableKeyListener((TableColumnModel)columnModel, (JTable)this.individualObservationTable, false);
        SwingUtil.scrollToTableSelection((JTable)this.individualObservationTable);
        this.individualObservationsModel.addPropertyChangeListener("rows", evt -> this.individualObservationTableModel.setRows((List)evt.getNewValue()));
        this.model.addPropertyChangeListener("copyIndividualObservationMode", evt -> {
            boolean nothingCopyMode;
            SpeciesFrequencyUIModel source = (SpeciesFrequencyUIModel)evt.getSource();
            CopyIndividualObservationMode oldCopyMode = (CopyIndividualObservationMode)((Object)((Object)evt.getOldValue()));
            CopyIndividualObservationMode newCopyMode = (CopyIndividualObservationMode)((Object)((Object)evt.getNewValue()));
            if (newCopyMode == null) {
                return;
            }
            boolean bl = nothingCopyMode = CopyIndividualObservationMode.NOTHING == newCopyMode;
            if (!nothingCopyMode) {
                source.setFrequenciesConfigurationMode(FrequencyConfigurationMode.RAFALE);
                source.setAddIndividualObservationOnRafale(true);
            }
            if (source.isInitBatchEdition()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Skip recompute frequencies from indivudal observations (flag initBatchEdition is on), copyIndividualObservationMode changed from " + (Object)((Object)oldCopyMode) + " to " + (Object)((Object)newCopyMode)));
                }
                return;
            }
            this.model.clear();
            this.model.reloadRows();
            this.individualObservationsModel.setCopyIndividualObservationMode(newCopyMode);
            this.frequencyTableModel.reloadRowsFromIndividualObservations();
        });
        this.model.addPropertyChangeListener("lengthStepCaracteristic", evt -> {
            Caracteristic newValue = (Caracteristic)evt.getNewValue();
            this.individualObservationTableModel.setLengthstepCaracteristic(newValue);
        });
    }

    @Override
    public void close() {
        this.model.getIndividualObservationUICache().close();
        this.model.getSamplingCodeUICache().close();
    }

    public List<IndividualObservationBatchRowModel> loadRows(Species species, List<IndividualObservationBatchRowModel> individualObservations) {
        this.individualObservationTableModel.setSpecies(species);
        SamplingCodePrefix samplingCodePrefix = new SamplingCodePrefix(this.uiHandler.getConfig().getSamplingCodePrefix(), this.speciesDecorator.toString((Object)species));
        this.individualObservationsModel.setSamplingCodePrefix(samplingCodePrefix);
        return this.individualObservationTableModel.loadRows(individualObservations);
    }

    public void loadSpeciesBatch(SpeciesBatchRowModel speciesBatch, List<IndividualObservationBatchRowModel> individualObservationRows, boolean addToCache) {
        this.individualObservationsModel.setRows(individualObservationRows);
        this.model.getIndividualObservationUICache().init(speciesBatch.getSpecies(), this.individualObservationsModel.getRows(), addToCache);
        this.model.getSamplingCodeUICache().init(speciesBatch.getSpecies(), this.individualObservationsModel.getRows(), addToCache);
        this.individualObservationTable.packAll();
    }

    public boolean isSampleCodeMenusEnabled(int modelRowIndex) {
        return modelRowIndex >= 0 && this.individualObservationTable.getSelectedRowCount() == 1 && ((IndividualObservationBatchRowModel)this.individualObservationTableModel.getRows().get(this.individualObservationTable.getSelectedRow())).withSamplingCode();
    }

    public void initMaturityCaracteristic(SpeciesProtocol speciesProtocol) {
        String tip;
        String title;
        List dataList;
        Caracteristic maturityCaracteristic = speciesProtocol == null ? null : this.maturityCaracteristics.get(speciesProtocol.getMaturityPmfmId());
        this.individualObservationsModel.setMaturityCaracteristic(maturityCaracteristic);
        MaturityColumnIdentifier columnIdentifier = IndividualObservationBatchTableModel.MATURITY;
        columnIdentifier.setCaracteristic(maturityCaracteristic);
        TableColumnExt columnModel = ((TableColumnModelExt)this.individualObservationTable.getColumnModel()).getColumnExt((Object)columnIdentifier);
        boolean noMaturity = maturityCaracteristic == null;
        columnModel.setVisible(!noMaturity);
        ComboBoxCellEditor cellEditor = (ComboBoxCellEditor)columnModel.getCellEditor();
        JComboBox comboBox = (JComboBox)cellEditor.getComponent();
        if (noMaturity) {
            dataList = Collections.emptyList();
            title = I18n.t((String)columnIdentifier.getHeaderI18nKey(), (Object[])new Object[0]);
            tip = I18n.t((String)columnIdentifier.getHeaderTipI18nKey(), (Object[])new Object[0]);
        } else {
            dataList = new ArrayList<CaracteristicQualitativeValue>(maturityCaracteristic.getQualitativeValue());
            if (!dataList.isEmpty() && dataList.get(0) != null) {
                dataList.add(0, null);
            }
            title = this.caracteristicDecorator.toString((Object)maturityCaracteristic);
            tip = this.caracteristicTipDecorator.toString((Object)maturityCaracteristic);
        }
        columnModel.setTitle(title);
        columnModel.setToolTipText(tip);
        SwingUtil.fillComboBox((JComboBox)comboBox, dataList, null);
    }

    public void initDefaultCaracteristics(SpeciesBatchRowModel speciesBatch) {
        HashSet<Caracteristic> defaultCaracteristics = new HashSet<Caracteristic>();
        defaultCaracteristics.addAll(this.individualObservationsModel.getProtocolIndividualObservationCaracteristics());
        defaultCaracteristics.add(this.individualObservationsModel.getSexCaracteristic());
        if (this.individualObservationsModel.withMaturityCaracteristic()) {
            defaultCaracteristics.add(this.individualObservationsModel.getMaturityCaracteristic());
        }
        this.otherCaracteristicsEditor.setCaracteristicsToSkip(defaultCaracteristics);
        CaracteristicMap defaultCaracteristicMap = CaracteristicMap.fromCollection(defaultCaracteristics);
        CaracteristicMap sampleCategoryValues = new CaracteristicMap();
        Iterator<SampleCategory<?>> iterator = speciesBatch.iterator();
        iterator.forEachRemaining(sampleCategory -> {
            Caracteristic caracteristic = sampleCategory.getCategoryDef().getCaracteristic();
            defaultCaracteristicMap.replace(caracteristic, sampleCategory.getCategoryValue());
            sampleCategoryValues.put(caracteristic, (Serializable)sampleCategory.getCategoryValue());
        });
        this.individualObservationTableModel.setDefaultCaracteristics(defaultCaracteristicMap);
        this.individualObservationsModel.setNotEditableCaracteristic(sampleCategoryValues.keySet());
    }

    private void onSamplingRowChanged(IndividualObservationBatchRowModel row, IndividualObservationBatchRowState oldValue, IndividualObservationBatchRowState newValue) {
        boolean needUpdateSamplingNotificationZone = this.individualObservationToSamplingCacheEngine.computeSamplingCacheUpdate(oldValue, newValue);
        if (needUpdateSamplingNotificationZone) {
            this.individualObservationsModel.getSamplingNotificationZoneModel().setUpdatedRow(row);
        }
    }

    private void onRowChangedForFrequencies(IndividualObservationBatchRowModel row, IndividualObservationBatchRowState oldValue, IndividualObservationBatchRowState newValue) {
        boolean needRecomputeRowsValidState = this.individualObservationToFrequencyEngine.computeFrequencyUpdate(this.model.getCopyIndividualObservationMode(), oldValue, newValue);
        if (needRecomputeRowsValidState) {
            this.individualObservationsModel.recomputeRowValidState(row);
        }
    }
}

