/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.ui.swing.util.SoundUtil;
import fr.ifremer.tutti.util.BeepFrequency;
import java.io.Closeable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class SoundEngine
implements Closeable {
    private static final Log log = LogFactory.getLog(SoundEngine.class);
    protected final TuttiConfiguration configuration;
    protected final Thread thread;
    protected final LinkedBlockingQueue<Object> soundsToPlay;
    protected boolean stop;

    public SoundEngine(TuttiConfiguration configuration) {
        this.configuration = configuration;
        this.thread = new Thread((Runnable)new SoundEngineRunnable(), this.toString());
        this.soundsToPlay = new LinkedBlockingQueue();
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting sound engine thread: " + this.thread));
        }
    }

    public void open() {
        this.thread.start();
    }

    public synchronized void beepOnIchtyometerDataReception(String unit, float aroundLengthStep) {
        if (this.configuration.isIchtyometerDataReceptionBeepEnabled().booleanValue()) {
            this.soundsToPlay.add(this.configuration.getIchtyometerDataReceptionBeepFrequency());
        }
        if (this.configuration.isIchtyometerVoiceEnabled().booleanValue()) {
            this.soundsToPlay.add(new Measure(unit, aroundLengthStep));
        }
    }

    public synchronized void beepOnIchtyometerErrorReception() {
        if (this.configuration.isIchtyometerErrorReceptionBeepEnabled().booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                this.soundsToPlay.add(this.configuration.getIchtyometerDataReceptionBeepFrequency());
            }
        }
    }

    @Override
    public synchronized void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Stopping sound engine thread: " + this.thread));
        }
        this.stop = true;
        this.thread.interrupt();
    }

    protected class SoundEngineRunnable
    implements Runnable {
        protected SoundEngineRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    do {
                        Object sound;
                        if ((sound = SoundEngine.this.soundsToPlay.poll(1L, TimeUnit.SECONDS)) == null) continue;
                        if (sound instanceof Measure) {
                            Measure measure = (Measure)sound;
                            if (log.isInfoEnabled()) {
                                log.info((Object)("New Measure to say: " + measure));
                            }
                            String unit = SoundEngine.this.configuration.isIchtyometerReadsUnit() != false ? measure.unit : null;
                            SoundUtil.readNumber(measure.aroundLengthStep, (Optional<String>)Optional.fromNullable((Object)unit));
                            continue;
                        }
                        if (!(sound instanceof BeepFrequency)) continue;
                        SoundUtil.beep(SoundEngine.this.configuration.getIchtyometerErrorReceptionBeepFrequency());
                    } while (!SoundEngine.this.stop);
                }
                catch (InterruptedException e) {
                    if (SoundEngine.this.stop) continue;
                    throw new ApplicationTechnicalException("Could not get measure to say", (Throwable)e);
                }
                break;
            }
        }
    }

    protected class Measure {
        protected final String unit;
        protected final float aroundLengthStep;

        protected Measure(String unit, float aroundLengthStep) {
            this.unit = unit;
            this.aroundLengthStep = aroundLengthStep;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("unit", (Object)this.unit).add("aroundLengthStep", this.aroundLengthStep).toString();
        }
    }
}

