/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.config;

import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionConfiguration;

public class MySQLConfigStandard
extends ConnectionConfiguration {
    @Override
    public String getDatabaseShortName() {
        return "mysql";
    }

    @Override
    public String getConfigurationName() {
        return "standard";
    }

    @Override
    public String getUrl() {
        return "jdbc:mysql://" + this.getHostname() + "/liquibase";
    }

    @Override
    public Set<String> getPuppetModules() {
        Set<String> modules = super.getPuppetModules();
        modules.add("puppetlabs/mysql");
        return modules;
    }

    @Override
    public Set<String> getRequiredPackages(String vagrantBoxName) {
        return super.getRequiredPackages(vagrantBoxName);
    }

    @Override
    public String getPuppetInit(String box) {
        return "class { '::mysql::server':\n    root_password => 'root',\n" + (this.getVersion() == null ? "" : "    package_ensure => '" + this.getVersion() + "',\n") + "    override_options => { 'mysqld' => { 'bind_address'  => '0.0.0.0' } }, \n" + "}\n" + "\n" + "mysql::db { '" + this.getPrimaryCatalog() + "':\n" + "  user     => '" + this.getDatabaseUsername() + "',\n" + "  password => '" + this.getDatabasePassword() + "',\n" + "  host     => '%',\n" + "  grant    => ['all'],\n" + "}\n" + "\n" + "mysql::db { '" + this.getAlternateCatalog() + "':\n" + "  user     => '" + this.getAlternateUsername() + "',\n" + "  password => '" + this.getAlternateUserPassword() + "',\n" + "  host     => '%',\n" + "  grant    => ['all'],\n" + "}\n";
    }
}

