/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertStatement;

@DatabaseChange(name="loadUpdateData", description="Loads or updates data from a CSV file into an existing table. Differs from loadData by issuing a SQL batch that checks for the existence of a record. If found, the record is UPDATEd, else the record is INSERTed. Also, generates DELETE statements for a rollback.\n\nA value of NULL in a cell will be converted to a database NULL rather than the string 'NULL'", priority=1, appliesTo={"table"}, since="2.0")
public class LoadUpdateDataChange
extends LoadDataChange {
    private String primaryKey;

    @Override
    @DatabaseChangeProperty(description="Name of the table to insert or update data in", requiredForDatabase={"all"})
    public String getTableName() {
        return super.getTableName();
    }

    public void setPrimaryKey(String primaryKey) throws LiquibaseException {
        this.primaryKey = primaryKey;
    }

    @DatabaseChangeProperty(description="Comma delimited list of the columns for the primary key", requiredForDatabase={"all"})
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return new InsertOrUpdateStatement(catalogName, schemaName, tableName, this.primaryKey);
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        SqlStatement[] forward;
        ArrayList<DeleteStatement> statements = new ArrayList<DeleteStatement>();
        SqlStatement[] sqlStatementArray = forward = this.generateStatements(database);
        int n = forward.length;
        int n2 = 0;
        while (n2 < n) {
            SqlStatement thisForward = sqlStatementArray[n2];
            InsertOrUpdateStatement thisInsert = (InsertOrUpdateStatement)thisForward;
            DeleteStatement delete = new DeleteStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
            delete.setWhere(this.getWhere(thisInsert, database));
            statements.add(delete);
            ++n2;
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private String getWhere(InsertOrUpdateStatement insertOrUpdateStatement, Database database) {
        String[] pkColumns;
        StringBuilder where = new StringBuilder();
        String[] stringArray = pkColumns = insertOrUpdateStatement.getPrimaryKey().split(",");
        int n = pkColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String thisPkColumn = stringArray[n2];
            where.append(database.escapeColumnName(insertOrUpdateStatement.getCatalogName(), insertOrUpdateStatement.getSchemaName(), insertOrUpdateStatement.getTableName(), thisPkColumn)).append(" = ");
            Object newValue = insertOrUpdateStatement.getColumnValues().get(thisPkColumn);
            where.append(DataTypeFactory.getInstance().fromObject(newValue, database).objectToSql(newValue, database));
            where.append(" AND ");
            ++n2;
        }
        where.delete(where.lastIndexOf(" AND "), where.lastIndexOf(" AND ") + " AND ".length());
        return where.toString();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

