/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;

public class AttrStringUtils {
    private AttrStringUtils() {
    }

    public static Rectangle2D getTextBounds(AttributedString text, Graphics2D g2) {
        TextLayout tl = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        return tl.getBounds();
    }

    public static void drawRotatedString(AttributedString text, Graphics2D g2, double angle, float x, float y) {
        AttrStringUtils.drawRotatedString(text, g2, x, y, angle, x, y);
    }

    public static void drawRotatedString(AttributedString text, Graphics2D g2, float textX, float textY, double angle, float rotateX, float rotateY) {
        ParamChecks.nullNotPermitted(text, "text");
        AffineTransform saved = g2.getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, rotateX, rotateY);
        g2.transform(rotate);
        TextLayout tl = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        tl.draw(g2, textX, textY);
        g2.setTransform(saved);
    }

    public static void drawRotatedString(AttributedString text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, float rotationX, float rotationY) {
        ParamChecks.nullNotPermitted(text, "text");
        float[] textAdj = AttrStringUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor, null);
        AttrStringUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, rotationX, rotationY);
    }

    public static void drawRotatedString(AttributedString text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, TextAnchor rotationAnchor) {
        ParamChecks.nullNotPermitted(text, "text");
        float[] textAdj = AttrStringUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor, null);
        float[] rotateAdj = AttrStringUtils.deriveRotationAnchorOffsets(g2, text, rotationAnchor);
        AttrStringUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, x + textAdj[0] + rotateAdj[0], y + textAdj[1] + rotateAdj[1]);
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, AttributedString text, TextAnchor anchor, Rectangle2D textBounds) {
        TextLayout layout = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        float[] result = new float[3];
        float ascent = layout.getAscent();
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = layout.getDescent();
        float leading = layout.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (AttrStringUtils.isHorizontalCenter(anchor)) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (AttrStringUtils.isHorizontalRight(anchor)) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (AttrStringUtils.isTop(anchor)) {
            yAdj = (float)bounds.getHeight();
        } else if (AttrStringUtils.isHalfAscent(anchor)) {
            yAdj = halfAscent;
        } else if (AttrStringUtils.isHalfHeight(anchor)) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (AttrStringUtils.isBaseline(anchor)) {
            yAdj = 0.0f;
        } else if (AttrStringUtils.isBottom(anchor)) {
            yAdj = -descent - leading;
        }
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D g2, AttributedString text, TextAnchor anchor) {
        float[] result = new float[2];
        TextLayout layout = new TextLayout(text.getIterator(), g2.getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        float ascent = layout.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = layout.getDescent();
        float leading = layout.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (AttrStringUtils.isHorizontalLeft(anchor)) {
            xAdj = 0.0f;
        } else if (AttrStringUtils.isHorizontalCenter(anchor)) {
            xAdj = (float)bounds.getWidth() / 2.0f;
        } else if (AttrStringUtils.isHorizontalRight(anchor)) {
            xAdj = (float)bounds.getWidth();
        }
        if (AttrStringUtils.isTop(anchor)) {
            yAdj = descent + leading - (float)bounds.getHeight();
        } else if (AttrStringUtils.isHalfHeight(anchor)) {
            yAdj = descent + leading - (float)(bounds.getHeight() / 2.0);
        } else if (AttrStringUtils.isHalfAscent(anchor)) {
            yAdj = -halfAscent;
        } else if (AttrStringUtils.isBaseline(anchor)) {
            yAdj = 0.0f;
        } else if (AttrStringUtils.isBottom(anchor)) {
            yAdj = descent + leading;
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static boolean isTop(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.TOP_LEFT) || anchor.equals((Object)TextAnchor.TOP_CENTER) || anchor.equals((Object)TextAnchor.TOP_RIGHT);
    }

    private static boolean isBaseline(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.BASELINE_LEFT) || anchor.equals((Object)TextAnchor.BASELINE_CENTER) || anchor.equals((Object)TextAnchor.BASELINE_RIGHT);
    }

    private static boolean isHalfAscent(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.HALF_ASCENT_LEFT) || anchor.equals((Object)TextAnchor.HALF_ASCENT_CENTER) || anchor.equals((Object)TextAnchor.HALF_ASCENT_RIGHT);
    }

    private static boolean isHalfHeight(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.CENTER_LEFT) || anchor.equals((Object)TextAnchor.CENTER) || anchor.equals((Object)TextAnchor.CENTER_RIGHT);
    }

    private static boolean isBottom(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.BOTTOM_LEFT) || anchor.equals((Object)TextAnchor.BOTTOM_CENTER) || anchor.equals((Object)TextAnchor.BOTTOM_RIGHT);
    }

    private static boolean isHorizontalLeft(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.TOP_LEFT) || anchor.equals((Object)TextAnchor.CENTER_LEFT) || anchor.equals((Object)TextAnchor.HALF_ASCENT_LEFT) || anchor.equals((Object)TextAnchor.BASELINE_LEFT) || anchor.equals((Object)TextAnchor.BOTTOM_LEFT);
    }

    private static boolean isHorizontalCenter(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.TOP_CENTER) || anchor.equals((Object)TextAnchor.CENTER) || anchor.equals((Object)TextAnchor.HALF_ASCENT_CENTER) || anchor.equals((Object)TextAnchor.BASELINE_CENTER) || anchor.equals((Object)TextAnchor.BOTTOM_CENTER);
    }

    private static boolean isHorizontalRight(TextAnchor anchor) {
        return anchor.equals((Object)TextAnchor.TOP_RIGHT) || anchor.equals((Object)TextAnchor.CENTER_RIGHT) || anchor.equals((Object)TextAnchor.HALF_ASCENT_RIGHT) || anchor.equals((Object)TextAnchor.BASELINE_RIGHT) || anchor.equals((Object)TextAnchor.BOTTOM_RIGHT);
    }
}

