/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.mutable.MutableInt;

public class BenthosFrequencyUIModelCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Set<BenthosFrequencyRowModel> withWeightRows = Sets.newHashSet();
    protected final Map<Integer, MutableInt> nbOfRowsByLengthStep = new TreeMap<Integer, MutableInt>();
    private final Map<Float, BenthosFrequencyRowModel> rowCache = new TreeMap<Float, BenthosFrequencyRowModel>();

    public void loadCache(List<BenthosFrequencyRowModel> rows) {
        this.withWeightRows.clear();
        this.nbOfRowsByLengthStep.clear();
        this.rowCache.clear();
        for (BenthosFrequencyRowModel row : rows) {
            Float lengthStep = row.getLengthStep();
            if (lengthStep != null) {
                this.rowCache.put(lengthStep, row);
                this.incNumberOfRows(lengthStep.floatValue());
            }
            this.updateRowWithWeight(row);
        }
    }

    public void updateRowWithWeight(BenthosFrequencyRowModel row) {
        if (row.getWeight() == null) {
            this.withWeightRows.remove(row);
        } else {
            this.withWeightRows.add(row);
        }
    }

    public int getNbRowsWithWeight() {
        return this.withWeightRows.size();
    }

    public int numberOfRows(float lengthStep) {
        MutableInt mutableInt = this.getNbRowsByLengthStep(lengthStep);
        int result = mutableInt.intValue();
        return result;
    }

    public void incNumberOfRows(float lengthStep) {
        MutableInt mutableInt = this.getNbRowsByLengthStep(lengthStep);
        mutableInt.increment();
    }

    public void decNumberOfRows(float lengthStep) {
        MutableInt mutableInt = this.getNbRowsByLengthStep(lengthStep);
        mutableInt.decrement();
    }

    protected MutableInt getNbRowsByLengthStep(float lengthStep) {
        int mmLengthStep = Math.round(lengthStep * 10.0f);
        MutableInt mutableInt = this.nbOfRowsByLengthStep.get(mmLengthStep);
        if (mutableInt == null) {
            mutableInt = new MutableInt(0);
            this.nbOfRowsByLengthStep.put(mmLengthStep, mutableInt);
        }
        return mutableInt;
    }

    public void addLengthStep(BenthosFrequencyRowModel row) {
        Float lengthStep = row.getLengthStep();
        this.rowCache.put(lengthStep, row);
        this.incNumberOfRows(lengthStep.floatValue());
    }

    public void removeLengthStep(Float oldValue) {
        this.rowCache.remove(oldValue);
        this.decNumberOfRows(oldValue.floatValue());
    }

    public Map<Float, BenthosFrequencyRowModel> getRowCache() {
        return this.rowCache;
    }

    public Float computeTotalWeight() {
        float result = 0.0f;
        for (BenthosFrequencyRowModel row : this.withWeightRows) {
            if (!row.isValid()) continue;
            result += row.getWeight().floatValue();
        }
        return Float.valueOf(result);
    }
}

