/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.version;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.version.Version;

@Deprecated
public class VersionBuilder {
    protected Set<String> preReleaseClassifiers;
    protected Set<Character> splitSeparators = new HashSet<Character>();
    protected Character joinSeparator;
    protected String version;
    protected List<Comparable> componants;
    protected List<String> componantSeparators;
    protected boolean snapshot;

    public static VersionBuilder create() {
        return new VersionBuilder();
    }

    public static VersionBuilder create(String version) {
        return new VersionBuilder().setVersion(version);
    }

    public static VersionBuilder create(Version version) {
        List<Comparable> componants = VersionBuilder.toComparableList(version.getComponants());
        ArrayList<String> componantSeparators = new ArrayList<String>(version.getComponantSeparators());
        boolean snapshot = version.isSnapshot();
        return new VersionBuilder().setComponants(componants).setComponantSeparators(componantSeparators).setSnapshot(snapshot);
    }

    public static VersionBuilder create(List<Comparable> componants) {
        return new VersionBuilder().setComponants(componants);
    }

    public VersionBuilder() {
        this.splitSeparators.add(Character.valueOf('-'));
        this.splitSeparators.add(Character.valueOf('.'));
        this.splitSeparators.add(Character.valueOf('_'));
        this.joinSeparator = Character.valueOf('.');
        this.preReleaseClassifiers = new HashSet<String>();
        this.preReleaseClassifiers.add("alpha");
        this.preReleaseClassifiers.add("beta");
        this.preReleaseClassifiers.add("rc");
    }

    public VersionBuilder setVersion(String version) {
        Preconditions.checkState((!this.fromComponants() ? 1 : 0) != 0, (Object)"Can't set version if componants are filled");
        this.version = version;
        return this;
    }

    public VersionBuilder setComponants(List<Comparable> componants) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set componants if version is filled");
        this.componants = componants;
        return this;
    }

    public VersionBuilder setComponant(int level, Comparable value) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set componants if version is filled");
        int size = this.componants.size();
        Preconditions.checkArgument((level >= 0 && level < size ? 1 : 0) != 0, (Object)("level should be in [0, " + (size - 1) + "]"));
        this.componants.set(level, value);
        return this;
    }

    public VersionBuilder addComponant(Comparable value) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set componants if version is filled");
        this.componants.add(value);
        return this;
    }

    public VersionBuilder addComponant(Comparable value, char componantSeparator) {
        this.addComponant(value);
        if (this.componantSeparators == null) {
            this.componantSeparators = new ArrayList<String>(this.componants.size() - 1);
            this.initSeparatorList(this.componantSeparators, this.componants.size() - 2);
        }
        this.componantSeparators.add(componantSeparator + "");
        return this;
    }

    public VersionBuilder removeComponant(int level) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set componants if version is filled");
        int size = this.componants.size();
        Preconditions.checkArgument((level >= 0 && level < size ? 1 : 0) != 0, (Object)("level should be in [0, " + (size - 1) + "]"));
        this.componants.remove(level);
        if (this.componantSeparators != null) {
            this.componantSeparators.remove(level - 1);
        }
        return this;
    }

    public VersionBuilder setComponantSeparators(List<String> componantSeparators) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set componants if version is filled");
        Preconditions.checkArgument((componantSeparators.size() == this.componants.size() - 1 ? 1 : 0) != 0, (Object)"Must have n-1 componant separators if you have n componants");
        this.componantSeparators = componantSeparators;
        return this;
    }

    public VersionBuilder setComponantSeparator(int level, char value) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set componants if version is filled");
        int size = this.componants.size();
        Preconditions.checkArgument((level >= 0 && level < size ? 1 : 0) != 0, (Object)("level should be in [0, " + (size - 2) + "]"));
        this.componantSeparators.set(level, value + "");
        return this;
    }

    public VersionBuilder setSnapshot(boolean snapshot) {
        Preconditions.checkState((!this.fromStringRepresentation() ? 1 : 0) != 0, (Object)"Can't set snapshot if version is filled");
        this.snapshot = snapshot;
        return this;
    }

    public VersionBuilder setSplitSeparators(Set<Character> splitSeparators) {
        for (Character splitSeparator : splitSeparators) {
            Preconditions.checkState((!CharUtils.isAsciiAlphanumeric((char)splitSeparator.charValue()) ? 1 : 0) != 0, (Object)"Can't use a alphanumeric splitseparator");
        }
        this.splitSeparators = splitSeparators;
        return this;
    }

    public VersionBuilder setJoinSeparator(Character joinSeparator) {
        this.joinSeparator = joinSeparator;
        return this;
    }

    public VersionBuilder setPreReleaseClassifiers(Set<String> preReleaseClassifiers) {
        this.preReleaseClassifiers = preReleaseClassifiers;
        return this;
    }

    protected boolean fromStringRepresentation() {
        return this.version != null;
    }

    protected boolean fromComponants() {
        return this.componants != null;
    }

    public Version build() {
        boolean finalSnapshot;
        ArrayList<Version.VersionComponant> finalComponants = new ArrayList<Version.VersionComponant>();
        ArrayList<String> finalComponantSeparators = new ArrayList<String>();
        if (this.fromComponants()) {
            finalSnapshot = this.snapshot;
            for (Comparable componant : this.componants) {
                boolean number = componant instanceof Integer;
                Version.VersionComponant v = this.toVersionComponant(number, String.valueOf(componant));
                finalComponants.add(v);
            }
            if (CollectionUtils.isNotEmpty(this.componantSeparators)) {
                finalComponantSeparators = new ArrayList<String>(this.componantSeparators);
            } else {
                this.initSeparatorList(finalComponantSeparators, finalComponants.size() - 1);
            }
        } else if (this.fromStringRepresentation()) {
            finalSnapshot = this.version.endsWith("-SNAPSHOT");
            String versionPart = StringUtils.substringBeforeLast((String)this.version, (String)"-SNAPSHOT");
            boolean numberState = false;
            String currentComponantStr = null;
            int l = versionPart.length();
            for (int i = 0; i < l; ++i) {
                char currentChar = versionPart.charAt(i);
                if (this.splitSeparators.contains(Character.valueOf(currentChar))) {
                    finalComponantSeparators.add(currentChar + "");
                    if (currentComponantStr == null) continue;
                    Version.VersionComponant componant = this.toVersionComponant(numberState, currentComponantStr);
                    finalComponants.add(componant);
                    currentComponantStr = null;
                    continue;
                }
                boolean number = CharUtils.isAsciiNumeric((char)currentChar);
                if (currentComponantStr == null) {
                    currentComponantStr = "" + currentChar;
                    numberState = number;
                    continue;
                }
                if (numberState == number) {
                    currentComponantStr = currentComponantStr + currentChar;
                    continue;
                }
                Version.VersionComponant componant = this.toVersionComponant(numberState, currentComponantStr);
                finalComponants.add(componant);
                finalComponantSeparators.add("");
                numberState = number;
                currentComponantStr = "" + currentChar;
            }
            if (currentComponantStr != null) {
                Version.VersionComponant componant = this.toVersionComponant(numberState, currentComponantStr);
                finalComponants.add(componant);
            }
        } else {
            finalSnapshot = this.snapshot;
            finalComponants.add(new Version.NumberVersionComponant(0));
        }
        if (finalComponantSeparators.isEmpty() && finalComponants.size() > 1) {
            this.initSeparatorList(finalComponantSeparators, finalComponants.size() - 1);
        }
        Version result = new Version(finalComponants, finalComponantSeparators, finalSnapshot);
        return result;
    }

    protected void initSeparatorList(List<String> list, int size) {
        for (int i = 0; i < size; ++i) {
            list.add("" + this.joinSeparator);
        }
    }

    protected Version.VersionComponant toVersionComponant(boolean numberState, String currentComponantStr) {
        Version.VersionComponant<Integer, Version.NumberVersionComponant> componant;
        if (numberState) {
            componant = new Version.NumberVersionComponant(Integer.valueOf(currentComponantStr));
        } else {
            boolean preRelease = this.preReleaseClassifiers.contains(currentComponantStr.toLowerCase());
            componant = new Version.StringVersionComponant(preRelease, currentComponantStr);
        }
        return componant;
    }

    protected static List<Comparable> toComparableList(List<Version.VersionComponant> componants) {
        ArrayList result = Lists.newArrayList((Iterable)Lists.transform(componants, (Function)new Function<Version.VersionComponant, Comparable>(){

            public Comparable apply(Version.VersionComponant input) {
                return input.getValue();
            }
        }));
        return result;
    }
}

