package fr.ifremer.tutti.ui.swing.util.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class EnterWeightUI extends JDialog implements TuttiUI<TuttiUIContext, EnterWeightUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ORIGINAL_WEIGHT = "originalWeight";
    public static final String PROPERTY_WEIGHT_LABEL = "weightLabel";
    public static final String PROPERTY_WEIGHT_UNIT = "weightUnit";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DIALOG_TITLE = "dialog.title";
    public static final String BINDING_EDITOR_NUMBER_PATTERN = "editor.numberPattern";
    public static final String BINDING_EDITOR_NUMBER_VALUE = "editor.numberValue";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSemNqu7aYpjVoFtYBLkbAJrMOPSEgp0BAakcpJo9ppKnyA8e7Enmp2dth9Wzu1gvgT+BPgzgWJGyfEgTMHLoh/ASEOXCvezK537djBVvFh7Z1573vfe/O+N/7uT5INfHLjEe33LT+UwF1m3d18+PBe+xGz4WMW2D5X4Pkk+ixkSKZFSk6yHgC52apr91rsXtvyXOVJJke8N+qkGMCxYEGXMQDy4riHHQS1RrK90VehP0RNSE1D/ebvvzJfO199myGkr5BdEVMpz/JKMzlXJxnuALmMkR7TmqCygzR8LjvId1GvbQkaBHvUZV+QL0m+TnKK+ggG5JX5UzYYxr+vgOQcToXXAfLukW/xI5+5zLcgBOBWyK2gh8GtELiwbAp2lwXWHQnMP2S804WDHaUMUg5I1vUcJoBUzoZp6teDnS0PEfqQupZ6Bq1O2xrgks7T0rlbUe6p4UXP5x0uqYjCA1lKbbeFR0cwixHmgeRoVp7gBMeKWYeJyUgaQNuCAVkZO7WYv97SdoXEPMccjrUFsur5HUuG+CIt49rjTodBgGtuG8Puma87xlr7riQQ51+9u08lE2t47jqdfhwtWh0Pd8Gm0mbiI8wBi0iWx+yjVW35Ulqxx1RwhwJLN2/GFj65NpYj9ryV9nzalAstkvVDXMaitCZlch+3IoGsnBKIBjS7T68u//bjHz9sD1VRwNhXppqOiBq7VfmeYj5wHXopkoTuxNouVRstRGECJ4JR/PUpxBrxNpLDeM+bTjGN/AkNugiRzf/+089XP//1OZLZJkXsHmebavsdUoCuj1XwhNNXH942jC70zuPzkuaGh96N2y+zvtbHxK9PSTyJ3i788s9y4/vbw+QXkMwLZ5qnBch+SnJcCi6ZGQqx3qcOgZIKWOh4qa6nKZ0ohWovtU0fmNYyO6vmWZuWZhY4aCmsD7pUOgKbGBu6qdcq+OMw1Wyl+kY5WdFyqlSrJ/1QA79jMta/1kkya1Qst7Ni54EUaAjevqdC5Jw9oiJAHsVISk2ULpDFgRG8ZesUT/A92tyngNMJpfH64BQjTX5UhLFlpYrO+TBgDd6RaawlPP6eiT/U2nCnFAV6QEWIb1d0mHtjU8kgFrT/fRbou+Uc+CGbWo5oeMwqRxZ1z996T+5K5nqS20DWoiE2nMgsncgWtjDHERTNCctNXIrRxo6tc8lF25oaDmIgr82Jh9mD54kmV03jtzovD8AbiCx+FnBXCbZptoDsDea8cSKssZtny+BuxkFMD0yr8Ni8nFXn3ESd356Z33C8nllpattMQVLp6tyIp2v95vxcTLXzTOrrCv9NXBtEfaYVsKsv6Uq1fOP9sgyFOJk8lf3/cSoPYgYzz+XUtTTrZPTMFfTYQ2Ny8Rb60XKbSwcpfTCBvqCfxTkQSy6X3A3dBn9iBmn47FAFvC74k+iPw+Vb0dQu43zxOY5b9swc9TL8B7WXEeFfnq09MzALAAA=";
    private static final Log log = LogFactory.getLog(EnterWeightUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected EnterWeightUI dialog = this;
    protected NumberEditor editor;
    protected final EnterWeightUIHandler handler = createHandler();
    protected TuttiUIContext model;
    protected Float originalWeight;
    protected Table table;
    protected JButton validateButton;
    protected String weightLabel;
    protected WeightUnit weightUnit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public Float openAndGetWeightValue(String weightLabel, Float originalWeight, WeightUnit weightUnit) {
        return handler.openAndGetWeightValue(weightLabel, originalWeight, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EnterWeightUI(TuttiUIContext context) {
        super(context.getMainUI(), true);
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public EnterWeightUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI() {
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0) {
        super(param0);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public EnterWeightUIHandler getHandler() {
        return handler;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public Float getOriginalWeight() {
        return originalWeight;
    }

    public Table getTable() {
        return table;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public String getWeightLabel() {
        return weightLabel;
    }

    public WeightUnit getWeightUnit() {
        return weightUnit;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOriginalWeight(Float originalWeight) {
        Float oldValue = this.originalWeight;
        this.originalWeight = originalWeight;
        firePropertyChange(PROPERTY_ORIGINAL_WEIGHT, oldValue, originalWeight);
    }

    public void setWeightLabel(String weightLabel) {
        String oldValue = this.weightLabel;
        this.weightLabel = weightLabel;
        firePropertyChange(PROPERTY_WEIGHT_LABEL, oldValue, weightLabel);
    }

    public void setWeightUnit(WeightUnit weightUnit) {
        WeightUnit oldValue = this.weightUnit;
        this.weightUnit = weightUnit;
        firePropertyChange(PROPERTY_WEIGHT_UNIT, oldValue, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.catches.enterWeight.action.cancel"));
        cancelButton.setToolTipText(t("tutti.catches.enterWeight.action.cancel.tip"));
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.catches.actions.EnterWeightCancelAction.class);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setAutoPopup(false);
        editor.setUseSign(false);
        editor.setShowPopupButton(false);
        editor.setShowReset(true);
    }

    protected EnterWeightUIHandler createHandler() {
        return new EnterWeightUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createOriginalWeight() {
        $objectMap.put("originalWeight", originalWeight = null);
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.catches.enterWeight.action.validate"));
        validateButton.setToolTipText(t("tutti.catches.enterWeight.action.validate.tip"));
        validateButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.catches.actions.EnterWeightValidateAction.class);
    }

    protected void createWeightLabel() {
        $objectMap.put("weightLabel", weightLabel = null);
    }

    protected void createWeightUnit() {
        $objectMap.put("weightUnit", weightUnit = WeightUnit.KG);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        setMinimumSize(new Dimension(350,100));
        editor.setNumberType(Float.class);
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.catches.enterWeight.action.cancel.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.catches.enterWeight.action.validate.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("accept"));
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("dialog", dialog);
        createModel();
        createWeightLabel();
        createOriginalWeight();
        createWeightUnit();
        createTable();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of dialog
        setName("dialog");
        dialog.getContentPane().setLayout(new BorderLayout());
        setResizable(false);
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DIALOG_TITLE, true ,"weightLabel" ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                setTitle(t(handler.getTitle(getWeightLabel(), getWeightUnit())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_NUMBER_PATTERN, true ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                if (getWeightUnit() != null) {
                    editor.setNumberPattern(getWeightUnit().getNumberEditorPattern());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_NUMBER_VALUE, true ,"originalWeight") {
        
            @Override
            public void processDataBinding() {
                editor.setNumberValue(getOriginalWeight());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null) {
                    validateButton.setEnabled(editor.getModel() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}