package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ReplaceTemporaryVesselUI extends AbstractReplaceTemporaryUI<Vessel, ReplaceTemporaryVesselUIModel> implements TuttiUI<ReplaceTemporaryVesselUIModel, ReplaceTemporaryVesselUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1TTU8UQRCtXV1gQRTYQDBigmg89nrhoBjlw2yELGhYMMY9aM9Ms9ukd6bt7pEhRuNP8Cfo3YuJN0/Gg2cPXox/wRgPXo3VM8N+wCDEuIfKpqrr1aua9958h4JWcGGbRhFRoW94i5GVhfv37zjbzDW3mHYVlyZQkPxyecjXYchr57WBi/WqbS+n7eWloCUDn/ld3XNVGNRmVzDdZMwYON/b4WpdrrXLc5EM1R5qm1QW6qufP/IvvRev8wCRRHZ2lemjujqbnKxCnnsGxnDSE1oW1G8gDcX9BvIdtrklQbVeoy32GJ5DfxX6JFUIZmDm+CvHGHF/JA2MKyYFddkGww5F1e7m8kaA+bUtRfiWYi2miAmN4STkRO8gF+IGvkFootgWs9M5FSRFIev70O4xrZnYXJYyHtlnoNAKPCYM1P7vgFWL2pkypoNQuazKtcFbOMFiEBmY7fkUySzmcTwOcRj1ySKGCheGKergndI+i1jsABuqGsx0A9vKaO+r4ZTuIi6Gy0DJfrwoHbmSZNMOBed6aKH2SEd7HXHk6lBQIaYNTNYPynUdS4lQJ/cJ1QLG1d8TpS/vv72rdKtzPPNpl7lQNVIFkinD7egziTRDw0V5lcq5OhTx/OjM2HlTGcRqaRnJ4bxR205sO7lNdRMhCv1fP3ycePT5BOQrMCgC6lWofb8MRdNUeIVAeJG8OR8zOrUzgHHEcjPQ12S80UTx52evRLj4VMbi7elO8dOvUu3t/N7yOSRz9tDnnQMUHkAf9wX3WWzO1HeZZhySmoVe0PFXluNASnTXkBNL4C71mYgrU3GczlqzYLgRqISZxCX7/ZoYgMSPotCiXIrXs/8uw2EGl6lV/jJ37CGVUnCXGh74C66NBpyn/2ZbGvfrQ+yboBPX3ulZ1hK9fjoG+QFr6I1diXc7fd2jhk473PeQ5Y0D8DkbR47EtOmrNlzLRighwh/Oa0P/vgYAAA==";
    private static final Log log = LogFactory.getLog(ReplaceTemporaryVesselUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected final ReplaceTemporaryVesselUIHandler handler = createHandler();
    protected ReplaceTemporaryVesselUIModel model;
    protected JButton replaceButton;
    protected ReplaceTemporaryVesselUI replaceTemporaryUITop = this;
    protected BeanFilterableComboBox<Vessel> sourceListComboBox;
    protected BeanFilterableComboBox<Vessel> targetListComboBox;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporaryVesselUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI() {
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryVesselUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporaryVesselUIHandler getHandler() {
        return handler;
    }

    public ReplaceTemporaryVesselUIModel getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<Vessel> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public BeanFilterableComboBox<Vessel> getTargetListComboBox() {
        return targetListComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(sourceListComboBox);
        add(targetListComboBox);
        add(replaceButton);
    }

    protected ReplaceTemporaryVesselUIHandler createHandler() {
        return new ReplaceTemporaryVesselUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReplaceTemporaryVesselUIModel.class));
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.replace.actions.ReplaceTemporaryVesselAction.class);
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<Vessel>());
        
        sourceListComboBox.setName("sourceListComboBox");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<Vessel>());
        
        targetListComboBox.setName("targetListComboBox");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        
        // apply 2 property setters
        sourceListComboBox.setBeanType(Vessel.class);
        targetListComboBox.setBeanType(Vessel.class);
        // late initializer
        replaceTemporaryUITop.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createSourceListComboBox();
        createTargetListComboBox();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        setTitle(t("tutti.replaceTemporaryVessel.title"));
        
        $completeSetup();
        handler.afterInit(this);
    }

}