package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class BenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<BenthosBatchUIModel, BenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED = "addSampleCategoryMenu.enabled";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN = "benthosTotalInertWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_NUMBER_VALUE = "benthosTotalInertWeightField.numberValue";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "benthosTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_VALUE = "benthosTotalLivingNotItemizedWeightField.numberValue";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "benthosTotalSampleSortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "benthosTotalSortedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_VALUE = "benthosTotalSortedWeightField.numberValue";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT = "benthosTotalWeightField.text";
    public static final String BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED = "changeSampleCategoryMenu.enabled";
    public static final String BINDING_CREATE_BENTHOS_MELAG_MENU_ENABLED = "createBenthosMelagMenu.enabled";
    public static final String BINDING_EDIT_FREQUENCIES_MENU_ENABLED = "editFrequenciesMenu.enabled";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED = "filterBenthosBatchAllButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED = "filterBenthosBatchLeafButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED = "filterBenthosBatchRootButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT = "filterBenthosBatchRootButton.text";
    public static final String BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED = "removeBenthosBatchMenu.enabled";
    public static final String BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED = "removeBenthosSubBatchMenu.enabled";
    public static final String BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED = "renameBenthosBatchMenu.enabled";
    public static final String BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED = "speciesSortModeAscButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED = "speciesSortModeDescButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED = "speciesSortModeNoneButton.selected";
    public static final String BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED = "splitBenthosBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem addSampleCategoryMenu;
    protected ButtonAttachment benthosBatchAttachmentsButton;
    protected JToolBar benthosBatchTabToolBar;
    protected ComputableDataEditor<Float> benthosTotalInertWeightField;
    protected JLabel benthosTotalInertWeightLabel;
    protected ComputableDataEditor<Float> benthosTotalLivingNotItemizedWeightField;
    protected JLabel benthosTotalLivingNotItemizedWeightLabel;
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected ComputableDataEditor<Float> benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JMenuItem changeSampleCategoryMenu;
    protected JButton createBenthosBatchButton;
    protected JMenuItem createBenthosMelagMenu;
    protected BenthosBatchUI editBenthosBatchTopPanel = this;
    protected JMenuItem editFrequenciesMenu;
    protected JMenuItem exportMultiPostButton;
    protected JRadioButton filterBenthosBatchAllButton;
    protected JLabel filterBenthosBatchLabel;
    protected JRadioButton filterBenthosBatchLeafButton;
    protected JAXXButtonGroup filterBenthosBatchMode;
    protected JRadioButton filterBenthosBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected final BenthosBatchUIHandler handler = createHandler();
    protected JMenuItem importMultiPostButton;
    protected JMenuBar menu;
    protected JMenu menuAction;
    protected BenthosBatchUIModel model;
    protected JMenuItem removeBenthosBatchMenu;
    protected JMenuItem removeBenthosSubBatchMenu;
    protected JMenuItem renameBenthosBatchMenu;
    protected JAXXButtonGroup speciesSort;
    protected JLabel speciesSortBatchLabel;
    protected JRadioButton speciesSortModeAscButton;
    protected JRadioButton speciesSortModeDescButton;
    protected JRadioButton speciesSortModeNoneButton;
    protected JPanel speciesSortTablePane;
    protected JMenuItem splitBenthosBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public BenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI() {
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__filterBenthosBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterBenthosBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterBenthosBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__speciesSortModeAscButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.ASC);
    }

    public void doActionPerformed__on__speciesSortModeDescButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.DESC);
    }

    public void doActionPerformed__on__speciesSortModeNoneButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAddSampleCategoryMenu() {
        return addSampleCategoryMenu;
    }

    public ButtonAttachment getBenthosBatchAttachmentsButton() {
        return benthosBatchAttachmentsButton;
    }

    public JToolBar getBenthosBatchTabToolBar() {
        return benthosBatchTabToolBar;
    }

    public ComputableDataEditor<Float> getBenthosTotalInertWeightField() {
        return benthosTotalInertWeightField;
    }

    public JLabel getBenthosTotalInertWeightLabel() {
        return benthosTotalInertWeightLabel;
    }

    public ComputableDataEditor<Float> getBenthosTotalLivingNotItemizedWeightField() {
        return benthosTotalLivingNotItemizedWeightField;
    }

    public JLabel getBenthosTotalLivingNotItemizedWeightLabel() {
        return benthosTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public ComputableDataEditor<Float> getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JMenuItem getChangeSampleCategoryMenu() {
        return changeSampleCategoryMenu;
    }

    public JButton getCreateBenthosBatchButton() {
        return createBenthosBatchButton;
    }

    public JMenuItem getCreateBenthosMelagMenu() {
        return createBenthosMelagMenu;
    }

    public JMenuItem getEditFrequenciesMenu() {
        return editFrequenciesMenu;
    }

    public JMenuItem getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public JRadioButton getFilterBenthosBatchAllButton() {
        return filterBenthosBatchAllButton;
    }

    public JLabel getFilterBenthosBatchLabel() {
        return filterBenthosBatchLabel;
    }

    public JRadioButton getFilterBenthosBatchLeafButton() {
        return filterBenthosBatchLeafButton;
    }

    public JAXXButtonGroup getFilterBenthosBatchMode() {
        return filterBenthosBatchMode;
    }

    public JRadioButton getFilterBenthosBatchRootButton() {
        return filterBenthosBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public BenthosBatchUIHandler getHandler() {
        return handler;
    }

    public JMenuItem getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAction() {
        return menuAction;
    }

    public BenthosBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveBenthosBatchMenu() {
        return removeBenthosBatchMenu;
    }

    public JMenuItem getRemoveBenthosSubBatchMenu() {
        return removeBenthosSubBatchMenu;
    }

    public JMenuItem getRenameBenthosBatchMenu() {
        return renameBenthosBatchMenu;
    }

    public JAXXButtonGroup getSpeciesSort() {
        return speciesSort;
    }

    public JLabel getSpeciesSortBatchLabel() {
        return speciesSortBatchLabel;
    }

    public JRadioButton getSpeciesSortModeAscButton() {
        return speciesSortModeAscButton;
    }

    public JRadioButton getSpeciesSortModeDescButton() {
        return speciesSortModeDescButton;
    }

    public JRadioButton getSpeciesSortModeNoneButton() {
        return speciesSortModeNoneButton;
    }

    public JPanel getSpeciesSortTablePane() {
        return speciesSortTablePane;
    }

    public JMenuItem getSplitBenthosBatchMenu() {
        return splitBenthosBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        benthosBatchTabToolBar.add(menu);
        benthosBatchTabToolBar.add(benthosBatchAttachmentsButton);
    }

    protected void addChildrenToEditBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(benthosBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterBenthosBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchAllButton); }
    }

    protected void addChildrenToFilterBenthosBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchLeafButton); }
    }

    protected void addChildrenToFilterBenthosBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterBenthosBatchLabel);
        filterTablePane.add(filterBenthosBatchAllButton);
        filterTablePane.add(filterBenthosBatchLeafButton);
        filterTablePane.add(filterBenthosBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuAction);
    }

    protected void addChildrenToMenuAction() {
        if (!allComponentsCreated) {
            return;
        }
        menuAction.add(importMultiPostButton);
        menuAction.add(exportMultiPostButton);
    }

    protected void addChildrenToSpeciesSortModeAscButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeAscButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeAscButton); }
    }

    protected void addChildrenToSpeciesSortModeDescButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeDescButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeDescButton); }
    }

    protected void addChildrenToSpeciesSortModeNoneButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeNoneButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeNoneButton); }
    }

    protected void addChildrenToSpeciesSortTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        speciesSortTablePane.add(speciesSortBatchLabel);
        speciesSortTablePane.add(speciesSortModeNoneButton);
        speciesSortTablePane.add(speciesSortModeAscButton);
        speciesSortTablePane.add(speciesSortModeDescButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitBenthosBatchMenu);
        tablePopup.add(changeSampleCategoryMenu);
        tablePopup.add(addSampleCategoryMenu);
        tablePopup.add(removeBenthosBatchMenu);
        tablePopup.add(removeBenthosSubBatchMenu);
        tablePopup.add(renameBenthosBatchMenu);
        tablePopup.add(createBenthosMelagMenu);
        tablePopup.add(editFrequenciesMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add($JPanel1, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSampleCategoryMenu() {
        $objectMap.put("addSampleCategoryMenu", addSampleCategoryMenu = new JMenuItem());
        
        addSampleCategoryMenu.setName("addSampleCategoryMenu");
        addSampleCategoryMenu.setText(t("tutti.editBenthosBatch.action.addSampleCategory"));
        addSampleCategoryMenu.setToolTipText(t("tutti.editBenthosBatch.action.addSampleCategory.tip"));
        addSampleCategoryMenu.putClientProperty("help", "tutti.editBenthosBatch.action.addSampleCategory.help");
        addSampleCategoryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.OpenAddBenthosBatchSampleCategoryUIAction.class);
    }

    protected void createBenthosBatchAttachmentsButton() {
        $objectMap.put("benthosBatchAttachmentsButton", benthosBatchAttachmentsButton = new ButtonAttachment(handler.getContext(), getContextValue(EditCatchesUIModel.class)));
        
        benthosBatchAttachmentsButton.setName("benthosBatchAttachmentsButton");
        benthosBatchAttachmentsButton.setToolTipText(t("tutti.editBenthosBatch.action.attachments.tip"));
        benthosBatchAttachmentsButton.setFocusPainted(false);
    }

    protected void createBenthosBatchTabToolBar() {
        $objectMap.put("benthosBatchTabToolBar", benthosBatchTabToolBar = new JToolBar());
        
        benthosBatchTabToolBar.setName("benthosBatchTabToolBar");
        benthosBatchTabToolBar.setBorderPainted(false);
        benthosBatchTabToolBar.setOpaque(true);
        benthosBatchTabToolBar.setFloatable(false);
    }

    protected void createBenthosTotalInertWeightField() {
        $objectMap.put("benthosTotalInertWeightField", benthosTotalInertWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalInertWeightField.setName("benthosTotalInertWeightField");
        benthosTotalInertWeightField.setShowReset(true);
        benthosTotalInertWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        benthosTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalInertWeightLabel() {
        $objectMap.put("benthosTotalInertWeightLabel", benthosTotalInertWeightLabel = new JLabel());
        
        benthosTotalInertWeightLabel.setName("benthosTotalInertWeightLabel");
        benthosTotalInertWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalInertWeight"));
        benthosTotalInertWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalInertWeight.tip"));
        benthosTotalInertWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        benthosTotalInertWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalLivingNotItemizedWeightField() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightField", benthosTotalLivingNotItemizedWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalLivingNotItemizedWeightField.setName("benthosTotalLivingNotItemizedWeightField");
        benthosTotalLivingNotItemizedWeightField.setShowReset(true);
        benthosTotalLivingNotItemizedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        benthosTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightLabel", benthosTotalLivingNotItemizedWeightLabel = new JLabel());
        
        benthosTotalLivingNotItemizedWeightLabel.setName("benthosTotalLivingNotItemizedWeightLabel");
        benthosTotalLivingNotItemizedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight"));
        benthosTotalLivingNotItemizedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.tip"));
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setShowReset(true);
        benthosTotalSortedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        benthosTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        benthosTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(t("tutti.editBenthosBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.setToolTipText(t("tutti.editBenthosBatch.field.benthosTotalWeight.tip"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        benthosTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editBenthosBatch.help"));
    }

    protected void createChangeSampleCategoryMenu() {
        $objectMap.put("changeSampleCategoryMenu", changeSampleCategoryMenu = new JMenuItem());
        
        changeSampleCategoryMenu.setName("changeSampleCategoryMenu");
        changeSampleCategoryMenu.setText(t("tutti.editBenthosBatch.action.changeSampleCategory"));
        changeSampleCategoryMenu.setToolTipText(t("tutti.editBenthosBatch.action.changeSampleCategory.tip"));
        changeSampleCategoryMenu.putClientProperty("help", "tutti.editBenthosBatch.action.changeSampleCategory.help");
        changeSampleCategoryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.ChangeBenthosBatchSampleCategoryAction.class);
    }

    protected void createCreateBenthosBatchButton() {
        $objectMap.put("createBenthosBatchButton", createBenthosBatchButton = new JButton());
        
        createBenthosBatchButton.setName("createBenthosBatchButton");
        createBenthosBatchButton.setText(t("tutti.editBenthosBatch.action.createBatch"));
        createBenthosBatchButton.setToolTipText(t("tutti.editBenthosBatch.action.createBatch.tip"));
        createBenthosBatchButton.putClientProperty("help", "tutti.editBenthosBatch.action.createBatch.help");
        createBenthosBatchButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.OpenCreateBenthosBatchUIAction.class);
    }

    protected void createCreateBenthosMelagMenu() {
        $objectMap.put("createBenthosMelagMenu", createBenthosMelagMenu = new JMenuItem());
        
        createBenthosMelagMenu.setName("createBenthosMelagMenu");
        createBenthosMelagMenu.setText(t("tutti.editBenthosBatch.action.createMelag"));
        createBenthosMelagMenu.setToolTipText(t("tutti.editBenthosBatch.action.createMelag.tip"));
        createBenthosMelagMenu.putClientProperty("help", "tutti.editBenthosBatch.action.createMelag.help");
        createBenthosMelagMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.CreateBenthosMelagAction.class);
    }

    protected void createEditFrequenciesMenu() {
        $objectMap.put("editFrequenciesMenu", editFrequenciesMenu = new JMenuItem());
        
        editFrequenciesMenu.setName("editFrequenciesMenu");
        editFrequenciesMenu.setText(t("tutti.editBenthosBatch.action.editFrequencies"));
        editFrequenciesMenu.setToolTipText(t("tutti.editBenthosBatch.action.editFrequencies.tip"));
        editFrequenciesMenu.putClientProperty("help", "tutti.editBenthosBatch.action.editFrequencies.help");
        editFrequenciesMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.OpenEditBenthosBatchFrequencyUIAction.class);
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JMenuItem());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editBenthosBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editBenthosBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editBenthosBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.ExportMultiPostBenthosAction.class);
    }

    protected void createFilterBenthosBatchAllButton() {
        $objectMap.put("filterBenthosBatchAllButton", filterBenthosBatchAllButton = new JRadioButton());
        
        filterBenthosBatchAllButton.setName("filterBenthosBatchAllButton");
        filterBenthosBatchAllButton.setText(t("tutti.editBenthosBatch.filterBatch.mode.all"));
        { filterBenthosBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterBenthosBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchAllButton.setToolTipText(t("tutti.editBenthosBatch.filterBatch.mode.all.tip"));
        filterBenthosBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchAllButton"));
    }

    protected void createFilterBenthosBatchLabel() {
        $objectMap.put("filterBenthosBatchLabel", filterBenthosBatchLabel = new JLabel());
        
        filterBenthosBatchLabel.setName("filterBenthosBatchLabel");
        filterBenthosBatchLabel.setText(t("tutti.editBenthosBatch.filterBatch"));
        filterBenthosBatchLabel.setToolTipText(t("tutti.editBenthosBatch.filterBatch.tip"));
        filterBenthosBatchLabel.putClientProperty("help", "tutti.editBenthosBatch.filterBatch.help");
        filterBenthosBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterBenthosBatchLeafButton() {
        $objectMap.put("filterBenthosBatchLeafButton", filterBenthosBatchLeafButton = new JRadioButton());
        
        filterBenthosBatchLeafButton.setName("filterBenthosBatchLeafButton");
        filterBenthosBatchLeafButton.setText(t("tutti.editBenthosBatch.filterBatch.mode.leaf"));
        { filterBenthosBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterBenthosBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchLeafButton.setToolTipText(t("tutti.editBenthosBatch.filterBatch.mode.leaf.tip"));
        filterBenthosBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchLeafButton"));
    }

    protected void createFilterBenthosBatchMode() {
        $objectMap.put("filterBenthosBatchMode", filterBenthosBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterBenthosBatchRootButton() {
        $objectMap.put("filterBenthosBatchRootButton", filterBenthosBatchRootButton = new JRadioButton());
        
        filterBenthosBatchRootButton.setName("filterBenthosBatchRootButton");
        { filterBenthosBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterBenthosBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchRootButton.setToolTipText(t("tutti.editBenthosBatch.filterBatch.mode.root.tip"));
        filterBenthosBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected BenthosBatchUIHandler createHandler() {
        return new BenthosBatchUIHandler();
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JMenuItem());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editBenthosBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editBenthosBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editBenthosBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.ImportMultiPostBenthosAction.class);
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuAction() {
        $objectMap.put("menuAction", menuAction = new JMenu());
        
        menuAction.setName("menuAction");
        menuAction.setOpaque(true);
        menuAction.setText(t("tutti.toolbar.menu.action"));
        menuAction.setToolTipText(t("tutti.toolbar.menu.action.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosBatchUIModel.class));
    }

    protected void createRemoveBenthosBatchMenu() {
        $objectMap.put("removeBenthosBatchMenu", removeBenthosBatchMenu = new JMenuItem());
        
        removeBenthosBatchMenu.setName("removeBenthosBatchMenu");
        removeBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeBatch.help");
        removeBenthosBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.RemoveBenthosBatchAction.class);
    }

    protected void createRemoveBenthosSubBatchMenu() {
        $objectMap.put("removeBenthosSubBatchMenu", removeBenthosSubBatchMenu = new JMenuItem());
        
        removeBenthosSubBatchMenu.setName("removeBenthosSubBatchMenu");
        removeBenthosSubBatchMenu.setText(t("tutti.editBenthosBatch.action.removeSubBatch"));
        removeBenthosSubBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.removeSubBatch.tip"));
        removeBenthosSubBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeSubBatch.help");
        removeBenthosSubBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.RemoveBenthosSubBatchAction.class);
    }

    protected void createRenameBenthosBatchMenu() {
        $objectMap.put("renameBenthosBatchMenu", renameBenthosBatchMenu = new JMenuItem());
        
        renameBenthosBatchMenu.setName("renameBenthosBatchMenu");
        renameBenthosBatchMenu.setText(t("tutti.editBenthosBatch.action.renameBatch"));
        renameBenthosBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.renameBatch.tip"));
        renameBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.renameBatch.help");
        renameBenthosBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.RenameBenthosBatchAction.class);
    }

    protected void createSpeciesSort() {
        $objectMap.put("speciesSort", speciesSort = new JAXXButtonGroup());
    }

    protected void createSpeciesSortBatchLabel() {
        $objectMap.put("speciesSortBatchLabel", speciesSortBatchLabel = new JLabel());
        
        speciesSortBatchLabel.setName("speciesSortBatchLabel");
        speciesSortBatchLabel.setText(t("tutti.editBenthosBatch.sortSpeciesBatch"));
        speciesSortBatchLabel.setToolTipText(t("tutti.editBenthosBatch.sortSpeciesBatch.tip"));
        speciesSortBatchLabel.putClientProperty("help", "tutti.editBenthosBatch.sortSpeciesBatch.help");
        speciesSortBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createSpeciesSortModeAscButton() {
        $objectMap.put("speciesSortModeAscButton", speciesSortModeAscButton = new JRadioButton());
        
        speciesSortModeAscButton.setName("speciesSortModeAscButton");
        speciesSortModeAscButton.setText(t("tutti.editBenthosBatch.speciesSortMode.asc"));
        { speciesSortModeAscButton.putClientProperty("$value", "ASC");  Object $buttonGroup = speciesSortModeAscButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeAscButton.setToolTipText(t("tutti.editBenthosBatch.speciesSortMode.asc.tip"));
        speciesSortModeAscButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeAscButton"));
        speciesSortModeAscButton.putClientProperty("help", "tutti.editBenthosBatch.field.speciesSortMode.asc.help");
    }

    protected void createSpeciesSortModeDescButton() {
        $objectMap.put("speciesSortModeDescButton", speciesSortModeDescButton = new JRadioButton());
        
        speciesSortModeDescButton.setName("speciesSortModeDescButton");
        speciesSortModeDescButton.setText(t("tutti.editBenthosBatch.speciesSortMode.desc"));
        { speciesSortModeDescButton.putClientProperty("$value", "DESC");  Object $buttonGroup = speciesSortModeDescButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeDescButton.setToolTipText(t("tutti.editBenthosBatch.speciesSortMode.desc.tip"));
        speciesSortModeDescButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeDescButton"));
        speciesSortModeDescButton.putClientProperty("help", "tutti.editBenthosBatch.field.speciesSortMode.desc.help");
    }

    protected void createSpeciesSortModeNoneButton() {
        $objectMap.put("speciesSortModeNoneButton", speciesSortModeNoneButton = new JRadioButton());
        
        speciesSortModeNoneButton.setName("speciesSortModeNoneButton");
        speciesSortModeNoneButton.setText(t("tutti.editBenthosBatch.speciesSortMode.none"));
        { speciesSortModeNoneButton.putClientProperty("$value", "NONE");  Object $buttonGroup = speciesSortModeNoneButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeNoneButton.setToolTipText(t("tutti.editBenthosBatch.speciesSortMode.none.tip"));
        speciesSortModeNoneButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeNoneButton"));
        speciesSortModeNoneButton.putClientProperty("help", "tutti.editBenthosBatch.field.speciesSortMode.none.help");
    }

    protected void createSpeciesSortTablePane() {
        $objectMap.put("speciesSortTablePane", speciesSortTablePane = new JPanel());
        
        speciesSortTablePane.setName("speciesSortTablePane");
    }

    protected void createSplitBenthosBatchMenu() {
        $objectMap.put("splitBenthosBatchMenu", splitBenthosBatchMenu = new JMenuItem());
        
        splitBenthosBatchMenu.setName("splitBenthosBatchMenu");
        splitBenthosBatchMenu.setText(t("tutti.editBenthosBatch.action.splitBatch"));
        splitBenthosBatchMenu.setToolTipText(t("tutti.editBenthosBatch.action.splitBatch.tip"));
        splitBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.splitBatch.help");
        splitBenthosBatchMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions.OpenSplitBenthosBatchUIAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editBenthosBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToBenthosBatchTabToolBar();
        addChildrenToMenu();
        addChildrenToMenuAction();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createBenthosBatchButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(filterTablePane);
        $JPanel1.add(speciesSortTablePane);
        addChildrenToFilterTablePane();
        addChildrenToFilterBenthosBatchAllButton();
        addChildrenToFilterBenthosBatchLeafButton();
        addChildrenToFilterBenthosBatchRootButton();
        addChildrenToSpeciesSortTablePane();
        addChildrenToSpeciesSortModeNoneButton();
        addChildrenToSpeciesSortModeAscButton();
        addChildrenToSpeciesSortModeDescButton();
        addChildrenToTableScrollPane();
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 53 property setters
        menu.setBorder(null);
        menu.setBackground(javax.swing.UIManager.getColor("MenuBar.background"));
        menuAction.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.toolbar.menu.action.mnemonic"),'Z'));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.importMultiPost.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.exportMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        splitBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.splitBatch.mnemonic"),'Z'));
        splitBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        changeSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.changeSampleCategory.mnemonic"),'Z'));
        changeSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        addSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.addSampleCategory.mnemonic"),'Z'));
        addSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        removeBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.removeBatch.mnemonic"),'Z'));
        removeBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.removeSubBatch.mnemonic"),'Z'));
        removeBenthosSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        renameBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.renameBatch.mnemonic"),'Z'));
        renameBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        createBenthosMelagMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.createMelag.mnemonic"),'Z'));
        createBenthosMelagMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        editFrequenciesMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.editFrequencies.mnemonic"),'Z'));
        editFrequenciesMenu.setIcon(SwingUtil.createActionIcon("show-frequency"));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setNumberType(Float.class);
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalInertWeightLabel.setLabelFor(benthosTotalInertWeightField);
        benthosTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalInertWeightField.setNumberType(Float.class);
        benthosTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalLivingNotItemizedWeightLabel.setLabelFor(benthosTotalLivingNotItemizedWeightField);
        benthosTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalLivingNotItemizedWeightField.setNumberType(Float.class);
        benthosTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createBenthosBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editBenthosBatch.action.createBatch.mnemonic"),'Z'));
        createBenthosBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterBenthosBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        speciesSortTablePane.setBorder(new TitledBorder(null, ""));
        speciesSortBatchLabel.setIcon(SwingUtil.createActionIcon("sort"));
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editBenthosBatchTopPanel, "tutti.editBenthosBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editBenthosBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editBenthosBatch.action.exportMultiPost.help");
        registerHelpId(_broker, splitBenthosBatchMenu, "tutti.editBenthosBatch.action.splitBatch.help");
        registerHelpId(_broker, changeSampleCategoryMenu, "tutti.editBenthosBatch.action.changeSampleCategory.help");
        registerHelpId(_broker, addSampleCategoryMenu, "tutti.editBenthosBatch.action.addSampleCategory.help");
        registerHelpId(_broker, removeBenthosBatchMenu, "tutti.editBenthosBatch.action.removeBatch.help");
        registerHelpId(_broker, removeBenthosSubBatchMenu, "tutti.editBenthosBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameBenthosBatchMenu, "tutti.editBenthosBatch.action.renameBatch.help");
        registerHelpId(_broker, createBenthosMelagMenu, "tutti.editBenthosBatch.action.createMelag.help");
        registerHelpId(_broker, editFrequenciesMenu, "tutti.editBenthosBatch.action.editFrequencies.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalWeightField, "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightField, "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightField, "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightField, "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalInertWeightLabel, "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        registerHelpId(_broker, benthosTotalInertWeightField, "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        registerHelpId(_broker, benthosTotalLivingNotItemizedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, benthosTotalLivingNotItemizedWeightField, "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createBenthosBatchButton, "tutti.editBenthosBatch.action.createBatch.help");
        registerHelpId(_broker, filterBenthosBatchLabel, "tutti.editBenthosBatch.filterBatch.help");
        registerHelpId(_broker, speciesSortBatchLabel, "tutti.editBenthosBatch.sortSpeciesBatch.help");
        registerHelpId(_broker, speciesSortModeNoneButton, "tutti.editBenthosBatch.field.speciesSortMode.none.help");
        registerHelpId(_broker, speciesSortModeAscButton, "tutti.editBenthosBatch.field.speciesSortMode.asc.help");
        registerHelpId(_broker, speciesSortModeDescButton, "tutti.editBenthosBatch.field.speciesSortMode.desc.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editBenthosBatchTopPanel", editBenthosBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createBenthosBatchTabToolBar();
        createMenu();
        createMenuAction();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createBenthosBatchAttachmentsButton();
        createTablePopup();
        createSplitBenthosBatchMenu();
        createChangeSampleCategoryMenu();
        createAddSampleCategoryMenu();
        createRemoveBenthosBatchMenu();
        createRemoveBenthosSubBatchMenu();
        createRenameBenthosBatchMenu();
        createCreateBenthosMelagMenu();
        createEditFrequenciesMenu();
        createForm();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createBenthosTotalInertWeightLabel();
        createBenthosTotalInertWeightField();
        createBenthosTotalLivingNotItemizedWeightLabel();
        createBenthosTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateBenthosBatchButton();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout());
        createFilterTablePane();
        createFilterBenthosBatchLabel();
        createFilterBenthosBatchAllButton();
        createFilterBenthosBatchLeafButton();
        createFilterBenthosBatchRootButton();
        createSpeciesSortTablePane();
        createSpeciesSortBatchLabel();
        createSpeciesSortModeNoneButton();
        createSpeciesSortModeAscButton();
        createSpeciesSortModeDescButton();
        createTableScrollPane();
        createTable();
        createFilterBenthosBatchMode();
        createSpeciesSort();
        // inline creation of editBenthosBatchTopPanel
        setName("editBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        editBenthosBatchTopPanel.putClientProperty("help", "tutti.editBenthosBatch.help");
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    changeSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isChangeSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isAddSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_BENTHOS_MELAG_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createBenthosMelagMenu.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_FREQUENCIES_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editFrequenciesMenu.setEnabled(model.isTableViewModeAll() && model.isEditFrequenciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalWeightField, handler.getWeightStringValue(benthosTotalWeightLabel, model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setNumberValue(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setBean(model.getBenthosTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalSampleSortedWeightField, handler.getWeightStringValue(benthosTotalSampleSortedWeightLabel, model.getBenthosTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, handler.getWeightStringValue(benthosTotalUnsortedWeightLabel, model.getBenthosTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setNumberValue(model.getBenthosTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setBean(model.getBenthosTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setNumberValue(model.getBenthosTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setBean(model.getBenthosTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setText(t(handler.getFilterBenthosBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeNone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeNoneButton.setSelected(model.isSpeciesSortModeNone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeNone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeAscButton.setSelected(model.isSpeciesSortModeAsc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeDescButton.setSelected(model.isSpeciesSortModeDesc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        });
    }

}