package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class AccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<AccidentalBatchUIModel, AccidentalBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_ACCIDENTAL_BATCH_MENU_ENABLED = "removeAccidentalBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment accidentalBatchAttachmentsButton;
    protected JToolBar accidentalBatchTabToolBar;
    protected TuttiHelpBroker broker;
    protected JButton createAccidentalBatchButton;
    protected AccidentalBatchUI editAccidentalBatchTopPanel = this;
    protected JMenuItem exportMultiPostButton;
    protected final AccidentalBatchUIHandler handler = createHandler();
    protected JMenuItem importMultiPostButton;
    protected JMenuBar menu;
    protected JMenu menuAction;
    protected AccidentalBatchUIModel model;
    protected JMenuItem removeAccidentalBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<AccidentalBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccidentalBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI() {
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAccidentalBatchAttachmentsButton() {
        return accidentalBatchAttachmentsButton;
    }

    public JToolBar getAccidentalBatchTabToolBar() {
        return accidentalBatchTabToolBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateAccidentalBatchButton() {
        return createAccidentalBatchButton;
    }

    public JMenuItem getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public AccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public JMenuItem getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAction() {
        return menuAction;
    }

    public AccidentalBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveAccidentalBatchMenu() {
        return removeAccidentalBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<AccidentalBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalBatchTabToolBar.add(menu);
        accidentalBatchTabToolBar.add(accidentalBatchAttachmentsButton);
    }

    protected void addChildrenToEditAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(accidentalBatchTabToolBar);
        add(tableToolbar, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuAction);
    }

    protected void addChildrenToMenuAction() {
        if (!allComponentsCreated) {
            return;
        }
        menuAction.add(importMultiPostButton);
        menuAction.add(exportMultiPostButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeAccidentalBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalBatchAttachmentsButton() {
        $objectMap.put("accidentalBatchAttachmentsButton", accidentalBatchAttachmentsButton = new ButtonAttachment(handler.getContext(), getContextValue(EditCatchesUIModel.class)));
        
        accidentalBatchAttachmentsButton.setName("accidentalBatchAttachmentsButton");
        accidentalBatchAttachmentsButton.setToolTipText(t("tutti.editAccidentalBatch.action.attachments.tip"));
        accidentalBatchAttachmentsButton.setFocusPainted(false);
    }

    protected void createAccidentalBatchTabToolBar() {
        $objectMap.put("accidentalBatchTabToolBar", accidentalBatchTabToolBar = new JToolBar());
        
        accidentalBatchTabToolBar.setName("accidentalBatchTabToolBar");
        accidentalBatchTabToolBar.setBorderPainted(false);
        accidentalBatchTabToolBar.setOpaque(true);
        accidentalBatchTabToolBar.setFloatable(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editAccidentalBatch.help"));
    }

    protected void createCreateAccidentalBatchButton() {
        $objectMap.put("createAccidentalBatchButton", createAccidentalBatchButton = new JButton());
        
        createAccidentalBatchButton.setName("createAccidentalBatchButton");
        createAccidentalBatchButton.setText(t("tutti.editAccidentalBatch.action.createBatch"));
        createAccidentalBatchButton.setToolTipText(t("tutti.editAccidentalBatch.action.createBatch.tip"));
        createAccidentalBatchButton.putClientProperty("help", "tutti.editAccidentalBatch.action.createBatch.help");
        createAccidentalBatchButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.actions.OpenCreateAccidentalBatchUIAction.class);
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JMenuItem());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editAccidentalBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editAccidentalBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editAccidentalBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.actions.ExportMultiPostAccidentalAction.class);
    }

    protected AccidentalBatchUIHandler createHandler() {
        return new AccidentalBatchUIHandler();
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JMenuItem());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editAccidentalBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editAccidentalBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editAccidentalBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.actions.ImportMultiPostAccidentalAction.class);
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuAction() {
        $objectMap.put("menuAction", menuAction = new JMenu());
        
        menuAction.setName("menuAction");
        menuAction.setOpaque(true);
        menuAction.setText(t("tutti.toolbar.menu.action"));
        menuAction.setToolTipText(t("tutti.toolbar.menu.action.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AccidentalBatchUIModel.class));
    }

    protected void createRemoveAccidentalBatchMenu() {
        $objectMap.put("removeAccidentalBatchMenu", removeAccidentalBatchMenu = new JMenuItem());
        
        removeAccidentalBatchMenu.setName("removeAccidentalBatchMenu");
        removeAccidentalBatchMenu.setText(t("tutti.editAccidentalBatch.action.removeBatch"));
        removeAccidentalBatchMenu.setToolTipText(t("tutti.editAccidentalBatch.action.removeBatch.tip"));
        removeAccidentalBatchMenu.putClientProperty("help", "tutti.editAccidentalBatch.action.removeBatch.help");
        removeAccidentalBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.actions.RemoveAccidentalBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editAccidentalBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
        SwingUtil.setComponentHeight(tableToolbar,50);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(AccidentalBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditAccidentalBatchTopPanel();
        addChildrenToValidator();
        addChildrenToAccidentalBatchTabToolBar();
        addChildrenToMenu();
        addChildrenToMenuAction();
        addChildrenToTablePopup();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createAccidentalBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        menu.setBorder(null);
        menu.setBackground(javax.swing.UIManager.getColor("MenuBar.background"));
        menuAction.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.toolbar.menu.action.mnemonic"),'Z'));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editAccidentalBatch.action.importMultiPost.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editAccidentalBatch.action.exportMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        removeAccidentalBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editAccidentalBatch.action.removeBatch.mnemonic"),'Z'));
        removeAccidentalBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        createAccidentalBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editAccidentalBatch.action.createBatch.mnemonic"),'Z'));
        createAccidentalBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editAccidentalBatchTopPanel, "tutti.editAccidentalBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editAccidentalBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editAccidentalBatch.action.exportMultiPost.help");
        registerHelpId(_broker, removeAccidentalBatchMenu, "tutti.editAccidentalBatch.action.removeBatch.help");
        registerHelpId(_broker, createAccidentalBatchButton, "tutti.editAccidentalBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editAccidentalBatchTopPanel", editAccidentalBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createAccidentalBatchTabToolBar();
        createMenu();
        createMenuAction();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createAccidentalBatchAttachmentsButton();
        createTablePopup();
        createRemoveAccidentalBatchMenu();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateAccidentalBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editAccidentalBatchTopPanel
        setName("editAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        editAccidentalBatchTopPanel.putClientProperty("help", "tutti.editAccidentalBatch.help");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ACCIDENTAL_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeAccidentalBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
    }

}