/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class EditProtocolSpeciesTableModel
extends AbstractApplicationTableModel<EditProtocolSpeciesRowModel> {
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SPECIES_ID = ColumnIdentifier.newId((String)"species", (String)I18n.n((String)"tutti.editProtocol.table.header.speciesReferenceTaxonId", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.speciesReferenceTaxonId.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SURVEY_CODE_ID = ColumnIdentifier.newId((String)"speciesSurveyCode", (String)I18n.n((String)"tutti.editProtocol.table.header.speciesSurveyCode", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.speciesSurveyCode.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> LENGTH_STEP_PMFM_ID = ColumnIdentifier.newId((String)"lengthStepPmfm", (String)I18n.n((String)"tutti.editProtocol.table.header.lengthStep", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.lengthStep.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> WEIGHT_ENABLED = ColumnIdentifier.newId((String)"weightEnabled", (String)I18n.n((String)"tutti.editProtocol.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.weight.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> COUNT_IF_NO_FREQUENCY_ENABLED = ColumnIdentifier.newId((String)"countIfNoFrequencyEnabled", (String)I18n.n((String)"tutti.editProtocol.table.header.countIfNoFrequency", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.countIfNoFrequency.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> CALCIFY_SAMPLE_ENABLED = ColumnIdentifier.newId((String)"calcifySampleEnabled", (String)I18n.n((String)"tutti.editProtocol.table.header.calcifySample", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.calcifySample.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> USE_RTP = ColumnIdentifier.newId((String)"useRtp", (String)I18n.n((String)"tutti.editProtocol.table.header.useRtp", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editProtocol.table.header.useRtp.tip", (Object[])new Object[0]));
    protected final SampleCategoryModel sampleCategoryModel;
    private static final long serialVersionUID = 1L;

    public EditProtocolSpeciesTableModel(SampleCategoryModel sampleCategoryModel, TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.sampleCategoryModel = sampleCategoryModel;
        this.setNoneEditableCols(new ColumnIdentifier[]{SPECIES_ID});
    }

    public static EditProtocolSpeciesRowModel newRow(SampleCategoryModel sampleCategoryModel) {
        EditProtocolSpeciesRowModel result = new EditProtocolSpeciesRowModel();
        ArrayList mandatoryIds = Lists.newArrayList(sampleCategoryModel.getSamplingOrder());
        mandatoryIds.remove(0);
        result.setMandatorySampleCategoryId(mandatoryIds);
        result.setWeightEnabled(true);
        result.setCountIfNoFrequencyEnabled(true);
        result.setCalcifySampleEnabled(true);
        result.setValid(true);
        result.addPropertyChangeListener("lengthStepPmfm", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    EditProtocolSpeciesRowModel rowModel = (EditProtocolSpeciesRowModel)evt.getSource();
                    rowModel.setRtpMale(null);
                    rowModel.setRtpFemale(null);
                    rowModel.setRtpUndefined(null);
                }
            }
        });
        return result;
    }

    public EditProtocolSpeciesRowModel createNewRow() {
        EditProtocolSpeciesRowModel result = EditProtocolSpeciesTableModel.newRow(this.sampleCategoryModel);
        return result;
    }

    protected void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<EditProtocolSpeciesRowModel> propertyName, EditProtocolSpeciesRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, (Serializable)entry);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<EditProtocolSpeciesRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result && USE_RTP.equals(propertyName)) {
            EditProtocolSpeciesRowModel entry = (EditProtocolSpeciesRowModel)this.getEntry(rowIndex);
            result = entry.getLengthStepPmfm() != null;
        }
        return result;
    }

    public List<Species> getSpeciesList() {
        ArrayList result = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : this.rows) {
            result.add(row.getSpecies());
        }
        return result;
    }
}

