/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.core.framework.jar.Bundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;

public class ConfigurationElement
implements IConfigurationElement {
    protected Object parent;
    protected Bundle bundle;
    protected IExtension extension;
    protected String name;
    protected String label;
    protected String value;
    protected HashMap<String, String> attributes;
    protected ConfigurationElement[] children;

    public Object createExecutableExtension(String propertyName) throws CoreException {
        String value = this.attributes.get(propertyName);
        if (value != null) {
            try {
                Class<?> clazz = Class.forName(value);
                Object inst = clazz.newInstance();
                if (inst instanceof IExecutableExtension) {
                    ((IExecutableExtension)inst).setInitializationData((IConfigurationElement)this, propertyName, null);
                }
                return inst;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.birt.core", 0, e.getMessage(), (Throwable)e));
            }
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public IConfigurationElement[] getChildren() {
        return this.children;
    }

    public IConfigurationElement[] getChildren(String name) {
        ArrayList<ConfigurationElement> namedChildren = new ArrayList<ConfigurationElement>();
        ConfigurationElement[] configurationElementArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElement child = configurationElementArray[n2];
            if (name.equals(child.getName())) {
                namedChildren.add(child);
            }
            ++n2;
        }
        return namedChildren.toArray(new IConfigurationElement[namedChildren.size()]);
    }

    public IExtension getDeclaringExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.parent instanceof IExtension) {
            return (IExtension)this.parent;
        }
        if (this.parent instanceof ConfigurationElement) {
            return ((ConfigurationElement)this.parent).getDeclaringExtension();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object getParent() {
        return this.parent;
    }

    public String getValue() {
        return this.value;
    }

    public String getAttribute(String arg0, String arg1) {
        return null;
    }

    public String getAttributeAsIs(String name) {
        return this.getAttribute(name);
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        if (this.bundle == null) {
            IExtension declaringExtn = this.getDeclaringExtension();
            if (declaringExtn != null) {
                return declaringExtn.getContributor();
            }
            return null;
        }
        return this.bundle.getContributor();
    }

    public String getNamespace() throws InvalidRegistryObjectException {
        return this.bundle.getSymbolicName();
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.bundle.getSymbolicName();
    }

    public String getValue(String arg) throws InvalidRegistryObjectException {
        return null;
    }

    public String getValueAsIs() throws InvalidRegistryObjectException {
        return this.value;
    }

    public boolean isValid() {
        return true;
    }
}

