/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchNaturalOrderComparator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.util.Numbers;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jaxx.runtime.swing.JTables;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class ComputeBatchWeightsAction
extends LongActionSupport<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    protected final WeightCleaningService cleaningService = this.getContext().getWeightCleaningService();
    protected List<SpeciesBatchRowModel> speciesBatchRows;
    protected List<BenthosBatchRowModel> benthosBatchRows;
    protected CatchBatch catchBatch;
    protected Boolean modified;
    protected Integer tabInError;

    public ComputeBatchWeightsAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        this.speciesBatchRows = null;
        this.benthosBatchRows = null;
        this.catchBatch = null;
        this.modified = null;
        this.tabInError = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
            Multimap errors = this.cleaningService.checkFishingOperation(fishingOperation.getId());
            if (errors.isEmpty()) {
                this.sendMessage(I18n.t((String)"tutti.editCatchBatch.action.computeWeights.no.double.weight.detected", (Object[])new Object[0]));
            } else {
                String errorsStr = this.cleaningService.errorsToString(errors);
                String htmlMessage = I18n.t((String)"tutti.editCatchBatch.action.computeWeights.double.weight.detected", (Object[])new Object[]{errorsStr});
                JOptionPane.showMessageDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.computeWeights.double.weight.detected.title", (Object[])new Object[0]), 2);
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        int answer;
        String htmlMessage;
        BatchContainer computedMarineLitterBatches;
        Float totalBenthosSortedWeight;
        BatchContainer computedBenthosBatches;
        Float totalSpeciesSortedWeight;
        BatchContainer computedSpeciesBatches;
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        WeightComputingService weightComputingService = this.getContext().getWeightComputingService();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        String operationId = model.getFishingOperation().getId();
        try {
            computedSpeciesBatches = weightComputingService.getComputedSpeciesBatches(operationId);
            totalSpeciesSortedWeight = this.computeSpeciesBatches(persistenceService, (BatchContainer<SpeciesBatch>)computedSpeciesBatches);
        }
        catch (TuttiWeightComputingException e) {
            this.tabInError = 1;
            throw e;
        }
        try {
            computedBenthosBatches = weightComputingService.getComputedBenthosBatches(operationId);
            totalBenthosSortedWeight = this.computeBenthosBatches(persistenceService, (BatchContainer<BenthosBatch>)computedBenthosBatches);
        }
        catch (TuttiWeightComputingException e) {
            this.tabInError = 2;
            throw e;
        }
        try {
            computedMarineLitterBatches = weightComputingService.getComputedMarineLitterBatches(operationId, model.getMarineLitterTotalWeight());
        }
        catch (TuttiWeightComputingException e) {
            this.tabInError = 3;
            throw e;
        }
        this.modified = model.isModify();
        this.catchBatch = model.toEntity();
        Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
        if (model.getSpeciesTotalSortedWeight() != null && model.getSpeciesTotalSortedWeight().floatValue() >= totalSpeciesSortedWeight.floatValue() && model.getSpeciesTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSpeciesSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(1);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.species", (Object[])new Object[]{rate}), I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                this.catchBatch.setSpeciesTotalSortedWeight(null);
                this.catchBatch.setSpeciesTotalSortedComputedWeight(totalSpeciesSortedWeight);
                this.modified = true;
            }
        }
        if (model.getBenthosTotalSortedWeight() != null && model.getBenthosTotalSortedWeight().floatValue() >= totalBenthosSortedWeight.floatValue() && model.getBenthosTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalBenthosSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(2);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.benthos", (Object[])new Object[]{rate}), I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                this.catchBatch.setBenthosTotalSortedWeight(null);
                this.catchBatch.setBenthosTotalSortedComputedWeight(totalBenthosSortedWeight);
                this.modified = true;
            }
        }
        weightComputingService.computeCatchBatchWeights(this.catchBatch, computedSpeciesBatches, computedBenthosBatches, computedMarineLitterBatches);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.afterAction();
        ((EditCatchesUI)this.getUI()).repaint();
    }

    protected void afterAction() {
        EditCatchesUIModel editCatchesUIModel = (EditCatchesUIModel)this.getModel();
        editCatchesUIModel.setLoadingData(true);
        try {
            if (this.speciesBatchRows != null) {
                ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().setRows(this.speciesBatchRows);
            }
            if (this.benthosBatchRows != null) {
                ((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel().setRows(this.benthosBatchRows);
            }
            if (this.catchBatch != null) {
                editCatchesUIModel.fromEntity(this.catchBatch);
            }
            if (this.modified != null) {
                editCatchesUIModel.setModify(this.modified);
            }
        }
        finally {
            editCatchesUIModel.setLoadingData(false);
        }
        AbstractTuttiBatchUIModel model = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel();
        SpeciesSortMode sortMode = ((SpeciesBatchUIModel)model).getSpeciesSortMode();
        if (sortMode != SpeciesSortMode.NONE) {
            ((SpeciesBatchUIModel)model).setSpeciesSortMode(SpeciesSortMode.NONE);
            ((SpeciesBatchUIModel)model).setSpeciesSortMode(sortMode);
        }
        if ((sortMode = ((BenthosBatchUIModel)(model = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel())).getSpeciesSortMode()) != SpeciesSortMode.NONE) {
            ((BenthosBatchUIModel)model).setSpeciesSortMode(SpeciesSortMode.NONE);
            ((BenthosBatchUIModel)model).setSpeciesSortMode(sortMode);
        }
    }

    public void postFailedAction(Throwable error) {
        this.afterAction();
        if (error instanceof TuttiWeightComputingException) {
            TuttiWeightComputingException e = (TuttiWeightComputingException)error;
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(this.tabInError);
            switch (this.tabInError) {
                case 1: {
                    this.treatSpeciesBatchError(e);
                    break;
                }
                case 2: {
                    this.treatBenthosBatchError(e);
                    break;
                }
                case 3: {
                    JTables.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getMarineLitterTabContent().getTable(), (int)e.getIndex(), (int)3);
                }
            }
        }
    }

    protected Float computeSpeciesBatches(PersistenceService persistenceService, BatchContainer<SpeciesBatch> computedSpeciesBatches) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        if (computedSpeciesBatches != null) {
            this.speciesBatchRows = Lists.newArrayList();
            List children = computedSpeciesBatches.getChildren();
            for (SpeciesBatch batch : children) {
                SpeciesBatchRowModel row = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getHandler().loadBatch(batch, null, this.speciesBatchRows);
                if (!persistenceService.isVracBatch((SpeciesAbleBatch)row)) continue;
                SampleCategory<?> sampleCategory = row.getFirstSampleCategory();
                Float weight = (Float)Numbers.getValueOrComputedValue((Number)sampleCategory.getCategoryWeight(), (Number)sampleCategory.getComputedWeight());
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
            }
        }
        return totalSortedWeight;
    }

    protected Float computeBenthosBatches(PersistenceService persistenceService, BatchContainer<BenthosBatch> computedBenthosBatches) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        if (computedBenthosBatches != null) {
            this.benthosBatchRows = Lists.newArrayList();
            List children = computedBenthosBatches.getChildren();
            for (BenthosBatch batch : children) {
                BenthosBatchRowModel row = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getHandler().loadBatch(batch, null, this.benthosBatchRows);
                if (!persistenceService.isVracBatch((SpeciesAbleBatch)row)) continue;
                SampleCategory<?> sampleCategory = row.getFirstSampleCategory();
                Float weight = (Float)Numbers.getValueOrComputedValue((Number)sampleCategory.getCategoryWeight(), (Number)sampleCategory.getComputedWeight());
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
            }
        }
        return totalSortedWeight;
    }

    protected void treatSpeciesBatchError(TuttiWeightComputingException e) {
        SpeciesBatchRowModel row;
        ArrayList rows;
        int index = e.getIndex();
        SpeciesBatchUIModel speciesBatchUIModel = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel();
        if (speciesBatchUIModel.getSpeciesSortMode() != SpeciesSortMode.NONE) {
            rows = Lists.newArrayList(speciesBatchUIModel.getRows());
            SpeciesBatchNaturalOrderComparator.sort(rows);
            row = (SpeciesBatchRowModel)rows.get(index);
            index = speciesBatchUIModel.getRows().indexOf(row);
        } else {
            rows = speciesBatchUIModel.getRows();
            row = (SpeciesBatchRowModel)rows.get(index);
        }
        JXTable table = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getTable();
        SpeciesBatchTableModel tableModel = (SpeciesBatchTableModel)((Object)table.getModel());
        Set sampleCols = tableModel.getSampleCols();
        this.selectBatchCell(table, index, row, e.getProperty(), sampleCols, SpeciesBatchTableModel.WEIGHT);
    }

    protected void treatBenthosBatchError(TuttiWeightComputingException e) {
        BenthosBatchRowModel row;
        ArrayList rows;
        int index = e.getIndex();
        BenthosBatchUIModel benthosBatchUIModel = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel();
        if (benthosBatchUIModel.getSpeciesSortMode() != SpeciesSortMode.NONE) {
            rows = Lists.newArrayList(benthosBatchUIModel.getRows());
            SpeciesBatchNaturalOrderComparator.sort(rows);
            row = (BenthosBatchRowModel)rows.get(index);
            index = benthosBatchUIModel.getRows().indexOf(row);
        } else {
            rows = benthosBatchUIModel.getRows();
            row = (BenthosBatchRowModel)rows.get(index);
        }
        JXTable table = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getTable();
        BenthosBatchTableModel tableModel = (BenthosBatchTableModel)((Object)table.getModel());
        Set sampleCols = tableModel.getSampleCols();
        this.selectBatchCell(table, index, row, e.getProperty(), sampleCols, BenthosBatchTableModel.WEIGHT);
    }

    protected <R extends SampleCategoryAble> void selectBatchCell(JXTable table, int index, SampleCategoryAble row, String property, Set<SampleCategoryColumnIdentifier<R>> sampleCols, ColumnIdentifier<R> weightColumn) {
        TableColumn tableColumn;
        ColumnIdentifier<R> columnIdentifier = weightColumn;
        if ("sampleCategoryWeight".equals(property)) {
            Integer categoryId = row.getFinestCategory().getCategoryId();
            for (SampleCategoryColumnIdentifier<R> sampleCol : sampleCols) {
                if (!categoryId.equals(sampleCol.getSampleCategoryId())) continue;
                columnIdentifier = sampleCol;
                break;
            }
        }
        int column = 0;
        TableColumnExt columnExt = table.getColumnExt(columnIdentifier);
        int modelIndex = columnExt.getModelIndex();
        Iterator iterator = table.getColumns(false).iterator();
        while (iterator.hasNext() && !columnExt.equals(tableColumn = (TableColumn)iterator.next()) && tableColumn.getModelIndex() <= modelIndex) {
            ++column;
        }
        JTables.doSelectCell((JTable)table, (int)index, (int)column);
    }
}

