/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.ConceptGroupGenerator;
import com.sun.java.help.search.GeneratorHeap;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.NextDocGenerator;
import com.sun.java.help.search.NextDocGeneratorHeap;
import com.sun.java.help.search.Query;
import com.sun.java.help.search.RoleFiller;
import com.sun.java.help.search.SearchEnvironment;
import javax.help.search.SearchQuery;

class Search {
    private static final int InitNConcepts = 128;
    private SearchEnvironment _env;
    private int _max;
    private int _nConcepts;
    private int _nQueries;
    private ConceptGroupGenerator _firstGenerator = new ConceptGroupGenerator();
    private int[] _concepts = new int[16];
    private int _free2;
    private int _size2;
    private int _startingIndex = 0;
    private int _limit = 0;
    private Query[] _query;
    private ConceptData[] _conceptData;
    private GeneratorHeap _genHeap = new GeneratorHeap();
    private int _document;
    private byte[] _data = null;
    private int _base = 0;
    private NextDocGeneratorHeap _nextDocGenHeap = new NextDocGeneratorHeap();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _offsets = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _docConcepts = new IntegerArray();
    private IntegerArray _queryMasks = new IntegerArray();
    private int _maxHitsToShow = 100;

    public Search(SearchEnvironment searchEnvironment, int n) {
        this._env = searchEnvironment;
        this._nQueries = 1;
        this._query = new Query[this._nQueries];
        this._size2 = 128;
        this._free2 = 0;
        this._conceptData = new ConceptData[this._size2];
        this._query[0] = new Query(searchEnvironment, n, null);
    }

    public void addTerm(int n, int n2, double d, int n3) {
        if (this._env.occursInText(n2)) {
            if (this._free2 == this._size2) {
                ConceptData[] conceptDataArray = new ConceptData[this._size2 *= 2];
                System.arraycopy(this._conceptData, 0, conceptDataArray, 0, this._free2);
                this._conceptData = conceptDataArray;
            }
            this._conceptData[this._free2++] = new ConceptData(n2, n, d, n3, this._query[n3].getNColumns());
        }
    }

    public void startSearch(SearchQuery searchQuery) {
        int n;
        this.quicksort(0, this._free2 - 1);
        int n2 = 0;
        while (n2 < this._free2 - 1) {
            for (n = n2 + 1; n < this._free2; ++n) {
                if (this._conceptData[n2].crqEquals(this._conceptData[n])) {
                    this._conceptData[n] = null;
                    continue;
                }
                n2 = n;
            }
            n2 = n;
        }
        n2 = 0;
        while (n2 < this._free2 - 1) {
            for (n = n2 + 1; n < this._free2; ++n) {
                if (this._conceptData[n] == null) continue;
                if (this._conceptData[n2].cEquals(this._conceptData[n])) {
                    this._conceptData[n2].addLast(this._conceptData[n]);
                    this._conceptData[n] = null;
                    continue;
                }
                n2 = n;
            }
            n2 = n;
        }
        block6: for (n2 = 0; n2 < this._free2 - 1; ++n2) {
            if (this._conceptData[n2] != null) continue;
            for (n = n2 + 1; n < this._free2; ++n) {
                if (this._conceptData[n] == null) continue;
                this._conceptData[n2] = this._conceptData[n];
                this._conceptData[n] = null;
                continue block6;
            }
        }
        this._nextDocGenHeap.reset();
        for (n2 = 0; n2 < this._free2 && this._conceptData[n2] != null; ++n2) {
            NextDocGenerator nextDocGenerator = new NextDocGenerator(this._conceptData[n2], this._env);
            try {
                nextDocGenerator.first();
                if (nextDocGenerator.getDocument() == -1) continue;
                this._conceptData[n2].setConceptLength(this._env.getConceptLength(this._conceptData[n2].getConcept()));
                this._nextDocGenHeap.addGenerator(nextDocGenerator);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._nextDocGenHeap.start();
        this.searchDocument();
        if (searchQuery == null) {
            this.printResults(this._maxHitsToShow);
        } else {
            this._query[0].makeEvent(this._maxHitsToShow, searchQuery);
        }
    }

    private void searchDocument() {
        RoleFiller[] roleFillerArray = new RoleFiller[this._nQueries];
        do {
            try {
                switch (this.nextDocument(roleFillerArray)) {
                    case 0: {
                        this._genHeap.start(roleFillerArray);
                        while (this._genHeap.next(roleFillerArray)) {
                        }
                        break;
                    }
                    case 1: {
                        if (!this._firstGenerator.next()) break;
                        this._firstGenerator.generateFillers(roleFillerArray);
                        while (this._firstGenerator.next()) {
                            this._firstGenerator.generateFillers(roleFillerArray);
                        }
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            for (int i = 0; i < this._nQueries; ++i) {
                RoleFiller roleFiller = roleFillerArray[i];
                if (roleFiller == null || roleFiller == RoleFiller.STOP) continue;
                roleFiller.scoreList(this._query[i], this._document);
            }
            this._genHeap.reset();
        } while (this._nextDocGenHeap.isNonEmpty());
    }

    private int indexOf(int n) throws Exception {
        int n2 = this._startingIndex;
        int n3 = this._nConcepts;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            if (this._concepts[n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n < this._concepts[n4]) {
                n3 = n4 - 1;
                continue;
            }
            this._startingIndex = n4 + 1;
            return n4;
        }
        throw new Exception("indexOf " + n + " not found");
    }

    private void printResults(int n) {
        for (int i = 0; i < this._nQueries; ++i) {
            System.out.println("query " + i);
            if (this._query[i] == null) continue;
            this._query[i].printHits(n);
        }
    }

    private ConceptGroupGenerator makeGenerator(int n) throws Exception {
        int n2;
        int n3;
        if (n > 0) {
            n3 = this._base + this._offsets.at(n - 1);
            n2 = this._maxConcepts.at(n - 1);
        } else {
            n3 = this._base;
            n2 = 0;
        }
        ConceptGroupGenerator conceptGroupGenerator = new ConceptGroupGenerator(this._data, n3, this._kTable.at(2 * n + 1));
        this._nConcepts = conceptGroupGenerator.decodeConcepts(this._kTable.at(2 * n), n2, this._concepts);
        this._max = n < this._limit ? (this._concepts[this._nConcepts] = this._maxConcepts.at(n)) : this._concepts[this._nConcepts - 1];
        this._genHeap.addGenerator(conceptGroupGenerator);
        this._startingIndex = 0;
        return conceptGroupGenerator;
    }

    private boolean openDocumentIndex(int n) throws Exception {
        this._data = this._env.getPositions(n);
        this._base = 0;
        this._startingIndex = 0;
        int n2 = this._data[this._base] & 0xFF;
        switch (n2 >> 6) {
            case 0: {
                byte by = this._data[this._base + 1];
                this._firstGenerator.init(this._data, this._base += 2, by);
                this._nConcepts = this._firstGenerator.decodeConcepts(n2 & 0x3F, 0, this._concepts);
                return false;
            }
            case 2: {
                this._kTable.clear();
                this._offsets.clear();
                this._maxConcepts.clear();
                ByteArrayDecompressor byteArrayDecompressor = new ByteArrayDecompressor(this._data, this._base + 1);
                byteArrayDecompressor.decode(n2 & 0x3F, this._kTable);
                byteArrayDecompressor.ascDecode(this._kTable.popLast(), this._offsets);
                byteArrayDecompressor.ascDecode(this._kTable.popLast(), this._maxConcepts);
                this._base += 1 + byteArrayDecompressor.bytesRead();
                this._limit = this._maxConcepts.cardinality();
                return true;
            }
            case 1: 
            case 3: {
                throw new Exception("extents not yet implemented\n");
            }
        }
        return false;
    }

    private int nextDocument(RoleFiller[] roleFillerArray) throws Exception {
        while (this._nextDocGenHeap.isNonEmpty()) {
            int n;
            for (n = 0; n < this._nQueries; ++n) {
                if (this._query[n] == null) continue;
                this._query[n].resetForNextDocument();
            }
            n = 0;
            this._document = this._nextDocGenHeap.getDocument();
            this._docConcepts.clear();
            this._queryMasks.clear();
            do {
                this._docConcepts.add(this._nextDocGenHeap.getConcept());
                this._queryMasks.add(this._nextDocGenHeap.getQueryMask());
                int n2 = n++;
                ConceptData conceptData = this._nextDocGenHeap.getTerms();
                this._conceptData[n2] = conceptData;
                conceptData.runBy(this._query);
                this._nextDocGenHeap.step();
            } while (this._nextDocGenHeap.atDocument(this._document));
            int n3 = 0;
            for (int i = 0; i < this._nQueries; ++i) {
                if (this._query[i] == null) continue;
                if (this._query[i].vote()) {
                    roleFillerArray[i] = null;
                    n3 |= 1 << i;
                    continue;
                }
                roleFillerArray[i] = RoleFiller.STOP;
            }
            if (n3 == 0) continue;
            if (this.openDocumentIndex(this._document)) {
                int n4 = 0;
                while ((this._queryMasks.at(n4) & n3) == 0) {
                    ++n4;
                }
                int n5 = this._docConcepts.at(n4);
                int n6 = 0;
                while (n5 > this._maxConcepts.at(n6) && ++n6 < this._limit) {
                }
                ConceptGroupGenerator conceptGroupGenerator = this.makeGenerator(n6);
                conceptGroupGenerator.addTerms(this.indexOf(n5), this._conceptData[n4]);
                ++n4;
                while (n4 < n) {
                    if ((this._queryMasks.at(n4) & n3) > 0) {
                        n5 = this._docConcepts.at(n4);
                        if (n5 > this._max) {
                            while (n5 > this._maxConcepts.at(n6) && ++n6 < this._limit) {
                            }
                            conceptGroupGenerator = this.makeGenerator(n6);
                        }
                        conceptGroupGenerator.addTerms(this.indexOf(n5), this._conceptData[n4]);
                    }
                    ++n4;
                }
                return 0;
            }
            for (int i = 0; i < n; ++i) {
                if ((this._queryMasks.at(i) & n3) == 0) continue;
                this._firstGenerator.addTerms(this.indexOf(this._docConcepts.at(i)), this._conceptData[i]);
            }
            return 1;
        }
        return 2;
    }

    private int partition(int n, int n2) {
        ConceptData conceptData = this._conceptData[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (conceptData.compareWith(this._conceptData[--n4])) {
                continue;
            }
            while (this._conceptData[++n3].compareWith(conceptData)) {
            }
            if (n3 >= n4) break;
            ConceptData conceptData2 = this._conceptData[n3];
            this._conceptData[n3] = this._conceptData[n4];
            this._conceptData[n4] = conceptData2;
        }
        return n4;
    }

    private void quicksort(int n, int n2) {
        if (n < n2) {
            int n3 = this.partition(n, n2);
            this.quicksort(n, n3);
            this.quicksort(n3 + 1, n2);
        }
    }
}

