/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin.signs;

import com.google.common.base.Function;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.signs.Sign;
import java.util.Map;

public enum Sex implements Sign
{
    NONE("NONE"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.NON_SEXED_SEX.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return parentSignChildrenNb == 1;
        }
    }
    ,
    UNKNOWN("UNKNOWN"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SEX_UNDEFINED.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return false;
        }
    }
    ,
    MALE("MALE"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SEX_MALE.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return false;
        }
    }
    ,
    FEMALE("FEMALE"){

        @Override
        public Integer getCategory() {
            return PmfmId.SEX.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SEX_FEMALE.getValue();
        }

        @Override
        public boolean isNullEquivalent(int parentSignChildrenNb) {
            return false;
        }
    };

    private String sign;

    private Sex(String sign) {
        this.sign = sign;
    }

    @Override
    public String getSign() {
        return this.sign;
    }

    @Override
    public void registerSign(Caracteristic caracteristic, Map<Sign, CaracteristicQualitativeValue> map) {
        Integer valueId = this.getQualitativeValueId();
        CaracteristicQualitativeValue result = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)valueId);
        map.put(this, result);
    }

    public static Sex getValue(String sign) {
        Sex result = null;
        for (Sex s : Sex.values()) {
            if (!s.sign.equals(sign)) continue;
            result = s;
            break;
        }
        return result;
    }

    public static Function<BigfinDataRow, Sign> newExtractValueFunction() {
        return new Function<BigfinDataRow, Sign>(){

            public Sign apply(BigfinDataRow bigfinDataRow) {
                Sex result = bigfinDataRow.getSex();
                return result;
            }
        };
    }
}

