/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.BookmarkManager;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ExtendedGenerateExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class ExtendedItemExecutor
extends ReportItemExecutor {
    protected IReportItemExecutor executor;

    public ExtendedItemExecutor(ExecutorManager manager) {
        super(manager, 8);
    }

    @Override
    public IContent execute() throws BirtException {
        if (this.executor != null) {
            String bookmark;
            this.getParentResultSet();
            if (this.executor instanceof ExtendedGenerateExecutor) {
                ExtendedGenerateExecutor gExecutor = (ExtendedGenerateExecutor)this.executor;
                gExecutor.parent = this.parent;
                gExecutor.context = this.context;
                gExecutor.report = this.report;
                gExecutor.design = this.design;
            }
            this.content = this.executor.execute();
            if (!(this.executor instanceof ExtendedGenerateExecutor) && (bookmark = this.content.getBookmark()) != null) {
                BookmarkManager bookmarkManager = this.context.getBookmarkManager();
                if (bookmarkManager.exist(bookmark)) {
                    bookmark = bookmarkManager.createBookmark(bookmark);
                    this.content.setBookmark(bookmark);
                } else {
                    bookmarkManager.addBookmark(bookmark);
                }
            }
            if (this.content != null) {
                InstanceID iid;
                IContent pContent = (IContent)this.content.getParent();
                if (pContent == null) {
                    pContent = this.getParentContent();
                    this.content.setParent(pContent);
                }
                if ((iid = this.content.getInstanceID()) != null) {
                    long uid;
                    InstanceID pid = iid.getParentID();
                    if (pid == null && pContent != null) {
                        pid = pContent.getInstanceID();
                    }
                    if ((uid = iid.getUniqueID()) == -1L) {
                        uid = this.generateUniqueID();
                    }
                    iid = new InstanceID(pid, uid, iid.getComponentID(), iid.getDataID());
                    this.content.setInstanceID(iid);
                    this.instanceId = iid;
                } else {
                    iid = this.getInstanceID();
                    this.content.setInstanceID(iid);
                }
                if (this.content.getGenerateBy() == null) {
                    long componentId;
                    if (this.design == null && (componentId = this.content.getInstanceID().getComponentID()) != -1L) {
                        this.design = (ReportItemDesign)this.report.getDesign().getReportItemByID(componentId);
                    }
                    this.content.setGenerateBy(this.design);
                }
                if (this.context.isInFactory()) {
                    this.handleOnCreate(this.content);
                }
                this.setupBookmark();
                this.startTOCEntry(this.content);
            }
        }
        return this.content;
    }

    private void setupBookmark() {
        if (this.content.getBookmark() == null && this.design != null && this.design.getQuery() != null) {
            if (this.context.getReportletBookmark(this.design.getID()) != null) {
                this.content.setBookmark(this.context.getReportletBookmark(this.design.getID()));
            } else {
                this.content.setBookmark(this.manager.nextBookmarkID());
            }
        }
    }

    @Override
    public boolean hasNextChild() throws BirtException {
        if (this.executor != null) {
            return this.executor.hasNextChild();
        }
        return false;
    }

    @Override
    public IReportItemExecutor getNextChild() throws BirtException {
        IReportItemExecutor child;
        if (this.executor != null && (child = this.executor.getNextChild()) != null) {
            if (child instanceof ReportItemExecutor) {
                child.setParent(this);
                return child;
            }
            return this.manager.createExtendedExecutor(this, child);
        }
        return null;
    }

    @Override
    public void close() throws BirtException {
        if (this.executor != null) {
            this.executor.close();
            this.finishTOCEntry();
            this.context.setResultSets(this.parentRsets);
        }
        this.executor = null;
        super.close();
    }

    @Override
    public IBaseResultSet[] getQueryResults() {
        if (this.executor != null) {
            return this.executor.getQueryResults();
        }
        return null;
    }

    @Override
    public void setParent(IReportItemExecutor parent) {
        if (this.executor != null && this.executor.getParent() == null) {
            IReportItemExecutor tmpExecutor = parent;
            if (!(this.executor instanceof ReportItemExecutor) && tmpExecutor instanceof ExtendedItemExecutor) {
                tmpExecutor = ((ExtendedItemExecutor)tmpExecutor).executor;
            }
            this.executor.setParent(tmpExecutor);
        }
        super.setParent(parent);
    }
}

