/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.create;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SelectedCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateSpeciesBatchUIHandler
extends AbstractTuttiTableUIHandler<SplitSpeciesBatchRowModel, CreateSpeciesBatchUIModel, CreateSpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUIHandler.class);
    protected CaracteristicQualitativeValue sortedValue;
    protected SampleCategoryModel sampleCategoryModel;
    protected WeightUnit weightUnit;

    public CreateSpeciesBatchUIHandler() {
        super("selected", "categoryValue", "weight");
    }

    public SplitSpeciesBatchTableModel getTableModel() {
        return (SplitSpeciesBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((CreateSpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SplitSpeciesBatchRowModel row) {
        return row.isSelected();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SplitSpeciesBatchRowModel> rowMonitor, SplitSpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (row.isValid() && log.isInfoEnabled()) {
                log.info((Object)"Change row that was modified and valid");
            }
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, SplitSpeciesBatchRowModel oldRow, int newRowIndex, SplitSpeciesBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        if (newRow != null) {
            this.recomputeRowValidState(newRow);
            this.computeSampleWeight();
        }
    }

    @Override
    protected void onRowModified(int rowIndex, SplitSpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.computeSampleWeight();
    }

    public void beforeInit(CreateSpeciesBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.weightUnit = this.getConfig().getSpeciesWeightUnit();
        this.sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SampleCategoryModelEntry caracteristic = this.sampleCategoryModel.getCategoryById(this.sampleCategoryModel.getFirstCategoryId());
        Integer vracId = QualitativeValueId.SORTED_VRAC.getValue();
        CaracteristicQualitativeValue vracValue = null;
        for (CaracteristicQualitativeValue caracteristicQualitativeValue : caracteristic.getCaracteristic().getQualitativeValue()) {
            if (!vracId.equals(caracteristicQualitativeValue.getIdAsInt())) continue;
            vracValue = caracteristicQualitativeValue;
            break;
        }
        Preconditions.checkNotNull(vracValue, (Object)"Could not found vrac qualitative value");
        this.sortedValue = vracValue;
        CreateSpeciesBatchUIModel model = new CreateSpeciesBatchUIModel(this.sampleCategoryModel);
        ((CreateSpeciesBatchUI)this.ui).setContextValue(model);
        this.listModelIsModify(model);
    }

    public void afterInit(CreateSpeciesBatchUI ui) {
        this.initUI(this.ui);
        this.initBeanFilterableComboBox(((CreateSpeciesBatchUI)this.ui).getSpeciesComboBox(), Lists.newArrayList(), null, "fromProtocol");
        ArrayList categories = Lists.newArrayList();
        categories.addAll(this.sampleCategoryModel.getCategory());
        categories.remove(0);
        this.initBeanFilterableComboBox(((CreateSpeciesBatchUI)this.ui).getCategoryComboBox(), Lists.newArrayList((Iterable)categories), null);
        Caracteristic caracteristic = this.getPersistenceService().getSortedUnsortedCaracteristic();
        this.initBeanFilterableComboBox(((CreateSpeciesBatchUI)this.ui).getSampleCategoryComboBox(), Lists.newArrayList(caracteristic.getQualitativeValue()), null);
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)this.getModel();
        model.addPropertyChangeListener("species", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CreateSpeciesBatchUIModel source = (CreateSpeciesBatchUIModel)evt.getSource();
                Species newValue = (Species)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New Selected species " + (newValue == null ? null : CreateSpeciesBatchUIHandler.this.decorate(newValue))));
                }
                if (newValue == null || source.getSpeciesUsed() == null) {
                    source.setSampleCategory(null);
                } else {
                    CaracteristicQualitativeValue qualitativeValue;
                    List qualitativeValues = ((CreateSpeciesBatchUI)CreateSpeciesBatchUIHandler.this.ui).getSampleCategoryComboBox().getData();
                    CaracteristicQualitativeValue newCategory = null;
                    Iterator i$ = qualitativeValues.iterator();
                    while (!(!i$.hasNext() || source.isSpeciesAndCategoryAvailable(newValue, qualitativeValue = (CaracteristicQualitativeValue)i$.next()) && (newCategory = qualitativeValue).equals(CreateSpeciesBatchUIHandler.this.sortedValue))) {
                    }
                    source.setSampleCategory(newCategory);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove selected category before changing the categories...");
                    }
                    source.setSelectedCategory(null);
                    SampleCategoryModelEntry selectedCategory = CreateSpeciesBatchUIHandler.this.getDataContext().getBestFirstSpeciesSampleCategory(((CreateSpeciesBatchUI)CreateSpeciesBatchUIHandler.this.getUI()).getCategoryComboBox().getData(), newValue);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Selected category : " + selectedCategory));
                    }
                    source.setSelectedCategory(selectedCategory);
                }
            }
        });
        model.addPropertyChangeListener("selectedCategory", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CreateSpeciesBatchUIModel source = (CreateSpeciesBatchUIModel)evt.getSource();
                source.setSampleWeight(null);
                SampleCategoryModelEntry newValue = (SampleCategoryModelEntry)evt.getNewValue();
                CreateSpeciesBatchUIHandler.this.generateTableModel(newValue);
            }
        });
        this.generateTableModel(null);
        this.initTable(this.getTable());
        this.listenValidatorValid((SimpleBeanValidator)((CreateSpeciesBatchUI)this.ui).getValidator(), model);
    }

    protected JComponent getComponentToFocus() {
        return ((CreateSpeciesBatchUI)this.getUI()).getSpeciesComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((CreateSpeciesBatchUI)this.ui).getValidator().setBean(null);
        ((CreateSpeciesBatchUIModel)this.getModel()).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
    }

    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return ((CreateSpeciesBatchUI)this.ui).getValidator();
    }

    public void openUI(SpeciesBatchUIModel batchModel) {
        CreateSpeciesBatchUIModel model = (CreateSpeciesBatchUIModel)this.getModel();
        ((CreateSpeciesBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSpecies(null);
        model.setSampleCategory(null);
        model.setBatchWeight(null);
        model.setBatchCount(null);
        ArrayList speciesToUse = Lists.newArrayList();
        Multimap<CaracteristicQualitativeValue, Species> speciesUsed = model.getSpeciesUsed();
        speciesUsed.clear();
        if (batchModel != null) {
            speciesUsed.putAll(batchModel.getSpeciesUsed());
            List allSpecies = this.getDataContext().getReferentSpeciesWithSurveyCode(true);
            speciesToUse.addAll(allSpecies);
        }
        model.setAvailableSpecies(speciesToUse);
    }

    protected void computeSampleWeight() {
        Float result = null;
        List rows = this.getTableModel().getRows();
        for (SplitSpeciesBatchRowModel row : rows) {
            Float weight;
            if (!row.isSelected() || (weight = row.getWeight()) == null) continue;
            if (result == null) {
                result = Float.valueOf(0.0f);
            }
            result = Float.valueOf(result.floatValue() + weight.floatValue());
        }
        ((CreateSpeciesBatchUIModel)this.getModel()).setSampleWeight(result);
    }

    protected void generateTableModel(SampleCategoryModelEntry category) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate table model for category " + category));
        }
        ((CreateSpeciesBatchUIModel)this.getModel()).setRows(null);
        Caracteristic data = null;
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.SELECTED, (JTable)table);
        boolean editableCategoryValue = false;
        if (category != null) {
            if (!category.getCaracteristic().isQualitativeValueEmpty()) {
                data = category.getCaracteristic();
            } else {
                editableCategoryValue = true;
                this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.EDITABLE_CATEGORY_VALUE, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
            }
            if (data != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got " + data.sizeQualitativeValue() + " qualitative data to add"));
                }
                this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class), SplitSpeciesBatchTableModel.READ_ONLY_CATEGORY_VALUE);
            }
            this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.WEIGHT, this.weightUnit, (JTable)table);
        }
        SplitSpeciesBatchTableModel tableModel = new SplitSpeciesBatchTableModel((TableColumnModelExt)columnModel, (SelectedCategoryAble)this.getModel(), editableCategoryValue, false);
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.uninstallTableKeyListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Install new table model " + (Object)((Object)tableModel)));
        }
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.installTableSaveOnRowChangedSelectionListener();
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        ArrayList rows = Lists.newArrayList();
        if (data != null) {
            for (CaracteristicQualitativeValue qualitativeValue : data.getQualitativeValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add QV: " + qualitativeValue));
                }
                SplitSpeciesBatchRowModel newRow = tableModel.createNewRow();
                newRow.setCategoryValue(qualitativeValue);
                rows.add(newRow);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will add " + rows.size() + " rows in table model " + "(can add a first empty row? " + editableCategoryValue + ")."));
        }
        ((CreateSpeciesBatchUIModel)this.getModel()).setRows(rows);
    }
}

