package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class SpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED = "addSampleCategoryMenu.enabled";
    public static final String BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED = "changeSampleCategoryMenu.enabled";
    public static final String BINDING_CREATE_SPECIES_MELAG_MENU_ENABLED = "createSpeciesMelagMenu.enabled";
    public static final String BINDING_EDIT_FREQUENCIES_MENU_ENABLED = "editFrequenciesMenu.enabled";
    public static final String BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED = "filterSpeciesBatchAllButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED = "filterSpeciesBatchLeafButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED = "filterSpeciesBatchRootButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT = "filterSpeciesBatchRootButton.text";
    public static final String BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED = "removeSpeciesBatchMenu.enabled";
    public static final String BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED = "removeSpeciesSubBatchMenu.enabled";
    public static final String BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED = "renameSpeciesBatchMenu.enabled";
    public static final String BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED = "speciesSortModeAscButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED = "speciesSortModeDescButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED = "speciesSortModeNoneButton.selected";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_BEAN = "speciesTotalInertWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_VALUE = "speciesTotalInertWeightField.numberValue";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "speciesTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_VALUE = "speciesTotalLivingNotItemizedWeightField.numberValue";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_VALUE = "speciesTotalSortedWeightField.numberValue";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";
    public static final String BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED = "splitSpeciesBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem addSampleCategoryMenu;
    protected TuttiHelpBroker broker;
    protected JMenuItem changeSampleCategoryMenu;
    protected JButton createSpeciesBatchButton;
    protected JMenuItem createSpeciesMelagMenu;
    protected JMenuItem editFrequenciesMenu;
    protected SpeciesBatchUI editSpeciesBatchTopPanel = this;
    protected JMenuItem exportMultiPostButton;
    protected JRadioButton filterSpeciesBatchAllButton;
    protected JLabel filterSpeciesBatchLabel;
    protected JRadioButton filterSpeciesBatchLeafButton;
    protected JAXXButtonGroup filterSpeciesBatchMode;
    protected JRadioButton filterSpeciesBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected final SpeciesBatchUIHandler handler = createHandler();
    protected JMenuItem importBigfinButton;
    protected JMenuItem importMultiPostButton;
    protected JMenuItem importPsionButton;
    protected JMenuItem importPupitriButton;
    protected JMenuBar menu;
    protected JMenu menuAction;
    protected SpeciesBatchUIModel model;
    protected JMenuItem removeSpeciesBatchMenu;
    protected JMenuItem removeSpeciesSubBatchMenu;
    protected JMenuItem renameSpeciesBatchMenu;
    protected ButtonAttachment speciesBatchAttachmentsButton;
    protected JToolBar speciesBatchTabToolBar;
    protected JAXXButtonGroup speciesSort;
    protected JLabel speciesSortBatchLabel;
    protected JRadioButton speciesSortModeAscButton;
    protected JRadioButton speciesSortModeDescButton;
    protected JRadioButton speciesSortModeNoneButton;
    protected JPanel speciesSortTablePane;
    protected ComputableDataEditor<Float> speciesTotalInertWeightField;
    protected JLabel speciesTotalInertWeightLabel;
    protected ComputableDataEditor<Float> speciesTotalLivingNotItemizedWeightField;
    protected JLabel speciesTotalLivingNotItemizedWeightLabel;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected ComputableDataEditor<Float> speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JMenuItem splitSpeciesBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__filterSpeciesBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterSpeciesBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterSpeciesBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__speciesSortModeAscButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.ASC);
    }

    public void doActionPerformed__on__speciesSortModeDescButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.DESC);
    }

    public void doActionPerformed__on__speciesSortModeNoneButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAddSampleCategoryMenu() {
        return addSampleCategoryMenu;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JMenuItem getChangeSampleCategoryMenu() {
        return changeSampleCategoryMenu;
    }

    public JButton getCreateSpeciesBatchButton() {
        return createSpeciesBatchButton;
    }

    public JMenuItem getCreateSpeciesMelagMenu() {
        return createSpeciesMelagMenu;
    }

    public JMenuItem getEditFrequenciesMenu() {
        return editFrequenciesMenu;
    }

    public JMenuItem getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public JRadioButton getFilterSpeciesBatchAllButton() {
        return filterSpeciesBatchAllButton;
    }

    public JLabel getFilterSpeciesBatchLabel() {
        return filterSpeciesBatchLabel;
    }

    public JRadioButton getFilterSpeciesBatchLeafButton() {
        return filterSpeciesBatchLeafButton;
    }

    public JAXXButtonGroup getFilterSpeciesBatchMode() {
        return filterSpeciesBatchMode;
    }

    public JRadioButton getFilterSpeciesBatchRootButton() {
        return filterSpeciesBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public JMenuItem getImportBigfinButton() {
        return importBigfinButton;
    }

    public JMenuItem getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JMenuItem getImportPsionButton() {
        return importPsionButton;
    }

    public JMenuItem getImportPupitriButton() {
        return importPupitriButton;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAction() {
        return menuAction;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveSpeciesBatchMenu() {
        return removeSpeciesBatchMenu;
    }

    public JMenuItem getRemoveSpeciesSubBatchMenu() {
        return removeSpeciesSubBatchMenu;
    }

    public JMenuItem getRenameSpeciesBatchMenu() {
        return renameSpeciesBatchMenu;
    }

    public ButtonAttachment getSpeciesBatchAttachmentsButton() {
        return speciesBatchAttachmentsButton;
    }

    public JToolBar getSpeciesBatchTabToolBar() {
        return speciesBatchTabToolBar;
    }

    public JAXXButtonGroup getSpeciesSort() {
        return speciesSort;
    }

    public JLabel getSpeciesSortBatchLabel() {
        return speciesSortBatchLabel;
    }

    public JRadioButton getSpeciesSortModeAscButton() {
        return speciesSortModeAscButton;
    }

    public JRadioButton getSpeciesSortModeDescButton() {
        return speciesSortModeDescButton;
    }

    public JRadioButton getSpeciesSortModeNoneButton() {
        return speciesSortModeNoneButton;
    }

    public JPanel getSpeciesSortTablePane() {
        return speciesSortTablePane;
    }

    public ComputableDataEditor<Float> getSpeciesTotalInertWeightField() {
        return speciesTotalInertWeightField;
    }

    public JLabel getSpeciesTotalInertWeightLabel() {
        return speciesTotalInertWeightLabel;
    }

    public ComputableDataEditor<Float> getSpeciesTotalLivingNotItemizedWeightField() {
        return speciesTotalLivingNotItemizedWeightField;
    }

    public JLabel getSpeciesTotalLivingNotItemizedWeightLabel() {
        return speciesTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public ComputableDataEditor<Float> getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JMenuItem getSplitSpeciesBatchMenu() {
        return splitSpeciesBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(speciesBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterSpeciesBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchAllButton); }
    }

    protected void addChildrenToFilterSpeciesBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchLeafButton); }
    }

    protected void addChildrenToFilterSpeciesBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterSpeciesBatchLabel);
        filterTablePane.add(filterSpeciesBatchAllButton);
        filterTablePane.add(filterSpeciesBatchLeafButton);
        filterTablePane.add(filterSpeciesBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuAction);
    }

    protected void addChildrenToMenuAction() {
        if (!allComponentsCreated) {
            return;
        }
        menuAction.add(importPupitriButton);
        menuAction.add(importPsionButton);
        menuAction.add(importBigfinButton);
        menuAction.add(importMultiPostButton);
        menuAction.add(exportMultiPostButton);
    }

    protected void addChildrenToSpeciesBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        speciesBatchTabToolBar.add(menu);
        speciesBatchTabToolBar.add(speciesBatchAttachmentsButton);
    }

    protected void addChildrenToSpeciesSortModeAscButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeAscButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeAscButton); }
    }

    protected void addChildrenToSpeciesSortModeDescButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeDescButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeDescButton); }
    }

    protected void addChildrenToSpeciesSortModeNoneButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeNoneButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeNoneButton); }
    }

    protected void addChildrenToSpeciesSortTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        speciesSortTablePane.add(speciesSortBatchLabel);
        speciesSortTablePane.add(speciesSortModeNoneButton);
        speciesSortTablePane.add(speciesSortModeAscButton);
        speciesSortTablePane.add(speciesSortModeDescButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitSpeciesBatchMenu);
        tablePopup.add(changeSampleCategoryMenu);
        tablePopup.add(addSampleCategoryMenu);
        tablePopup.add(removeSpeciesBatchMenu);
        tablePopup.add(removeSpeciesSubBatchMenu);
        tablePopup.add(renameSpeciesBatchMenu);
        tablePopup.add(createSpeciesMelagMenu);
        tablePopup.add(editFrequenciesMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add($JPanel1, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSampleCategoryMenu() {
        $objectMap.put("addSampleCategoryMenu", addSampleCategoryMenu = new JMenuItem());
        
        addSampleCategoryMenu.setName("addSampleCategoryMenu");
        addSampleCategoryMenu.setText(t("tutti.editSpeciesBatch.action.addSampleCategory"));
        addSampleCategoryMenu.setToolTipText(t("tutti.editSpeciesBatch.action.addSampleCategory.tip"));
        addSampleCategoryMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.addSampleCategory.help");
        addSampleCategoryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.OpenAddSpeciesBatchSampleCategoryUIAction.class);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSpeciesBatch.help"));
    }

    protected void createChangeSampleCategoryMenu() {
        $objectMap.put("changeSampleCategoryMenu", changeSampleCategoryMenu = new JMenuItem());
        
        changeSampleCategoryMenu.setName("changeSampleCategoryMenu");
        changeSampleCategoryMenu.setText(t("tutti.editSpeciesBatch.action.changeSampleCategory"));
        changeSampleCategoryMenu.setToolTipText(t("tutti.editSpeciesBatch.action.changeSampleCategory.tip"));
        changeSampleCategoryMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.changeSampleCategory.help");
        changeSampleCategoryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ChangeSpeciesBatchSampleCategoryAction.class);
    }

    protected void createCreateSpeciesBatchButton() {
        $objectMap.put("createSpeciesBatchButton", createSpeciesBatchButton = new JButton());
        
        createSpeciesBatchButton.setName("createSpeciesBatchButton");
        createSpeciesBatchButton.setText(t("tutti.editSpeciesBatch.action.createBatch"));
        createSpeciesBatchButton.setToolTipText(t("tutti.editSpeciesBatch.action.createBatch.tip"));
        createSpeciesBatchButton.putClientProperty("help", "tutti.editSpeciesBatch.action.createBatch.help");
        createSpeciesBatchButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.OpenCreateSpeciesBatchUIAction.class);
    }

    protected void createCreateSpeciesMelagMenu() {
        $objectMap.put("createSpeciesMelagMenu", createSpeciesMelagMenu = new JMenuItem());
        
        createSpeciesMelagMenu.setName("createSpeciesMelagMenu");
        createSpeciesMelagMenu.setText(t("tutti.editSpeciesBatch.action.createMelag"));
        createSpeciesMelagMenu.setToolTipText(t("tutti.editSpeciesBatch.action.createMelag.tip"));
        createSpeciesMelagMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.CreateSpeciesMelagAction.class);
        createSpeciesMelagMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.createMelag.help");
    }

    protected void createEditFrequenciesMenu() {
        $objectMap.put("editFrequenciesMenu", editFrequenciesMenu = new JMenuItem());
        
        editFrequenciesMenu.setName("editFrequenciesMenu");
        editFrequenciesMenu.setText(t("tutti.editSpeciesBatch.action.editFrequencies"));
        editFrequenciesMenu.setToolTipText(t("tutti.editSpeciesBatch.action.editFrequencies.tip"));
        editFrequenciesMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.editFrequencies.help");
        editFrequenciesMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.OpenEditSpeciesBatchFrequencyUIAction.class);
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JMenuItem());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editSpeciesBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editSpeciesBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ExportMultiPostSpeciesAction.class);
        exportMultiPostButton.putClientProperty("help", "tutti.editSpeciesBatch.action.exportMultiPost.help");
    }

    protected void createFilterSpeciesBatchAllButton() {
        $objectMap.put("filterSpeciesBatchAllButton", filterSpeciesBatchAllButton = new JRadioButton());
        
        filterSpeciesBatchAllButton.setName("filterSpeciesBatchAllButton");
        filterSpeciesBatchAllButton.setText(t("tutti.editSpeciesBatch.filterBatch.mode.all"));
        { filterSpeciesBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSpeciesBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchAllButton.setToolTipText(t("tutti.editSpeciesBatch.filterBatch.mode.all.tip"));
        filterSpeciesBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchAllButton"));
    }

    protected void createFilterSpeciesBatchLabel() {
        $objectMap.put("filterSpeciesBatchLabel", filterSpeciesBatchLabel = new JLabel());
        
        filterSpeciesBatchLabel.setName("filterSpeciesBatchLabel");
        filterSpeciesBatchLabel.setText(t("tutti.editSpeciesBatch.filterBatch"));
        filterSpeciesBatchLabel.setToolTipText(t("tutti.editSpeciesBatch.filterSpeciesBatch.tip"));
        filterSpeciesBatchLabel.putClientProperty("help", "tutti.editSpeciesBatch.filterSpeciesBatch.help");
        filterSpeciesBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSpeciesBatchLeafButton() {
        $objectMap.put("filterSpeciesBatchLeafButton", filterSpeciesBatchLeafButton = new JRadioButton());
        
        filterSpeciesBatchLeafButton.setName("filterSpeciesBatchLeafButton");
        filterSpeciesBatchLeafButton.setText(t("tutti.editSpeciesBatch.filterBatch.mode.leaf"));
        { filterSpeciesBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterSpeciesBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchLeafButton.setToolTipText(t("tutti.editSpeciesBatch.filterBatch.mode.leaf.tip"));
        filterSpeciesBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchLeafButton"));
    }

    protected void createFilterSpeciesBatchMode() {
        $objectMap.put("filterSpeciesBatchMode", filterSpeciesBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterSpeciesBatchRootButton() {
        $objectMap.put("filterSpeciesBatchRootButton", filterSpeciesBatchRootButton = new JRadioButton());
        
        filterSpeciesBatchRootButton.setName("filterSpeciesBatchRootButton");
        { filterSpeciesBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterSpeciesBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchRootButton.setToolTipText(t("tutti.editSpeciesBatch.filterBatch.mode.root.tip"));
        filterSpeciesBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected SpeciesBatchUIHandler createHandler() {
        return new SpeciesBatchUIHandler();
    }

    protected void createImportBigfinButton() {
        $objectMap.put("importBigfinButton", importBigfinButton = new JMenuItem());
        
        importBigfinButton.setName("importBigfinButton");
        importBigfinButton.setText(t("tutti.editSpeciesBatch.action.importBigfin"));
        importBigfinButton.setToolTipText(t("tutti.editSpeciesBatch.action.importBigfin.tip"));
        importBigfinButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportBigfinAction.class);
        importBigfinButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importBigfin.help");
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JMenuItem());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editSpeciesBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editSpeciesBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportMultiPostSpeciesAction.class);
        importMultiPostButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importMultiPost.help");
    }

    protected void createImportPsionButton() {
        $objectMap.put("importPsionButton", importPsionButton = new JMenuItem());
        
        importPsionButton.setName("importPsionButton");
        importPsionButton.setText(t("tutti.editSpeciesBatch.action.importPsion"));
        importPsionButton.setToolTipText(t("tutti.editSpeciesBatch.action.importPsion.tip"));
        importPsionButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportPsionAction.class);
        importPsionButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importPsion.help");
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JMenuItem());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(t("tutti.editSpeciesBatch.action.importPupitri"));
        importPupitriButton.setToolTipText(t("tutti.editSpeciesBatch.action.importPupitri.tip"));
        importPupitriButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportPupitriAction.class);
        importPupitriButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importPupitri.help");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuAction() {
        $objectMap.put("menuAction", menuAction = new JMenu());
        
        menuAction.setName("menuAction");
        menuAction.setText(t("tutti.toolbar.menu.action"));
        menuAction.setOpaque(true);
        menuAction.setToolTipText(t("tutti.toolbar.menu.action.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createRemoveSpeciesBatchMenu() {
        $objectMap.put("removeSpeciesBatchMenu", removeSpeciesBatchMenu = new JMenuItem());
        
        removeSpeciesBatchMenu.setName("removeSpeciesBatchMenu");
        removeSpeciesBatchMenu.setText(t("tutti.editSpeciesBatch.action.removeBatch"));
        removeSpeciesBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.removeBatch.tip"));
        removeSpeciesBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.RemoveSpeciesBatchAction.class);
        removeSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.removeBatch.help");
    }

    protected void createRemoveSpeciesSubBatchMenu() {
        $objectMap.put("removeSpeciesSubBatchMenu", removeSpeciesSubBatchMenu = new JMenuItem());
        
        removeSpeciesSubBatchMenu.setName("removeSpeciesSubBatchMenu");
        removeSpeciesSubBatchMenu.setText(t("tutti.editSpeciesBatch.action.removeSubBatch"));
        removeSpeciesSubBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.removeSubBatch.tip"));
        removeSpeciesSubBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.RemoveSpeciesSubBatchAction.class);
        removeSpeciesSubBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.removeSubBatch.help");
    }

    protected void createRenameSpeciesBatchMenu() {
        $objectMap.put("renameSpeciesBatchMenu", renameSpeciesBatchMenu = new JMenuItem());
        
        renameSpeciesBatchMenu.setName("renameSpeciesBatchMenu");
        renameSpeciesBatchMenu.setText(t("tutti.editSpeciesBatch.action.renameBatch"));
        renameSpeciesBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.renameBatch.tip"));
        renameSpeciesBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.RenameSpeciesBatchAction.class);
        renameSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.renameBatch.help");
    }

    protected void createSpeciesBatchAttachmentsButton() {
        $objectMap.put("speciesBatchAttachmentsButton", speciesBatchAttachmentsButton = new ButtonAttachment(handler.getContext(), getContextValue(EditCatchesUIModel.class)));
        
        speciesBatchAttachmentsButton.setName("speciesBatchAttachmentsButton");
        speciesBatchAttachmentsButton.setFocusPainted(false);
        speciesBatchAttachmentsButton.setToolTipText(t("tutti.editSpeciesBatch.action.attachments.tip"));
    }

    protected void createSpeciesBatchTabToolBar() {
        $objectMap.put("speciesBatchTabToolBar", speciesBatchTabToolBar = new JToolBar());
        
        speciesBatchTabToolBar.setName("speciesBatchTabToolBar");
        speciesBatchTabToolBar.setFloatable(false);
        speciesBatchTabToolBar.setOpaque(true);
        speciesBatchTabToolBar.setBorderPainted(false);
    }

    protected void createSpeciesSort() {
        $objectMap.put("speciesSort", speciesSort = new JAXXButtonGroup());
    }

    protected void createSpeciesSortBatchLabel() {
        $objectMap.put("speciesSortBatchLabel", speciesSortBatchLabel = new JLabel());
        
        speciesSortBatchLabel.setName("speciesSortBatchLabel");
        speciesSortBatchLabel.setText(t("tutti.editSpeciesBatch.sortSpeciesBatch"));
        speciesSortBatchLabel.setToolTipText(t("tutti.editSpeciesBatch.sortSpeciesBatch.tip"));
        speciesSortBatchLabel.putClientProperty("help", "tutti.editSpeciesBatch.sortSpeciesBatch.help");
        speciesSortBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createSpeciesSortModeAscButton() {
        $objectMap.put("speciesSortModeAscButton", speciesSortModeAscButton = new JRadioButton());
        
        speciesSortModeAscButton.setName("speciesSortModeAscButton");
        speciesSortModeAscButton.setText(t("tutti.editSpeciesBatch.speciesSortMode.asc"));
        { speciesSortModeAscButton.putClientProperty("$value", "ASC");  Object $buttonGroup = speciesSortModeAscButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeAscButton.setToolTipText(t("tutti.editSpeciesBatch.speciesSortMode.asc.tip"));
        speciesSortModeAscButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeAscButton"));
        speciesSortModeAscButton.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesSortMode.asc.help");
    }

    protected void createSpeciesSortModeDescButton() {
        $objectMap.put("speciesSortModeDescButton", speciesSortModeDescButton = new JRadioButton());
        
        speciesSortModeDescButton.setName("speciesSortModeDescButton");
        speciesSortModeDescButton.setText(t("tutti.editSpeciesBatch.speciesSortMode.desc"));
        { speciesSortModeDescButton.putClientProperty("$value", "DESC");  Object $buttonGroup = speciesSortModeDescButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeDescButton.setToolTipText(t("tutti.editSpeciesBatch.speciesSortMode.desc.tip"));
        speciesSortModeDescButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeDescButton"));
        speciesSortModeDescButton.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesSortMode.desc.help");
    }

    protected void createSpeciesSortModeNoneButton() {
        $objectMap.put("speciesSortModeNoneButton", speciesSortModeNoneButton = new JRadioButton());
        
        speciesSortModeNoneButton.setName("speciesSortModeNoneButton");
        speciesSortModeNoneButton.setText(t("tutti.editSpeciesBatch.speciesSortMode.none"));
        { speciesSortModeNoneButton.putClientProperty("$value", "NONE");  Object $buttonGroup = speciesSortModeNoneButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeNoneButton.setToolTipText(t("tutti.editSpeciesBatch.speciesSortMode.none.tip"));
        speciesSortModeNoneButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeNoneButton"));
        speciesSortModeNoneButton.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesSortMode.none.help");
    }

    protected void createSpeciesSortTablePane() {
        $objectMap.put("speciesSortTablePane", speciesSortTablePane = new JPanel());
        
        speciesSortTablePane.setName("speciesSortTablePane");
    }

    protected void createSpeciesTotalInertWeightField() {
        $objectMap.put("speciesTotalInertWeightField", speciesTotalInertWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalInertWeightField.setName("speciesTotalInertWeightField");
        speciesTotalInertWeightField.setShowReset(true);
        speciesTotalInertWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        speciesTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalInertWeightLabel() {
        $objectMap.put("speciesTotalInertWeightLabel", speciesTotalInertWeightLabel = new JLabel());
        
        speciesTotalInertWeightLabel.setName("speciesTotalInertWeightLabel");
        speciesTotalInertWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalInertWeight"));
        speciesTotalInertWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalInertWeight.tip"));
        speciesTotalInertWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        speciesTotalInertWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalLivingNotItemizedWeightField() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightField", speciesTotalLivingNotItemizedWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalLivingNotItemizedWeightField.setName("speciesTotalLivingNotItemizedWeightField");
        speciesTotalLivingNotItemizedWeightField.setShowReset(true);
        speciesTotalLivingNotItemizedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        speciesTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightLabel", speciesTotalLivingNotItemizedWeightLabel = new JLabel());
        
        speciesTotalLivingNotItemizedWeightLabel.setName("speciesTotalLivingNotItemizedWeightLabel");
        speciesTotalLivingNotItemizedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight"));
        speciesTotalLivingNotItemizedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.tip"));
        speciesTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        speciesTotalLivingNotItemizedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.tip"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setShowReset(true);
        speciesTotalSortedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        speciesTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalSortedWeight"));
        speciesTotalSortedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalSortedWeight.tip"));
        speciesTotalSortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        speciesTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight"));
        speciesTotalUnsortedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.tip"));
        speciesTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalWeight"));
        speciesTotalWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalWeight.tip"));
        speciesTotalWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        speciesTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSplitSpeciesBatchMenu() {
        $objectMap.put("splitSpeciesBatchMenu", splitSpeciesBatchMenu = new JMenuItem());
        
        splitSpeciesBatchMenu.setName("splitSpeciesBatchMenu");
        splitSpeciesBatchMenu.setText(t("tutti.editSpeciesBatch.action.splitBatch"));
        splitSpeciesBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.splitBatch.tip"));
        splitSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.splitBatch.help");
        splitSpeciesBatchMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.OpenSplitSpeciesBatchUIAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editSpeciesBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToSpeciesBatchTabToolBar();
        addChildrenToMenu();
        addChildrenToMenuAction();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createSpeciesBatchButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(filterTablePane);
        $JPanel1.add(speciesSortTablePane);
        addChildrenToFilterTablePane();
        addChildrenToFilterSpeciesBatchAllButton();
        addChildrenToFilterSpeciesBatchLeafButton();
        addChildrenToFilterSpeciesBatchRootButton();
        addChildrenToSpeciesSortTablePane();
        addChildrenToSpeciesSortModeNoneButton();
        addChildrenToSpeciesSortModeAscButton();
        addChildrenToSpeciesSortModeDescButton();
        addChildrenToTableScrollPane();
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 59 property setters
        menu.setBackground(javax.swing.UIManager.getColor("MenuBar.background"));
        menu.setBorder(null);
        menuAction.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.toolbar.menu.action.mnemonic"),'Z'));
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        importPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importPupitri.mnemonic"),'Z'));
        importPsionButton.setIcon(SwingUtil.createActionIcon("psion-import"));
        importPsionButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importPsion.mnemonic"),'Z'));
        importBigfinButton.setIcon(SwingUtil.createActionIcon("bigfin-import"));
        importBigfinButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importBigfin.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.exportMultiPost.mnemonic"),'Z'));
        splitSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        splitSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.splitBatch.mnemonic"),'Z'));
        changeSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        changeSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.changeSampleCategory.mnemonic"),'Z'));
        addSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        addSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.addSampleCategory.mnemonic"),'Z'));
        removeSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.removeBatch.mnemonic"),'Z'));
        removeSpeciesSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.removeSubBatch.mnemonic"),'Z'));
        renameSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        renameSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.renameBatch.mnemonic"),'Z'));
        createSpeciesMelagMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        createSpeciesMelagMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.createMelag.mnemonic"),'Z'));
        editFrequenciesMenu.setIcon(SwingUtil.createActionIcon("show-frequency"));
        editFrequenciesMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.editFrequencies.mnemonic"),'Z'));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSortedWeightField.setNumberType(Float.class);
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalInertWeightLabel.setLabelFor(speciesTotalInertWeightField);
        speciesTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalInertWeightField.setNumberType(Float.class);
        speciesTotalLivingNotItemizedWeightLabel.setLabelFor(speciesTotalLivingNotItemizedWeightField);
        speciesTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalLivingNotItemizedWeightField.setNumberType(Float.class);
        createSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.createBatch.mnemonic"),'Z'));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterSpeciesBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        speciesSortTablePane.setBorder(new TitledBorder(null, ""));
        speciesSortBatchLabel.setIcon(SwingUtil.createActionIcon("sort"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesBatchTopPanel, "tutti.editSpeciesBatch.help");
        registerHelpId(_broker, importPupitriButton, "tutti.editSpeciesBatch.action.importPupitri.help");
        registerHelpId(_broker, importPsionButton, "tutti.editSpeciesBatch.action.importPsion.help");
        registerHelpId(_broker, importBigfinButton, "tutti.editSpeciesBatch.action.importBigfin.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editSpeciesBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editSpeciesBatch.action.exportMultiPost.help");
        registerHelpId(_broker, splitSpeciesBatchMenu, "tutti.editSpeciesBatch.action.splitBatch.help");
        registerHelpId(_broker, changeSampleCategoryMenu, "tutti.editSpeciesBatch.action.changeSampleCategory.help");
        registerHelpId(_broker, addSampleCategoryMenu, "tutti.editSpeciesBatch.action.addSampleCategory.help");
        registerHelpId(_broker, removeSpeciesBatchMenu, "tutti.editSpeciesBatch.action.removeBatch.help");
        registerHelpId(_broker, removeSpeciesSubBatchMenu, "tutti.editSpeciesBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameSpeciesBatchMenu, "tutti.editSpeciesBatch.action.renameBatch.help");
        registerHelpId(_broker, createSpeciesMelagMenu, "tutti.editSpeciesBatch.action.createMelag.help");
        registerHelpId(_broker, editFrequenciesMenu, "tutti.editSpeciesBatch.action.editFrequencies.help");
        registerHelpId(_broker, speciesTotalWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalWeightField, "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightField, "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightField, "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightField, "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, speciesTotalInertWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        registerHelpId(_broker, speciesTotalInertWeightField, "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        registerHelpId(_broker, speciesTotalLivingNotItemizedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, speciesTotalLivingNotItemizedWeightField, "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createSpeciesBatchButton, "tutti.editSpeciesBatch.action.createBatch.help");
        registerHelpId(_broker, filterSpeciesBatchLabel, "tutti.editSpeciesBatch.filterSpeciesBatch.help");
        registerHelpId(_broker, speciesSortBatchLabel, "tutti.editSpeciesBatch.sortSpeciesBatch.help");
        registerHelpId(_broker, speciesSortModeNoneButton, "tutti.editSpeciesBatch.field.speciesSortMode.none.help");
        registerHelpId(_broker, speciesSortModeAscButton, "tutti.editSpeciesBatch.field.speciesSortMode.asc.help");
        registerHelpId(_broker, speciesSortModeDescButton, "tutti.editSpeciesBatch.field.speciesSortMode.desc.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editSpeciesBatchTopPanel", editSpeciesBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createSpeciesBatchTabToolBar();
        createMenu();
        createMenuAction();
        createImportPupitriButton();
        createImportPsionButton();
        createImportBigfinButton();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createSpeciesBatchAttachmentsButton();
        createTablePopup();
        createSplitSpeciesBatchMenu();
        createChangeSampleCategoryMenu();
        createAddSampleCategoryMenu();
        createRemoveSpeciesBatchMenu();
        createRemoveSpeciesSubBatchMenu();
        createRenameSpeciesBatchMenu();
        createCreateSpeciesMelagMenu();
        createEditFrequenciesMenu();
        createForm();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createSpeciesTotalInertWeightLabel();
        createSpeciesTotalInertWeightField();
        createSpeciesTotalLivingNotItemizedWeightLabel();
        createSpeciesTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateSpeciesBatchButton();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout());
        createFilterTablePane();
        createFilterSpeciesBatchLabel();
        createFilterSpeciesBatchAllButton();
        createFilterSpeciesBatchLeafButton();
        createFilterSpeciesBatchRootButton();
        createSpeciesSortTablePane();
        createSpeciesSortBatchLabel();
        createSpeciesSortModeNoneButton();
        createSpeciesSortModeAscButton();
        createSpeciesSortModeDescButton();
        createTableScrollPane();
        createTable();
        createFilterSpeciesBatchMode();
        createSpeciesSort();
        // inline creation of editSpeciesBatchTopPanel
        setName("editSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        editSpeciesBatchTopPanel.putClientProperty("help", "tutti.editSpeciesBatch.help");
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    changeSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isChangeSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isAddSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_MELAG_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesMelagMenu.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_FREQUENCIES_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editFrequenciesMenu.setEnabled(model.isTableViewModeAll() && model.isEditFrequenciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, handler.getWeightStringValue(speciesTotalWeightLabel, model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setNumberValue(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, handler.getWeightStringValue(speciesTotalSampleSortedWeightLabel, model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, handler.getWeightStringValue(speciesTotalUnsortedWeightLabel, model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setBean(model.getSpeciesTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setNumberValue(model.getSpeciesTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setBean(model.getSpeciesTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setNumberValue(model.getSpeciesTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setText(t(handler.getFilterSpeciesBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeNone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeNoneButton.setSelected(model.isSpeciesSortModeNone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeNone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeAscButton.setSelected(model.isSpeciesSortModeAsc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeDescButton.setSelected(model.isSpeciesSortModeDesc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        });
    }

}