package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JTables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

/**
 * Created on 3/7/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.15
 */
public class OpenEditBenthosBatchFrequencyUIAction extends SimpleActionSupport<BenthosBatchUI> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(OpenEditBenthosBatchFrequencyUIAction.class);

    private static final long serialVersionUID = -6540241422935319461L;

    public OpenEditBenthosBatchFrequencyUIAction(BenthosBatchUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(BenthosBatchUI ui) {

        JXTable table = ui.getTable();

        int rowIndex = SwingUtil.getSelectedModelRow(table);

        TableColumnModelExt columnModel = (TableColumnModelExt) table.getColumnModel();

        int columnIndex = columnModel.getColumnIndex(BenthosBatchTableModel.COMPUTED_NUMBER);

        JTables.doSelectCell(table, rowIndex, columnIndex);

        BenthosFrequencyCellComponent.FrequencyCellEditor cellEditor =
                (BenthosFrequencyCellComponent.FrequencyCellEditor)
                        columnModel.getColumnExt(columnIndex).getCellEditor();
        cellEditor.startEdit();


    }
}
