/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
extends ExceptionHandler {
    private IResultSet m_resultSet;
    private IResultClass m_resultClass;
    private static String sm_className = ResultSet.class.getName();

    ResultSet(IResultSet resultSet, IResultClass resultClass) {
        super(sm_className);
        if (ResultSet.getLogger().isLoggingEnterExitLevel()) {
            ResultSet.getLogger().entering(sm_className, "ResultSet", new Object[]{resultSet, resultClass});
        }
        assert (resultSet != null && resultClass != null);
        this.m_resultSet = resultSet;
        this.m_resultClass = resultClass;
        ResultSet.getLogger().exiting(sm_className, "ResultSet", this);
    }

    public IResultClass getMetaData() throws DataException {
        return this.m_resultClass;
    }

    IResultSet getRuntimeResultSet() {
        return this.m_resultSet;
    }

    IResultSetMetaData getRuntimeMetaData() throws DataException {
        try {
            return this.m_resultSet.getMetaData();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetResultSetMetaData", "getRuntimeMetaData");
        }
        catch (UnsupportedOperationException ex) {
            ResultSet.getLogger().logp(Level.WARNING, sm_className, "getRuntimeMetaData", "Cannot get runtime metadata.", ex);
        }
        return null;
    }

    public void setMaxRows(int max) throws DataException {
        try {
            this.m_resultSet.setMaxRows(max);
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotSetMaxRows", "setMaxRows");
        }
        catch (UnsupportedOperationException ex) {
            ResultSet.getLogger().logp(Level.WARNING, sm_className, "setMaxRows", "Cannot set max rows.", ex);
        }
    }

    public IResultObject fetch() throws DataException {
        if (this.m_resultSet == null) {
            return null;
        }
        try {
            if (!this.m_resultSet.next()) {
                return null;
            }
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotFetchNextRow", "fetch");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotFetchNextRow", "fetch");
        }
        int columnCount = this.m_resultClass.getFieldCount();
        int[] driverPositions = ((ResultClass)this.m_resultClass).getFieldDriverPositions();
        assert (columnCount == driverPositions.length);
        Object[] fields = new Object[columnCount];
        int i = 1;
        while (i <= columnCount) {
            if (!this.m_resultClass.isCustomField(i)) {
                Class dataType = this.m_resultClass.getFieldValueClass(i);
                int driverPosition = driverPositions[i - 1];
                Object colValue = null;
                if (dataType == Integer.class) {
                    int j = this.getInt(driverPosition);
                    if (!this.wasNull()) {
                        colValue = j;
                    }
                } else if (dataType == Double.class) {
                    double d = this.getDouble(driverPosition);
                    if (!this.wasNull()) {
                        colValue = new Double(d);
                    }
                } else if (dataType == String.class) {
                    colValue = this.getString(driverPosition);
                } else if (dataType == BigDecimal.class) {
                    colValue = this.getBigDecimal(driverPosition);
                } else if (dataType == Date.class) {
                    colValue = this.getDate(driverPosition);
                } else if (dataType == Time.class) {
                    colValue = this.getTime(driverPosition);
                } else if (dataType == java.util.Date.class) {
                    colValue = this.getTimestamp(driverPosition);
                } else if (dataType == Timestamp.class) {
                    colValue = this.getTimestamp(driverPosition);
                } else if (dataType == IBlob.class) {
                    colValue = this.getBlob(driverPosition);
                } else if (dataType == IClob.class) {
                    colValue = this.getClob(driverPosition);
                } else if (dataType == Boolean.class) {
                    boolean val = this.getBoolean(driverPosition);
                    if (!this.wasNull()) {
                        colValue = val;
                    }
                } else if (dataType == Object.class) {
                    colValue = this.getObject(driverPosition);
                } else assert (false);
                if (this.wasNull()) {
                    colValue = null;
                }
                fields[i - 1] = colValue;
            }
            ++i;
        }
        ResultObject ret = new ResultObject(this.m_resultClass, fields);
        ResultSet.getLogger().logp(Level.FINEST, sm_className, "fetch", "Fetched next row: {0} .", ret);
        return ret;
    }

    private int getInt(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getInt(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetIntFromColumn", driverPosition, "getInt");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetIntFromColumn", driverPosition, "getInt");
        }
        return 0;
    }

    private double getDouble(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getDouble(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDoubleFromColumn", driverPosition, "getDouble");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDoubleFromColumn", driverPosition, "getDouble");
        }
        return 0.0;
    }

    private String getString(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getString(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetStringFromColumn", driverPosition, "getString");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetStringFromColumn", driverPosition, "getString");
        }
        return null;
    }

    private BigDecimal getBigDecimal(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getBigDecimal(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromColumn", driverPosition, "getBigDecimal");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromColumn", driverPosition, "getBigDecimal");
        }
        return null;
    }

    private java.util.Date getDate(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getDate(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDateFromColumn", driverPosition, "getDate");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDateFromColumn", driverPosition, "getDate");
        }
        return null;
    }

    private Time getTime(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getTime(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimeFromColumn", driverPosition, "getTime");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimeFromColumn", driverPosition, "getTime");
        }
        return null;
    }

    private Timestamp getTimestamp(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getTimestamp(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimestampFromColumn", driverPosition, "getTimestamp");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimestampFromColumn", driverPosition, "getTimestamp");
        }
        return null;
    }

    private IBlob getBlob(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getBlob(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBlobFromColumn", driverPosition, "getBlob");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBlobFromColumn", driverPosition, "getBlob");
        }
        return null;
    }

    private IClob getClob(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getClob(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetClobFromColumn", driverPosition, "getClob");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetClobFromColumn", driverPosition, "getClob");
        }
        return null;
    }

    private boolean getBoolean(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getBoolean(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBooleanFromColumn", driverPosition, "getBoolean");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBooleanFromColumn", driverPosition, "getBoolean");
        }
        return false;
    }

    private Object getObject(int driverPosition) throws DataException {
        try {
            return this.m_resultSet.getObject(driverPosition);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetObjectFromColumn", driverPosition, "getObject");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetObjectFromColumn", driverPosition, "getObject");
        }
        return null;
    }

    private boolean wasNull() throws DataException {
        try {
            return this.m_resultSet.wasNull();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineWasNull", "wasNull");
        }
        catch (UnsupportedOperationException ex) {
            ResultSet.getLogger().logp(Level.WARNING, sm_className, "wasNull", "Cannot check wasNull. Default to false.", ex);
        }
        return false;
    }

    public int getRowPosition() throws DataException {
        try {
            return this.m_resultSet.getRow();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetRowPosition", "getRowPosition");
        }
        catch (UnsupportedOperationException ex) {
            ResultSet.getLogger().logp(Level.WARNING, sm_className, "getRowPosition", "Cannot get row position.  Default to 0.", ex);
        }
        return 0;
    }

    public void close() throws DataException {
        ResultSet.getLogger().entering(sm_className, "close");
        try {
            this.m_resultSet.close();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotCloseResultSet", "close");
        }
        catch (UnsupportedOperationException ex) {
            ResultSet.getLogger().logp(Level.WARNING, sm_className, "close", "Cannot close result set.", ex);
        }
        ResultSet.getLogger().exiting(sm_className, "close");
    }
}

