/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.ModelFactory;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChartWithoutAxesImpl
extends ChartImpl
implements ChartWithoutAxes {
    protected EList<SeriesDefinition> seriesDefinitions;
    protected static final double MIN_SLICE_EDEFAULT = 0.0;
    protected double minSlice = 0.0;
    protected boolean minSliceESet;
    protected static final boolean MIN_SLICE_PERCENT_EDEFAULT = false;
    protected boolean minSlicePercent = false;
    protected boolean minSlicePercentESet;
    protected static final String MIN_SLICE_LABEL_EDEFAULT = null;
    protected String minSliceLabel = MIN_SLICE_LABEL_EDEFAULT;
    protected static final double COVERAGE_EDEFAULT = 0.0;
    protected double coverage = 0.0;
    protected boolean coverageESet;

    protected ChartWithoutAxesImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.CHART_WITHOUT_AXES;
    }

    @Override
    public EList<SeriesDefinition> getSeriesDefinitions() {
        if (this.seriesDefinitions == null) {
            this.seriesDefinitions = new EObjectContainmentEList(SeriesDefinition.class, (InternalEObject)this, 15);
        }
        return this.seriesDefinitions;
    }

    @Override
    public double getMinSlice() {
        return this.minSlice;
    }

    @Override
    public void setMinSlice(double newMinSlice) {
        double oldMinSlice = this.minSlice;
        this.minSlice = newMinSlice;
        boolean oldMinSliceESet = this.minSliceESet;
        this.minSliceESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldMinSlice, this.minSlice, !oldMinSliceESet));
        }
    }

    @Override
    public void unsetMinSlice() {
        double oldMinSlice = this.minSlice;
        boolean oldMinSliceESet = this.minSliceESet;
        this.minSlice = 0.0;
        this.minSliceESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 16, oldMinSlice, 0.0, oldMinSliceESet));
        }
    }

    @Override
    public boolean isSetMinSlice() {
        return this.minSliceESet;
    }

    @Override
    public boolean isMinSlicePercent() {
        return this.minSlicePercent;
    }

    @Override
    public void setMinSlicePercent(boolean newMinSlicePercent) {
        boolean oldMinSlicePercent = this.minSlicePercent;
        this.minSlicePercent = newMinSlicePercent;
        boolean oldMinSlicePercentESet = this.minSlicePercentESet;
        this.minSlicePercentESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldMinSlicePercent, this.minSlicePercent, !oldMinSlicePercentESet));
        }
    }

    @Override
    public void unsetMinSlicePercent() {
        boolean oldMinSlicePercent = this.minSlicePercent;
        boolean oldMinSlicePercentESet = this.minSlicePercentESet;
        this.minSlicePercent = false;
        this.minSlicePercentESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 17, oldMinSlicePercent, false, oldMinSlicePercentESet));
        }
    }

    @Override
    public boolean isSetMinSlicePercent() {
        return this.minSlicePercentESet;
    }

    @Override
    public String getMinSliceLabel() {
        return this.minSliceLabel;
    }

    @Override
    public void setMinSliceLabel(String newMinSliceLabel) {
        String oldMinSliceLabel = this.minSliceLabel;
        this.minSliceLabel = newMinSliceLabel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldMinSliceLabel, (Object)this.minSliceLabel));
        }
    }

    @Override
    public double getCoverage() {
        return this.coverage;
    }

    @Override
    public void setCoverage(double newCoverage) {
        double oldCoverage = this.coverage;
        this.coverage = newCoverage;
        boolean oldCoverageESet = this.coverageESet;
        this.coverageESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, oldCoverage, this.coverage, !oldCoverageESet));
        }
    }

    @Override
    public void unsetCoverage() {
        double oldCoverage = this.coverage;
        boolean oldCoverageESet = this.coverageESet;
        this.coverage = 0.0;
        this.coverageESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 19, oldCoverage, 0.0, oldCoverageESet));
        }
    }

    @Override
    public boolean isSetCoverage() {
        return this.coverageESet;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                return ((InternalEList)this.getSeriesDefinitions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 15: {
                return this.getSeriesDefinitions();
            }
            case 16: {
                return this.getMinSlice();
            }
            case 17: {
                return this.isMinSlicePercent();
            }
            case 18: {
                return this.getMinSliceLabel();
            }
            case 19: {
                return this.getCoverage();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 15: {
                this.getSeriesDefinitions().clear();
                this.getSeriesDefinitions().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setMinSlice((Double)newValue);
                return;
            }
            case 17: {
                this.setMinSlicePercent((Boolean)newValue);
                return;
            }
            case 18: {
                this.setMinSliceLabel((String)newValue);
                return;
            }
            case 19: {
                this.setCoverage((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 15: {
                this.getSeriesDefinitions().clear();
                return;
            }
            case 16: {
                this.unsetMinSlice();
                return;
            }
            case 17: {
                this.unsetMinSlicePercent();
                return;
            }
            case 18: {
                this.setMinSliceLabel(MIN_SLICE_LABEL_EDEFAULT);
                return;
            }
            case 19: {
                this.unsetCoverage();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 15: {
                return this.seriesDefinitions != null && !this.seriesDefinitions.isEmpty();
            }
            case 16: {
                return this.isSetMinSlice();
            }
            case 17: {
                return this.isSetMinSlicePercent();
            }
            case 18: {
                return MIN_SLICE_LABEL_EDEFAULT == null ? this.minSliceLabel != null : !MIN_SLICE_LABEL_EDEFAULT.equals(this.minSliceLabel);
            }
            case 19: {
                return this.isSetCoverage();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (minSlice: ");
        if (this.minSliceESet) {
            result.append(this.minSlice);
        } else {
            result.append("<unset>");
        }
        result.append(", minSlicePercent: ");
        if (this.minSlicePercentESet) {
            result.append(this.minSlicePercent);
        } else {
            result.append("<unset>");
        }
        result.append(", minSliceLabel: ");
        result.append(this.minSliceLabel);
        result.append(", coverage: ");
        if (this.coverageESet) {
            result.append(this.coverage);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public static ChartWithoutAxes create() {
        ChartWithoutAxes cwoa = ModelFactory.eINSTANCE.createChartWithoutAxes();
        ((ChartWithoutAxesImpl)cwoa).initialize();
        return cwoa;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setGridColumnCount(0);
        this.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
    }

    public static ChartWithoutAxes createDefault() {
        ChartWithoutAxes cwoa = ModelFactory.eINSTANCE.createChartWithoutAxes();
        ((ChartWithoutAxesImpl)cwoa).initDefault();
        return cwoa;
    }

    @Override
    protected void initDefault() {
        super.initDefault();
        this.gridColumnCount = 0;
        try {
            ChartElementUtil.setDefaultValue(this.getLegend(), "itemType", (Object)LegendItemType.CATEGORIES_LITERAL);
        }
        catch (ChartException chartException) {}
    }

    @Override
    public final Series[] getRunTimeSeries() {
        ArrayList<Series> al = new ArrayList<Series>(8);
        EList<SeriesDefinition> el = this.getSeriesDefinitions();
        this.recursivelyGetSeries(el, al, 0, -1);
        return al.toArray(new Series[al.size()]);
    }

    public final void recursivelyGetSeries(EList<SeriesDefinition> elSDs, ArrayList<Series> al, int iLevel, int iLevelToOmit) {
        int i = 0;
        while (i < elSDs.size()) {
            SeriesDefinition sd = (SeriesDefinition)elSDs.get(i);
            if (iLevel != iLevelToOmit) {
                al.addAll(sd.getRunTimeSeries());
            }
            this.recursivelyGetSeries(sd.getSeriesDefinitions(), al, iLevel + 1, iLevelToOmit);
            ++i;
        }
    }

    private static final void recursivelyRemoveRuntimeSeries(EList<SeriesDefinition> elSDs, int iLevel, int iLevelToOmit) {
        int i = 0;
        while (i < elSDs.size()) {
            SeriesDefinition sd = (SeriesDefinition)elSDs.get(i);
            if (iLevel != iLevelToOmit) {
                if (sd.getSeries().size() == sd.getRunTimeSeries().size()) {
                    for (Series se : sd.getRunTimeSeries()) {
                        se.getDataSets().clear();
                    }
                } else {
                    sd.getSeries().removeAll(sd.getRunTimeSeries());
                }
            }
            ChartWithoutAxesImpl.recursivelyRemoveRuntimeSeries(sd.getSeriesDefinitions(), iLevel + 1, iLevelToOmit);
            ++i;
        }
    }

    @Override
    public final void clearSections(int iSectionType) {
        if ((iSectionType & 3) == 3) {
            ChartWithoutAxesImpl.recursivelyRemoveRuntimeSeries(this.getSeriesDefinitions(), 0, -1);
        }
    }

    @Override
    public ChartWithoutAxes copyInstance() {
        ChartWithoutAxesImpl dest = new ChartWithoutAxesImpl();
        dest.set(this);
        return dest;
    }

    protected void set(ChartWithoutAxes src) {
        super.set(src);
        if (src.getSeriesDefinitions() != null) {
            EList<SeriesDefinition> list = this.getSeriesDefinitions();
            for (SeriesDefinition element : src.getSeriesDefinitions()) {
                list.add((Object)element.copyInstance());
            }
        }
        this.minSlice = src.getMinSlice();
        this.minSliceESet = src.isSetMinSlice();
        this.minSlicePercent = src.isMinSlicePercent();
        this.minSlicePercentESet = src.isSetMinSlicePercent();
        this.minSliceLabel = src.getMinSliceLabel();
        this.coverage = src.getCoverage();
        this.coverageESet = src.isSetCoverage();
    }

    @Override
    public void setDimension(ChartDimension newDimension) {
        if (this.isValidDimensionNType(this.type, newDimension)) {
            super.setDimension(newDimension);
        }
    }

    @Override
    public void setType(String newType) {
        if (this.isValidDimensionNType(newType, this.dimension)) {
            super.setType(newType);
        }
    }

    protected boolean isValidDimensionNType(String type, ChartDimension dimension) {
        if ("Pie Chart".equals(type) && dimension == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            throw new UnsupportedOperationException(Messages.getString("ChartWithoutAxesImpl.Unsupported3Dimension"));
        }
        return true;
    }

    @Override
    protected SeriesDefinition getBaseSeriesDefinition() {
        return (SeriesDefinition)this.getSeriesDefinitions().get(0);
    }

    @Override
    protected List<SeriesDefinition> getOrthogonalSeriesDefinitions() {
        ArrayList<SeriesDefinition> osds = new ArrayList<SeriesDefinition>();
        for (SeriesDefinition bsd : this.getSeriesDefinitions()) {
            osds.addAll((Collection<SeriesDefinition>)bsd.getSeriesDefinitions());
        }
        return osds;
    }
}

