/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.validator;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.ifremer.tutti.persistence.entities.referential.Status;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import java.util.Collection;
import java.util.Iterator;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class TemporaryReferentialFieldValidator
extends NuitonFieldValidatorSupport {
    protected void validateWhenNotSkip(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        Object fieldValue = this.getFieldValue(fieldName, object);
        boolean valid = true;
        if (fieldValue != null) {
            if (fieldValue instanceof TuttiReferentialEntity) {
                valid = this.validateReference((TuttiReferentialEntity)fieldValue);
            } else if (fieldValue instanceof Collection) {
                TuttiReferentialEntity referentialEntity;
                Collection value = (Collection)fieldValue;
                Iterator i$ = value.iterator();
                while (i$.hasNext() && (valid = this.validateReference(referentialEntity = (TuttiReferentialEntity)i$.next()))) {
                }
            } else {
                throw new IllegalStateException("validator " + (Object)((Object)this) + " must be used on a referential or a collection of referential field, but was uses on " + fieldValue);
            }
        }
        if (!valid) {
            this.addFieldError(fieldName, object);
        }
    }

    protected boolean validateReference(TuttiReferentialEntity value) {
        if (value == null) {
            return true;
        }
        Status status = value.getStatus();
        return status.getIdAsInt() != 2;
    }

    public String getValidatorType() {
        return "temporaryReferential";
    }
}

