/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportConfiguration;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ProgramSelectTreeNode;
import org.jdesktop.beans.AbstractSerializableBean;

public class GenericFormatExportUIModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PROGRAM = "program";
    public static final String PROPERTY_EXPORT_ATTACHMENTS = "exportAttachments";
    public static final String PROPERTY_EXPORT_SPECIES = "exportSpecies";
    public static final String PROPERTY_EXPORT_BENTHOS = "exportBenthos";
    public static final String PROPERTY_EXPORT_MARINE_LITTER = "exportMarineLitter";
    public static final String PROPERTY_EXPORT_ACCIDENTAL_CATCH = "exportAccidentalCatch";
    public static final String PROPERTY_EXPORT_INDIVIDUAL_OBSERVATION = "exportIndividualObservation";
    public static final String PROPERTY_DATA_SELECTED = "dataSelected";
    public static final String PROPERTY_CAN_EXPORT = "canExport";
    private Program program;
    private boolean exportSpecies = true;
    private boolean exportBenthos = true;
    private boolean exportMarineLitter = true;
    private boolean exportAccidentalCatch = true;
    private boolean exportIndividualObservation = true;
    private boolean exportAttachments = true;
    private boolean canExport;
    private boolean dataSelected;
    private ProgramSelectTreeNode rootNode;

    public GenericFormatExportConfiguration toExportConfiguration() {
        GenericFormatExportConfiguration configuration = new GenericFormatExportConfiguration();
        configuration.setExportSpecies(this.exportSpecies);
        configuration.setExportBenthos(this.exportBenthos);
        configuration.setExportMarineLitter(this.exportMarineLitter);
        configuration.setExportAccidentalCatch(this.exportAccidentalCatch);
        configuration.setExportIndividualObservation(this.exportIndividualObservation);
        configuration.setExportAttachments(this.exportAttachments);
        ProgramDataModel selectedDataModel = this.rootNode.getSelectedDataModel();
        configuration.setDataToExport(selectedDataModel);
        return configuration;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        Program oldValue = this.getProgram();
        this.program = program;
        this.firePropertyChange(PROPERTY_PROGRAM, oldValue, program);
    }

    public boolean isExportSpecies() {
        return this.exportSpecies;
    }

    public void setExportSpecies(boolean exportSpecies) {
        this.exportSpecies = exportSpecies;
        this.firePropertyChange(PROPERTY_EXPORT_SPECIES, null, exportSpecies);
    }

    public boolean isExportBenthos() {
        return this.exportBenthos;
    }

    public void setExportBenthos(boolean exportBenthos) {
        this.exportBenthos = exportBenthos;
        this.firePropertyChange(PROPERTY_EXPORT_BENTHOS, null, exportBenthos);
    }

    public boolean isExportMarineLitter() {
        return this.exportMarineLitter;
    }

    public void setExportMarineLitter(boolean exportMarineLitter) {
        this.exportMarineLitter = exportMarineLitter;
        this.firePropertyChange(PROPERTY_EXPORT_MARINE_LITTER, null, exportMarineLitter);
    }

    public boolean isExportAccidentalCatch() {
        return this.exportAccidentalCatch;
    }

    public void setExportAccidentalCatch(boolean exportAccidentalCatch) {
        this.exportAccidentalCatch = exportAccidentalCatch;
        this.firePropertyChange(PROPERTY_EXPORT_ACCIDENTAL_CATCH, null, exportAccidentalCatch);
    }

    public boolean isExportIndividualObservation() {
        return this.exportIndividualObservation;
    }

    public void setExportIndividualObservation(boolean exportIndividualObservation) {
        this.exportIndividualObservation = exportIndividualObservation;
        this.firePropertyChange(PROPERTY_EXPORT_INDIVIDUAL_OBSERVATION, null, exportIndividualObservation);
    }

    public boolean isExportAttachments() {
        return this.exportAttachments;
    }

    public void setExportAttachments(boolean exportAttachments) {
        this.exportAttachments = exportAttachments;
        this.firePropertyChange(PROPERTY_EXPORT_ATTACHMENTS, null, exportAttachments);
    }

    public boolean isCanExport() {
        return this.canExport;
    }

    public void setCanExport(boolean canExport) {
        this.canExport = canExport;
        this.firePropertyChange(PROPERTY_CAN_EXPORT, null, canExport);
    }

    public boolean isDataSelected() {
        return this.dataSelected;
    }

    public void setDataSelected(boolean dataSelected) {
        this.dataSelected = dataSelected;
        this.firePropertyChange(PROPERTY_DATA_SELECTED, null, dataSelected);
    }

    public boolean computeIsCanExport() {
        return this.getProgram() != null && this.isDataSelected();
    }

    public void setRootNode(ProgramSelectTreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public ProgramSelectTreeNode getRootNode() {
        return this.rootNode;
    }
}

