// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.history;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Permet de tracer les suppressions d’entités (marée, vente, etc), notamment afin que ces
 * suppressions soient importées dans les bases locales d'Allegro.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class DeletedItemHistory
    implements Serializable, Comparable<DeletedItemHistory>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -5650487114944701594L;

    // Generate 7 attributes
    private Long id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Long
     */
    public Long getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Long
     */
    public void setId(Long idIn)
    {
        this.id = idIn;
    }

    private String vesselCode;

    /**
     * (=VESSEL_FK) Si la suppression concerne un navire, on trace le code du navire, afin
     * d'optimiser les synchronisations des utilisateurs qui ne sont pas concernés par ce navire.
     * @return this.vesselCode String
     */
    public String getVesselCode()
    {
        return this.vesselCode;
    }

    /**
     * (=VESSEL_FK) Si la suppression concerne un navire, on trace le code du navire, afin
     * d'optimiser les synchronisations des utilisateurs qui ne sont pas concernés par ce navire.
     * @param vesselCodeIn String
     */
    public void setVesselCode(String vesselCodeIn)
    {
        this.vesselCode = vesselCodeIn;
    }

    private Long objectId;

    /**
     * Identifiant de l'entité supprimée, correspondant généralement à la colonne ID de la table
     * concernée.
     * @return this.objectId Long
     */
    public Long getObjectId()
    {
        return this.objectId;
    }

    /**
     * Identifiant de l'entité supprimée, correspondant généralement à la colonne ID de la table
     * concernée.
     * @param objectIdIn Long
     */
    public void setObjectId(Long objectIdIn)
    {
        this.objectId = objectIdIn;
    }

    private String comments;

    /**
     * Commentaire sur la suppression (optionnel).
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire sur la suppression (optionnel).
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private String objectCode;

    /**
     * 
     * @return this.objectCode String
     */
    public String getObjectCode()
    {
        return this.objectCode;
    }

    /**
     * 
     * @param objectCodeIn String
     */
    public void setObjectCode(String objectCodeIn)
    {
        this.objectCode = objectCodeIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 5 associations
    private ObjectType objectType;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Type d'entité supprimée.
     * </p>
     * <p>
     * Généralement, on utilise le nom de la table principale de l'entité.
     * <br>
     * <br>Exemple :
     * <br>- FISHING_TRIP
     * <br>- SALE
     * <br>- PRODUCE
     * </p>
     * <p>
     * - etc.
     * </p>
     * </body>
     * </html>
     * @return this.objectType ObjectType
     */
    public ObjectType getObjectType()
    {
        return this.objectType;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Type d'entité supprimée.
     * </p>
     * <p>
     * Généralement, on utilise le nom de la table principale de l'entité.
     * <br>
     * <br>Exemple :
     * <br>- FISHING_TRIP
     * <br>- SALE
     * <br>- PRODUCE
     * </p>
     * <p>
     * - etc.
     * </p>
     * </body>
     * </html>
     * @param objectTypeIn ObjectType
     */
    public void setObjectType(ObjectType objectTypeIn)
    {
        this.objectType = objectTypeIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private ProcessingHistory processingHistory;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Historique des traitements, qu’il s’agisse de flux (comme historiquement
     * la table HIS_FLUX) ou non (traitement d’agrégation, CQ auto, etc.).
     * </p>
     * <p>
     * </p>
     * <p style="font-family:Times New
     * Roman,serif;margin-bottom:.0001pt;margin-left:0cm;margin-top:0cm;font-size:12.0pt;">
     * Permet donc de conserver l'historique des traitements qui se sont
     * exécutés sur le système, notamment ceux qui ont impactés la base de
     * données brutes (Adagio).
     * </p>
     * <p style="font-family:Times New
     * Roman,serif;margin-bottom:.0001pt;margin-left:0cm;margin-top:0cm;font-size:12.0pt;">
     * </p>
     * <p style="font-family:Times New
     * Roman,serif;margin-bottom:.0001pt;margin-left:0cm;margin-top:0cm;font-size:12.0pt;">
     * L’exécution des traitements en erreur peuvent également être tracée.
     * </p>
     * </body>
     * </html>
     * @return this.processingHistory ProcessingHistory
     */
    public ProcessingHistory getProcessingHistory()
    {
        return this.processingHistory;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Historique des traitements, qu’il s’agisse de flux (comme historiquement
     * la table HIS_FLUX) ou non (traitement d’agrégation, CQ auto, etc.).
     * </p>
     * <p>
     * </p>
     * <p style="font-family:Times New
     * Roman,serif;margin-bottom:.0001pt;margin-left:0cm;margin-top:0cm;font-size:12.0pt;">
     * Permet donc de conserver l'historique des traitements qui se sont
     * exécutés sur le système, notamment ceux qui ont impactés la base de
     * données brutes (Adagio).
     * </p>
     * <p style="font-family:Times New
     * Roman,serif;margin-bottom:.0001pt;margin-left:0cm;margin-top:0cm;font-size:12.0pt;">
     * </p>
     * <p style="font-family:Times New
     * Roman,serif;margin-bottom:.0001pt;margin-left:0cm;margin-top:0cm;font-size:12.0pt;">
     * L’exécution des traitements en erreur peuvent également être tracée.
     * </p>
     * </body>
     * </html>
     * @param processingHistoryIn ProcessingHistory
     */
    public void setProcessingHistory(ProcessingHistory processingHistoryIn)
    {
        this.processingHistory = processingHistoryIn;
    }

    /**
     * Returns <code>true</code> if the argument is an DeletedItemHistory instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof DeletedItemHistory))
        {
            return false;
        }
        final DeletedItemHistory that = (DeletedItemHistory)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link DeletedItemHistory}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link DeletedItemHistory}.
         * @return new DeletedItemHistoryImpl()
         */
        public static DeletedItemHistory newInstance()
        {
            return new DeletedItemHistoryImpl();
        }

        /**
         * Constructs a new instance of {@link DeletedItemHistory}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param objectType ObjectType
         * @return newInstance
         */
        public static DeletedItemHistory newInstance(ObjectType objectType)
        {
            final DeletedItemHistory entity = new DeletedItemHistoryImpl();
            entity.setObjectType(objectType);
            return entity;
        }

        /**
         * Constructs a new instance of {@link DeletedItemHistory}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param vesselCode String
         * @param objectId Long
         * @param comments String
         * @param updateDate Timestamp
         * @param objectCode String
         * @param remoteId Integer
         * @param objectType ObjectType
         * @param program Program
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param processingHistory ProcessingHistory
         * @return newInstance DeletedItemHistory
         */
        public static DeletedItemHistory newInstance(String vesselCode, Long objectId, String comments, Timestamp updateDate, String objectCode, Integer remoteId, ObjectType objectType, Program program, Department recorderDepartment, Person recorderPerson, ProcessingHistory processingHistory)
        {
            final DeletedItemHistory entity = new DeletedItemHistoryImpl();
            entity.setVesselCode(vesselCode);
            entity.setObjectId(objectId);
            entity.setComments(comments);
            entity.setUpdateDate(updateDate);
            entity.setObjectCode(objectCode);
            entity.setRemoteId(remoteId);
            entity.setObjectType(objectType);
            entity.setProgram(program);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setProcessingHistory(processingHistory);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(DeletedItemHistory o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getVesselCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getVesselCode().compareTo(o.getVesselCode()));
            }
            if (this.getObjectId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getObjectId().compareTo(o.getObjectId()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getObjectCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getObjectCode().compareTo(o.getObjectCode()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// DeletedItemHistory.java merge-point
}