/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.ISplitter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.BidiSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;

public class ChunkGenerator {
    private FontMappingManager fontManager;
    private ITextContent textContent;
    private boolean bidiProcessing;
    private boolean fontSubstitution;
    private String text;
    private ISplitter bidiSplitter = null;
    private ISplitter fontSplitter = null;

    public ChunkGenerator(FontMappingManager fontManager, ITextContent textContent, boolean bidiProcessing, boolean fontSubstitution) {
        this.fontManager = fontManager;
        this.textContent = textContent;
        this.text = textContent.getText();
        this.bidiProcessing = bidiProcessing;
        this.fontSubstitution = fontSubstitution;
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        if (bidiProcessing) {
            this.bidiSplitter = "rtl".equals(textContent.getComputedStyle().getDirection()) ? new BidiSplitter(new Chunk(this.text, 0, 1, 1)) : new BidiSplitter(new Chunk(this.text, 0, 0, 0));
        }
        if (this.bidiSplitter == null) {
            this.fontSplitter = new FontSplitter(fontManager, new Chunk(this.text), textContent, fontSubstitution);
        } else if (this.bidiSplitter.hasMore()) {
            this.fontSplitter = new FontSplitter(fontManager, this.bidiSplitter.getNext(), textContent, fontSubstitution);
        }
    }

    public boolean hasMore() {
        if (this.text == null || this.text.length() == 0) {
            return false;
        }
        if (this.bidiProcessing) {
            if (this.bidiSplitter == null) {
                return false;
            }
            if (this.bidiSplitter.hasMore()) {
                return true;
            }
        }
        if (this.fontSplitter == null) {
            return false;
        }
        return this.fontSplitter.hasMore();
    }

    public Chunk getNext() {
        while (this.fontSplitter != null) {
            if (this.fontSplitter.hasMore()) {
                return this.fontSplitter.getNext();
            }
            this.fontSplitter = null;
            if (this.bidiSplitter != null && this.bidiSplitter.hasMore()) {
                this.fontSplitter = new FontSplitter(this.fontManager, this.bidiSplitter.getNext(), this.textContent, this.fontSubstitution);
                continue;
            }
            return null;
        }
        return null;
    }
}

