/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.db.actions.OpenDbAction;
import fr.ifremer.tutti.ui.swing.update.TuttiDbUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.update.Updates;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class InstallDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(InstallDbAction.class);
    protected File backupFile;
    protected boolean doBackup;
    protected String jdbcUrl;

    public InstallDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            doAction = this.getContext().checkUpdateDataReachable(true);
        }
        if (doAction) {
            ProgressionModel progressionModel = new ProgressionModel();
            progressionModel.setTotal(2);
            this.setProgressionModel(progressionModel);
        }
        return doAction;
    }

    @Override
    public void doAction() {
        ProgressionModel progressionModel = this.getProgressionModel();
        TuttiConfiguration config = this.getConfig();
        File current = config.getDataDirectory();
        String url = config.getUpdateDataUrl();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Try to install / update db (current data location: %s), using update url: %s", current, url));
        }
        progressionModel.increments(I18n.t((String)"tutti.dbManager.action.upgradeDb.check", (Object[])new Object[0]));
        TuttiDbUpdaterCallBack callback = new TuttiDbUpdaterCallBack(url, this, progressionModel);
        Updates.doUpdate(config, callback, current);
        Preconditions.checkState((boolean)callback.isDbInstalled());
        progressionModel.increments(I18n.t((String)"tutti.dbManager.action.upgradeDb.opening", (Object[])new Object[0]));
        this.getContext().setDbExist(true);
        this.getActionEngine().runInternalAction(this.getHandler(), OpenDbAction.class);
    }
}

