/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportFishingOperationActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import java.util.ArrayList;
import java.util.List;

public class CreateIndividualObservationRowsAction
extends ExportFishingOperationActionSupport {
    private final PersistenceService persistenceService;

    public CreateIndividualObservationRowsAction(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public boolean doExecute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        return exportContext.isExportIndividualObservation() && operationContext.isWithCatchBatch();
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        List<IndividualObservationRow> individualObservationRows = exportContext.getProducerForIndividualObservation().getDataToExport(operationContext);
        operationContext.setIndividualObservationRows(individualObservationRows);
        exportContext.getProducerForSpecies().prepareIndividualRows(individualObservationRows);
        if (exportContext.isExportAttachments()) {
            List<AttachmentRow> attachmentRows = this.getAttachmentRows(exportContext, operationContext.getIndividualObservations());
            operationContext.addAttachmentRows(attachmentRows);
        }
    }

    public List<AttachmentRow> getAttachmentRows(GenericFormatExportContext exportContext, List<IndividualObservationBatch> individualObservationBatches) {
        CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        for (IndividualObservationBatch individualObservationBatch : individualObservationBatches) {
            List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.SAMPLE, individualObservationBatch.getIdAsInt());
            producerForAttachment.addAttachments(attachments, attachmentRows);
        }
        return attachmentRows;
    }
}

