/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;

public final class LegendItemHints {
    private final Type type;
    private int index = -1;
    private SeriesDefinition sed = null;
    private Series series = null;
    private String sItem = null;
    private int validItemLen;
    private String sValue = null;
    private int validValueLen;
    private double left = 0.0;
    private double top = 0.0;
    private double width = 0.0;
    private double itemHeight;
    private double valueHeight = 0.0;

    private LegendItemHints(Type type, String sItem) {
        this.type = type;
        this.sItem = sItem;
    }

    private LegendItemHints(Type type, String sItem, String sValue, SeriesDefinition sed, Series series, int index) {
        this.type = type;
        this.sItem = sItem;
        this.sValue = sValue;
        this.sed = sed;
        this.series = series;
        this.index = index;
    }

    public static LegendItemHints newGroupNameEntry(String name) {
        return new LegendItemHints(Type.LG_GROUPNAME, name);
    }

    public static LegendItemHints newEntry(String sItem, String sValue, SeriesDefinition sed, Series se, int index) {
        return new LegendItemHints(Type.LG_ENTRY, sItem, sValue, sed, se, index);
    }

    public static LegendItemHints newCategoryEntry(String sItem, SeriesDefinition sed, Series se, int index) {
        return new LegendItemHints(Type.LG_ENTRY, sItem, null, sed, se, index);
    }

    public static LegendItemHints newMinSliceEntry(String sItem, SeriesDefinition sed, Series se, int index) {
        return new LegendItemHints(Type.LG_MINSLICE, sItem, null, sed, se, index);
    }

    public static LegendItemHints createSeperator() {
        return new LegendItemHints(Type.LG_SEPERATOR, null);
    }

    public LegendItemHints left(double left) {
        this.left = left;
        return this;
    }

    public LegendItemHints top(double top) {
        this.top = top;
        return this;
    }

    public LegendItemHints validItemLen(int validItemLen) {
        this.validItemLen = validItemLen;
        return this;
    }

    public LegendItemHints validValueLen(int validValueLen) {
        this.validValueLen = validValueLen;
        return this;
    }

    public LegendItemHints width(double width) {
        this.width = width;
        return this;
    }

    public LegendItemHints itemHeight(double itemHeight) {
        this.itemHeight = itemHeight;
        return this;
    }

    public LegendItemHints valueHeight(double valueHeight) {
        this.valueHeight = valueHeight;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Series getSeries() {
        return this.series;
    }

    public SeriesDefinition getSeriesDefinition() {
        return this.sed;
    }

    public int getIndex() {
        return this.index;
    }

    public String getItemText() {
        return this.sItem;
    }

    public Object getItemValue() {
        return this.series.getSeriesIdentifier();
    }

    public void setItemText(String itemText) {
        this.sItem = itemText;
    }

    public String getValueText() {
        return this.sValue;
    }

    public void setSeries(Series series) {
        this.series = series;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getItemHeight() {
        return this.itemHeight;
    }

    public final double getValueHeight() {
        return this.valueHeight;
    }

    public final int getValidItemLen() {
        return this.validItemLen;
    }

    public final int getValidValueLen() {
        return this.validValueLen;
    }

    public static enum Type {
        LG_GROUPNAME,
        LG_ENTRY,
        LG_MINSLICE,
        LG_SEPERATOR;

    }
}

