// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.batch;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre d'échantillonnage
 * sont en effet constitués d'un ensemble de lots.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Batch
    implements Serializable, Comparable<Batch>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -7658122195906847987L;

    // Generate 9 attributes
    private Integer id;

    /**
     * Identifiant unique du lot.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique du lot.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Short rankOrder;

    /**
     * Numéro d'ordre du lot.
     * Sert pour déterminer l'ordre de présentation des lots rattaché à un même lot père.
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * Numéro d'ordre du lot.
     * Sert pour déterminer l'ordre de présentation des lots rattaché à un même lot père.
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private Float subgroupCount;

    /**
     * Nombre de sous ensembles ayant servit à la quantification. Attention : Il ne s'agit pas du
     * nombre de lot fils.
     * Par exemple il pourra s'agir d'un nombre de caisse servant à quantifié le lot.
     * Par exemple, pour une détermination de la quantification par les volumes :
     * - nombre_sous_ensembles_quantifiés = 3
     * - poids moyen par sous-ensemble = 5 kg
     * => Poids total du lot = 3 x 5 = 15kg
     * @return this.subgroupCount Float
     */
    public Float getSubgroupCount()
    {
        return this.subgroupCount;
    }

    /**
     * Nombre de sous ensembles ayant servit à la quantification. Attention : Il ne s'agit pas du
     * nombre de lot fils.
     * Par exemple il pourra s'agir d'un nombre de caisse servant à quantifié le lot.
     * Par exemple, pour une détermination de la quantification par les volumes :
     * - nombre_sous_ensembles_quantifiés = 3
     * - poids moyen par sous-ensemble = 5 kg
     * => Poids total du lot = 3 x 5 = 15kg
     * @param subgroupCountIn Float
     */
    public void setSubgroupCount(Float subgroupCountIn)
    {
        this.subgroupCount = subgroupCountIn;
    }

    private Integer individualCount;

    /**
     * Nombre d'individus comptés.
     * @return this.individualCount Integer
     */
    public Integer getIndividualCount()
    {
        return this.individualCount;
    }

    /**
     * Nombre d'individus comptés.
     * @param individualCountIn Integer
     */
    public void setIndividualCount(Integer individualCountIn)
    {
        this.individualCount = individualCountIn;
    }

    private Boolean childBatchsReplication = Boolean.valueOf(false);

    /**
     * Indique si les lots fils sont des réplicats ou non. Attribut non renseigné si un des lots
     * père est rattaché à un taxon ou groupe de taxon.
     * @return this.childBatchsReplication Boolean
     */
    public Boolean isChildBatchsReplication()
    {
        return this.childBatchsReplication;
    }

    /**
     * Indique si les lots fils sont des réplicats ou non. Attribut non renseigné si un des lots
     * père est rattaché à un taxon ou groupe de taxon.
     * @param childBatchsReplicationIn Boolean
     */
    public void setChildBatchsReplication(Boolean childBatchsReplicationIn)
    {
        this.childBatchsReplication = childBatchsReplicationIn;
    }

    private Boolean exhaustiveInventory = Boolean.valueOf(false);

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Indique si l'inventaire des esp&#232;ces scientifiques (ReferenceTaxon) est
     * exhaustif ou non.Attribut non renseign&#233; si le lot ou un de ses lots p&#232;re
     * est rattach&#233; &#224; un taxon.
     * </p>
     * <p>
     * </p>
     * <p>
     * Si l'inventaire est exhautif, il convient de remplir <i>BatchExhautiveInventory</i>,
     * pour tracer sur quelle liste d'esp&#232;ces porte l'exhaustivit&#233;. Si
     * <i>BatchExhautiveInventory</i>
     * n'est pas renseign&#233;, alors l'exhautivit&#233; porte sur toutes les esp&#232;ces.
     * </p>
     * </body>
     * </html>
     * @return this.exhaustiveInventory Boolean
     */
    public Boolean isExhaustiveInventory()
    {
        return this.exhaustiveInventory;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Indique si l'inventaire des esp&#232;ces scientifiques (ReferenceTaxon) est
     * exhaustif ou non.Attribut non renseign&#233; si le lot ou un de ses lots p&#232;re
     * est rattach&#233; &#224; un taxon.
     * </p>
     * <p>
     * </p>
     * <p>
     * Si l'inventaire est exhautif, il convient de remplir <i>BatchExhautiveInventory</i>,
     * pour tracer sur quelle liste d'esp&#232;ces porte l'exhaustivit&#233;. Si
     * <i>BatchExhautiveInventory</i>
     * n'est pas renseign&#233;, alors l'exhautivit&#233; porte sur toutes les esp&#232;ces.
     * </p>
     * </body>
     * </html>
     * @param exhaustiveInventoryIn Boolean
     */
    public void setExhaustiveInventory(Boolean exhaustiveInventoryIn)
    {
        this.exhaustiveInventory = exhaustiveInventoryIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private String label;

    /**
     * Libellé du lot (besoin pour le flux d'échantillonnage ISCAX).
     * Pas encore utiliser, dans Allegro V2 et V3 lot 1.
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * Libellé du lot (besoin pour le flux d'échantillonnage ISCAX).
     * Pas encore utiliser, dans Allegro V2 et V3 lot 1.
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 8 associations
    private Location location;

    /**
     * Zone de pêche.
     * Uniquement dans le cas ou l'opération unitaire n'est pas connue (Exemple : lors des
     * échantillonnage des ventes observées)
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Zone de pêche.
     * Uniquement dans le cas ou l'opération unitaire n'est pas connue (Exemple : lors des
     * échantillonnage des ventes observées)
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private Batch parentBatch;

    /**
     * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre
     * d'échantillonnage
     * sont en effet constitués d'un ensemble de lots.
     * @return this.parentBatch Batch
     */
    public Batch getParentBatch()
    {
        return this.parentBatch;
    }

    /**
     * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre
     * d'échantillonnage
     * sont en effet constitués d'un ensemble de lots.
     * @param parentBatchIn Batch
     */
    public void setParentBatch(Batch parentBatchIn)
    {
        this.parentBatch = parentBatchIn;
    }

    private Collection<Batch> childBatchs = new HashSet<Batch>();

    /**
     * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre
     * d'échantillonnage
     * sont en effet constitués d'un ensemble de lots.
     * @return this.childBatchs Collection<Batch>
     */
    public Collection<Batch> getChildBatchs()
    {
        return this.childBatchs;
    }

    /**
     * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre
     * d'échantillonnage
     * sont en effet constitués d'un ensemble de lots.
     * @param childBatchsIn Collection<Batch>
     */
    public void setChildBatchs(Collection<Batch> childBatchsIn)
    {
        this.childBatchs = childBatchsIn;
    }

    /**
     * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre
     * d'échantillonnage
     * sont en effet constitués d'un ensemble de lots.
     * @param elementToAdd Batch
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addChildBatchs(Batch elementToAdd)
    {
        return this.childBatchs.add(elementToAdd);
    }

    /**
     * Lot échantillonné ou lot composant une capture réelle. Une capture ou un arbre
     * d'échantillonnage
     * sont en effet constitués d'un ensemble de lots.
     * @param elementToRemove Batch
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeChildBatchs(Batch elementToRemove)
    {
        return this.childBatchs.remove(elementToRemove);
    }

    private Collection<BatchExhaustiveInventory> batchExhaustiveInventories = new HashSet<BatchExhaustiveInventory>();

    /**
     * Liste les niveaux d'exhautivité, c'est à dire les listes concernés par l'éxhautivité.
     * Ces listes sont représentées par une niveau de priorité, définis dans la stratégie (cf
     * ReferenceTaxonStrategy)
     * @return this.batchExhaustiveInventories Collection<BatchExhaustiveInventory>
     */
    public Collection<BatchExhaustiveInventory> getBatchExhaustiveInventories()
    {
        return this.batchExhaustiveInventories;
    }

    /**
     * Liste les niveaux d'exhautivité, c'est à dire les listes concernés par l'éxhautivité.
     * Ces listes sont représentées par une niveau de priorité, définis dans la stratégie (cf
     * ReferenceTaxonStrategy)
     * @param batchExhaustiveInventoriesIn Collection<BatchExhaustiveInventory>
     */
    public void setBatchExhaustiveInventories(Collection<BatchExhaustiveInventory> batchExhaustiveInventoriesIn)
    {
        this.batchExhaustiveInventories = batchExhaustiveInventoriesIn;
    }

    /**
     * Liste les niveaux d'exhautivité, c'est à dire les listes concernés par l'éxhautivité.
     * Ces listes sont représentées par une niveau de priorité, définis dans la stratégie (cf
     * ReferenceTaxonStrategy)
     * @param elementToAdd BatchExhaustiveInventory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addBatchExhaustiveInventories(BatchExhaustiveInventory elementToAdd)
    {
        return this.batchExhaustiveInventories.add(elementToAdd);
    }

    /**
     * Liste les niveaux d'exhautivité, c'est à dire les listes concernés par l'éxhautivité.
     * Ces listes sont représentées par une niveau de priorité, définis dans la stratégie (cf
     * ReferenceTaxonStrategy)
     * @param elementToRemove BatchExhaustiveInventory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeBatchExhaustiveInventories(BatchExhaustiveInventory elementToRemove)
    {
        return this.batchExhaustiveInventories.remove(elementToRemove);
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Collection<Produce> produces = new HashSet<Produce>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @return this.produces Collection<Produce>
     */
    public Collection<Produce> getProduces()
    {
        return this.produces;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param producesIn Collection<Produce>
     */
    public void setProduces(Collection<Produce> producesIn)
    {
        this.produces = producesIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduces(Produce elementToAdd)
    {
        return this.produces.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduces(Produce elementToRemove)
    {
        return this.produces.remove(elementToRemove);
    }

    private Collection<QuantificationMeasurement> quantificationMeasurements = new HashSet<QuantificationMeasurement>();

    /**
     * Liste des mesure de quantification du lot.
     * @return this.quantificationMeasurements Collection<QuantificationMeasurement>
     */
    public Collection<QuantificationMeasurement> getQuantificationMeasurements()
    {
        return this.quantificationMeasurements;
    }

    /**
     * Liste des mesure de quantification du lot.
     * @param quantificationMeasurementsIn Collection<QuantificationMeasurement>
     */
    public void setQuantificationMeasurements(Collection<QuantificationMeasurement> quantificationMeasurementsIn)
    {
        this.quantificationMeasurements = quantificationMeasurementsIn;
    }

    /**
     * Liste des mesure de quantification du lot.
     * @param elementToAdd QuantificationMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addQuantificationMeasurements(QuantificationMeasurement elementToAdd)
    {
        return this.quantificationMeasurements.add(elementToAdd);
    }

    /**
     * Liste des mesure de quantification du lot.
     * @param elementToRemove QuantificationMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeQuantificationMeasurements(QuantificationMeasurement elementToRemove)
    {
        return this.quantificationMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Batch instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Batch))
        {
            return false;
        }
        final Batch that = (Batch)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Batch o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getSubgroupCount() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSubgroupCount().compareTo(o.getSubgroupCount()));
            }
            if (this.getIndividualCount() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIndividualCount().compareTo(o.getIndividualCount()));
            }
            if (this.isChildBatchsReplication() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isChildBatchsReplication().compareTo(o.isChildBatchsReplication()));
            }
            if (this.isExhaustiveInventory() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isExhaustiveInventory().compareTo(o.isExhaustiveInventory()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Batch.java merge-point
    private Float weight = null;
    private Integer weightMethodId = null;
    private Float weightBeforeSampling = null;
    private Float indirectWeight = null;
    private Float elevateWeight = null;
    
  public Float getWeight() {
    return weight;
  }

  public void setWeightMethodId(Integer weightMethodId) {
    this.weightMethodId = weightMethodId;
  }
  public Integer getWeightMethodId() {
    return weightMethodId;
  }

  public void setWeight(Float weight) {
    this.weight = weight;
  }
  
  public Float getWeightBeforeSampling() {
    return weightBeforeSampling;
  }

  public void setWeightBeforeSampling(Float weightBeforeSampling) {
    this.weightBeforeSampling = weightBeforeSampling;
  }

  public Float getIndirectWeight() {
    return indirectWeight;
  }

  public void setIndirectWeight(Float indirectWeight) {
    this.indirectWeight = indirectWeight;
  }

  public Float getElevateWeight() {
    return elevateWeight;
  }

  public void setElevateWeight(Float elevateWeight) {
    this.elevateWeight = elevateWeight;
  }
}