/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristics;
import java.io.Serializable;
import java.text.ParseException;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.i18n.I18n;

public class CaracteristicValueParserFormatter
implements ValueParserFormatter<Serializable> {
    private final boolean technical;
    private final Caracteristic caracteristic;
    private final ValueParserFormatter<Integer> integerDelegate;
    private final ValueParserFormatter<Float> floatDelegate;
    private final ValueParserFormatter<String> textDelegate;

    public static CaracteristicValueParserFormatter newFormatter() {
        return new CaracteristicValueParserFormatter(false, null);
    }

    public static CaracteristicValueParserFormatter newTechnicalFormatter() {
        return new CaracteristicValueParserFormatter(true, null);
    }

    public static CaracteristicValueParserFormatter newParser(Caracteristic caracteristic) {
        return new CaracteristicValueParserFormatter(true, caracteristic);
    }

    protected CaracteristicValueParserFormatter(boolean technical, Caracteristic caracteristic) {
        this.technical = technical;
        this.caracteristic = caracteristic;
        this.integerDelegate = Common.INTEGER;
        this.floatDelegate = Common.FLOAT;
        this.textDelegate = Common.STRING;
    }

    public Serializable parse(String value) throws ParseException {
        Object result;
        if ("NA".equals(value)) {
            result = null;
        } else if (Caracteristics.isNumberCaracteristic((Caracteristic)this.caracteristic)) {
            result = (Serializable)this.floatDelegate.parse(value);
        } else if (Caracteristics.isTextCaracteristic((Caracteristic)this.caracteristic)) {
            result = value;
        } else {
            result = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)this.caracteristic, (String)value);
            if (result == null) {
                throw new ParseException(I18n.t((String)"tutti.service.csv.caracteristic.qualitativeValue.notFound", (Object[])new Object[]{this.caracteristic.getId(), value}), 0);
            }
        }
        return result;
    }

    public String format(Serializable e) {
        String value;
        if (e == null) {
            value = "NA";
        } else if (e instanceof Float) {
            value = this.floatDelegate.format((Object)((Float)e));
        } else if (e instanceof Integer) {
            value = this.integerDelegate.format((Object)((Integer)e));
        } else if (e instanceof String) {
            value = this.textDelegate.format((Object)((String)((Object)e)));
        } else {
            CaracteristicQualitativeValue qv = (CaracteristicQualitativeValue)e;
            value = this.technical ? qv.getId() : qv.getDescription();
        }
        return value;
    }
}

