/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.util;

import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JTable;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.JTables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationColorHighlighter;

public class ApplicationUIUtil {
    private static final Log log = LogFactory.getLog(ApplicationUIUtil.class);

    protected ApplicationUIUtil() {
    }

    public static void setApplicationContext(JAXXObject ui, ApplicationUIContext context) {
        ui.setContextValue((Object)context, "applicationContext");
    }

    public static ApplicationUIContext getApplicationContext(JAXXObject ui) {
        return (ApplicationUIContext)ui.getContextValue(ApplicationUIContext.class, "applicationContext");
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new ApplicationColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new ApplicationColorHighlighter(predicate, color, true);
    }

    public static void openLink(URL url) {
        try {
            ApplicationUIUtil.openLink(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.open.link", (Object[])new Object[]{url}), (Throwable)e);
        }
    }

    public static Desktop getDesktopForBrowse() {
        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.browse.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static Desktop getDesktopForOpen() {
        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.open.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void openLink(URI uri) {
        Desktop desktop = ApplicationUIUtil.getDesktopForBrowse();
        try {
            desktop.browse(uri);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.open.link", (Object[])new Object[]{uri}), (Throwable)e);
        }
    }

    public static Desktop getDesktopForMail() {
        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.MAIL)) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.mail.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void mail(String subject, String body) {
        Desktop desktop = ApplicationUIUtil.getDesktopForMail();
        try {
            URI mailtoURI = new URI("mailto", null, null, "subject=" + subject + "&body=" + body, null);
            desktop.mail(mailtoURI);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.mail", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @Deprecated
    public static void selectFirstCellOnFirstRowAndStopEditing(JXTable table) {
        JTables.selectFirstCellOnFirstRowAndStopEditing((JTable)table);
    }

    @Deprecated
    public static void selectFirstCellOnLastRow(JXTable table) {
        JTables.selectFirstCellOnLastRow((JTable)table);
    }

    @Deprecated
    public static void selectFirstCellOnRow(JXTable table, int row, boolean stopEdit) {
        JTables.selectFirstCellOnRow((JTable)table, (int)row, (boolean)stopEdit);
    }

    @Deprecated
    public static void doSelectCell(JTable table, int rowIndex, int columnIndex) {
        JTables.doSelectCell((JTable)table, (int)rowIndex, (int)columnIndex);
    }
}

