package fr.ifremer.tutti.ui.swing.content.operation.fishing;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class GearUseFeatureTabUI extends Table implements TuttiUI<GearUseFeatureTabUIModel, GearUseFeatureTabUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_NEW_ROW_KEY_ENABLED = "newRowKey.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED = "removeCaracteristicMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW9bRRSdOLETJy0FrKRFKVICpWqRmBQJpEqh0NjEwamTVrErRViijP0mzqTjmWHmvvpFVhA/gZ8AezZI7FghFqxZsEH8BYRYsEXcec/xR/yqoKhePFlz5577ec589yfJOktWj1gUURsqEB1Otzf29x82j3gLPuauZYUBbUnym8qQTIMsBINzB+TNRtW7r/Xd10q6Y7TiasR7vUrmHRxL7g45ByCvj3u0nFurDczrkQntKeogqTTUb/7+K/N18NW3GUIig9nNYSkr53kNK5mpkowIgLyKkZ6xNclUG9OwQrUx38v+rCSZc7usw78gX5LZKskZZhEMyBv/v+QYI/aPDJDZG3XWlPwOkK0DS8WB5R1uKYQAgoaCui5Gpy2tAMGoNtwyEFrRA+EOvWWLM/vY8TJnEFqOUI8rxsToOSDZjg64BFJ9Qcg7Hm4IPw8+80fahFjHkm9P1Efdjg93uAqHt69ifP2Ml5hlLeBWOBAtfwPI4pirP6sA73i3KwPvvOLdPd19wI+BvD820cSNBwJ7TJucKVrET1lIDOLzw1E0dVFHHig/wMuxIEA8IIWx4EXsjlbjVy/f2K61rJbyEVN+TlfHPIamca9C+2z/JAeyrG2bHiFbnoI2CUREt/djq3dcNrixy2P1IRfokAvDZZ1qkKwN8RjItcYkffbQlBDn2hnieMDY+u9S4bcf//ihfMqWHMZeTL06QnbcYmP9toDwoa8kVAlByLUdZtYbJO+4RKWIleB6SmK1vhmTw3iveHfq3eknzB0iRHb2959+Xvr812mSKZN5qVlQZv5+heTh0GIXtAwi89H9OKNL3Tn8vuxzwx1BW3ePOy8oM2BDHmH111OqH6TQzP/yT6H2/f3TDkxhRq899/qwC9lPSU4oKRSPFaMvBqkKsWAcDwM9JH2aDBBPoPS17RPoZvx9e6LsDCoIV94BdWuptzqgCRVus2Pg+NbtEyBz/ZEheRaT8fBgjIhR6OFp3AL/7w4ZpZw5J4np0STe6g1zaHOo9cN5St+6vbJ6b0WFUmJO8xgd9abiFYhMIx2RaU+c6BjJN2ILkM96FxGuBNedEbCNmO8JMm353p+kFd3XhfMqnsFkk0YinJdFX3cVW1kbPZS0Vtndqm4+qW1WN0v1ysNdPwunLSRqkD1gEreVFAZQZW152+pQ+W70SlqiphWrG6UHJ6O3iqz19PRWrhf3M62WNAk6r7Dc6Chv9uIHBFdpb1K7N5Nb8X7NAI+QdO8lM0oJ2x8KTXkDzmzCpSaD1uE7GJYDn1wJ9gJXIinq7FZgCuLdu2pHoVX59O5dpCraGfgvgNayLkw97tHdC6GBMGkTft6bet6UUSzn/FNZPzbY45c+CBiwlaZQATbrw4lAU/67hJj/AR4jSXMdCgAA";
    private static final Log log = LogFactory.getLog(GearUseFeatureTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected JXTable gearUseFeatureTable;
    protected final GearUseFeatureTabUIHandler handler = createHandler();
    protected GearUseFeatureTabUIModel model;
    protected BeanFilterableComboBox<Caracteristic> newRowKey;
    protected JMenuItem removeCaracteristicMenu;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private GearUseFeatureTabUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GearUseFeatureTabUI(EditFishingOperationUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public GearUseFeatureTabUI() {
        $initialize();
    }

    public GearUseFeatureTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__gearUseFeatureTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__gearUseFeatureTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public JXTable getGearUseFeatureTable() {
        return gearUseFeatureTable;
    }

    public GearUseFeatureTabUIHandler getHandler() {
        return handler;
    }

    public GearUseFeatureTabUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<Caracteristic> getNewRowKey() {
        return newRowKey;
    }

    public JMenuItem getRemoveCaracteristicMenu() {
        return removeCaracteristicMenu;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeCaracteristicMenu);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.GearUseFeatureAddRowAction.class);
    }

    protected void createGearUseFeatureTable() {
        $objectMap.put("gearUseFeatureTable", gearUseFeatureTable = new JXTable());
        
        gearUseFeatureTable.setName("gearUseFeatureTable");
        gearUseFeatureTable.setSortable(false);
        gearUseFeatureTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__gearUseFeatureTable"));
        gearUseFeatureTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__gearUseFeatureTable"));
    }

    protected GearUseFeatureTabUIHandler createHandler() {
        return new GearUseFeatureTabUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(GearUseFeatureTabUIModel.class));
    }

    protected void createNewRowKey() {
        $objectMap.put("newRowKey", newRowKey = new BeanFilterableComboBox<Caracteristic>(this));
        
        newRowKey.setName("newRowKey");
        newRowKey.setProperty("selectedCaracteristic");
        newRowKey.setShowReset(true);
    }

    protected void createRemoveCaracteristicMenu() {
        $objectMap.put("removeCaracteristicMenu", removeCaracteristicMenu = new JMenuItem());
        
        removeCaracteristicMenu.setName("removeCaracteristicMenu");
        removeCaracteristicMenu.setText(t("tutti.gearUseFeatureTable.action.removeCaracteristic"));
        removeCaracteristicMenu.setToolTipText(t("tutti.gearUseFeatureTable.action.removeCaracteristic.tip"));
        removeCaracteristicMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.GearUseFeatureRemoveRowAction.class);
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(newRowKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTablePopup();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(gearUseFeatureTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        newRowKey.setBeanType(Caracteristic.class);
        removeCaracteristicMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeCaracteristicMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.gearUseFeatureTable.action.removeCaracteristic.mnemonic"),'Z'));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        gearUseFeatureTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        gearUseFeatureTable.setSelectionForeground(Color.BLACK);
        gearUseFeatureTable.setSelectionBackground(null);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$Table0", $Table0);
        createModel();
        createTablePopup();
        createRemoveCaracteristicMenu();
        createNewRowKey();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createGearUseFeatureTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMenu.setEnabled(model.isRemoveCaracteristicEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    newRowKey.setEnabled(!newRowKey.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    addRow.setEnabled(newRowKey.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}