package fr.ifremer.tutti.ui.swing.content.genericformat;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.ExportDataSelectTreeCellRenderer;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class GenericFormatExportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<GenericFormatExportUIModel, GenericFormatExportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_ACCIDENTAL_CATCH_CHECK_BOX_SELECTED = "exportAccidentalCatchCheckBox.selected";
    public static final String BINDING_EXPORT_ATTACHMENTS_CHECK_BOX_SELECTED = "exportAttachmentsCheckBox.selected";
    public static final String BINDING_EXPORT_BENTHOS_CHECK_BOX_SELECTED = "exportBenthosCheckBox.selected";
    public static final String BINDING_EXPORT_BUTTON_ENABLED = "exportButton.enabled";
    public static final String BINDING_EXPORT_INDIVIDUAL_OBSERVATION_CHECK_BOX_SELECTED = "exportIndividualObservationCheckBox.selected";
    public static final String BINDING_EXPORT_MARINE_LITTER_CHECK_BOX_SELECTED = "exportMarineLitterCheckBox.selected";
    public static final String BINDING_EXPORT_SPECIES_CHECK_BOX_SELECTED = "exportSpeciesCheckBox.selected";
    public static final String BINDING_FOLD_ALL_BUTTON_ENABLED = "foldAllButton.enabled";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_SELECT_ALL_BUTTON_ENABLED = "selectAllButton.enabled";
    public static final String BINDING_UNFOLD_ALL_BUTTON_ENABLED = "unfoldAllButton.enabled";
    public static final String BINDING_UNSELECT_ALL_BUTTON_ENABLED = "unselectAllButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(GenericFormatExportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JScrollPane dataSelectionPane;
    protected JTree dataSelectionTree;
    protected JToolBar dataSelectionTreeHeader;
    protected JCheckBox exportAccidentalCatchCheckBox;
    protected JCheckBox exportAttachmentsCheckBox;
    protected JCheckBox exportBenthosCheckBox;
    protected JButton exportButton;
    protected JCheckBox exportIndividualObservationCheckBox;
    protected JCheckBox exportMarineLitterCheckBox;
    protected JPanel exportOptions;
    protected JCheckBox exportSpeciesCheckBox;
    protected JButton foldAllButton;
    protected GenericFormatExportUI genericFormatImportTopPanel = this;
    protected final GenericFormatExportUIHandler handler = createHandler();
    protected GenericFormatExportUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    protected JButton selectAllButton;
    protected DataSelectTreeModel treeModel;
    protected JButton unfoldAllButton;
    protected JButton unselectAllButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<GenericFormatExportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GenericFormatExportUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public GenericFormatExportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GenericFormatExportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatExportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GenericFormatExportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatExportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GenericFormatExportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatExportUI() {
        $initialize();
    }

    public GenericFormatExportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__exportAccidentalCatchCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "exportAccidentalCatch");
    }

    public void doItemStateChanged__on__exportAttachmentsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "exportAttachments");
    }

    public void doItemStateChanged__on__exportBenthosCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "exportBenthos");
    }

    public void doItemStateChanged__on__exportIndividualObservationCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "exportIndividualObservation");
    }

    public void doItemStateChanged__on__exportMarineLitterCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "exportMarineLitter");
    }

    public void doItemStateChanged__on__exportSpeciesCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "exportSpecies");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JScrollPane getDataSelectionPane() {
        return dataSelectionPane;
    }

    public JTree getDataSelectionTree() {
        return dataSelectionTree;
    }

    public JToolBar getDataSelectionTreeHeader() {
        return dataSelectionTreeHeader;
    }

    public JCheckBox getExportAccidentalCatchCheckBox() {
        return exportAccidentalCatchCheckBox;
    }

    public JCheckBox getExportAttachmentsCheckBox() {
        return exportAttachmentsCheckBox;
    }

    public JCheckBox getExportBenthosCheckBox() {
        return exportBenthosCheckBox;
    }

    public JButton getExportButton() {
        return exportButton;
    }

    public JCheckBox getExportIndividualObservationCheckBox() {
        return exportIndividualObservationCheckBox;
    }

    public JCheckBox getExportMarineLitterCheckBox() {
        return exportMarineLitterCheckBox;
    }

    public JPanel getExportOptions() {
        return exportOptions;
    }

    public JCheckBox getExportSpeciesCheckBox() {
        return exportSpeciesCheckBox;
    }

    public JButton getFoldAllButton() {
        return foldAllButton;
    }

    public GenericFormatExportUIHandler getHandler() {
        return handler;
    }

    public GenericFormatExportUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getSelectAllButton() {
        return selectAllButton;
    }

    public DataSelectTreeModel getTreeModel() {
        return treeModel;
    }

    public JButton getUnfoldAllButton() {
        return unfoldAllButton;
    }

    public JButton getUnselectAllButton() {
        return unselectAllButton;
    }

    public SwingValidator<GenericFormatExportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDataSelectionPane() {
        if (!allComponentsCreated) {
            return;
        }
        dataSelectionPane.getViewport().add(dataSelectionTree);
    }

    protected void addChildrenToDataSelectionTreeHeader() {
        if (!allComponentsCreated) {
            return;
        }
        dataSelectionTreeHeader.add(unfoldAllButton);
        dataSelectionTreeHeader.add(foldAllButton);
        dataSelectionTreeHeader.add(selectAllButton);
        dataSelectionTreeHeader.add(unselectAllButton);
    }

    protected void addChildrenToExportOptions() {
        if (!allComponentsCreated) {
            return;
        }
        exportOptions.add($JPanel1, BorderLayout.NORTH);
    }

    protected void addChildrenToGenericFormatImportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.NORTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.genericFormatimport.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.genericFormatExport.action.closeGenericFormatExport"));
        closeButton.setToolTipText(t("tutti.genericFormatExport.action.closeGenericFormatExport.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
        closeButton.putClientProperty("help", "tutti.genericFormatExport.action.closeGenericFormatExport.help");
    }

    protected void createDataSelectionPane() {
        $objectMap.put("dataSelectionPane", dataSelectionPane = new JScrollPane());
        
        dataSelectionPane.setName("dataSelectionPane");
    }

    protected void createDataSelectionTree() {
        $objectMap.put("dataSelectionTree", dataSelectionTree = new JTree());
        
        dataSelectionTree.setName("dataSelectionTree");
        dataSelectionTree.setRootVisible(false);
        dataSelectionTree.setScrollsOnExpand(true);
        dataSelectionTree.setToggleClickCount(2);
        dataSelectionTree.setEditable(false);
    }

    protected void createDataSelectionTreeHeader() {
        $objectMap.put("dataSelectionTreeHeader", dataSelectionTreeHeader = new JToolBar());
        
        dataSelectionTreeHeader.setName("dataSelectionTreeHeader");
        dataSelectionTreeHeader.setFloatable(false);
        dataSelectionTreeHeader.setOpaque(true);
        dataSelectionTreeHeader.setBorderPainted(false);
    }

    protected void createExportAccidentalCatchCheckBox() {
        $objectMap.put("exportAccidentalCatchCheckBox", exportAccidentalCatchCheckBox = new JCheckBox());
        
        exportAccidentalCatchCheckBox.setName("exportAccidentalCatchCheckBox");
        exportAccidentalCatchCheckBox.setText(t("tutti.genericFormatExport.field.exportAccidentalCatch"));
        exportAccidentalCatchCheckBox.setToolTipText(t("tutti.genericFormatExport.field.exportAccidentalCatch.tip"));
        exportAccidentalCatchCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__exportAccidentalCatchCheckBox"));
        exportAccidentalCatchCheckBox.putClientProperty("help", "tutti.genericFormatExport.field.exportAccidentalCatch.help");
    }

    protected void createExportAttachmentsCheckBox() {
        $objectMap.put("exportAttachmentsCheckBox", exportAttachmentsCheckBox = new JCheckBox());
        
        exportAttachmentsCheckBox.setName("exportAttachmentsCheckBox");
        exportAttachmentsCheckBox.setText(t("tutti.genericFormatExport.field.exportAttachments"));
        exportAttachmentsCheckBox.setToolTipText(t("tutti.genericFormatExport.field.exportAttachments.tip"));
        exportAttachmentsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__exportAttachmentsCheckBox"));
        exportAttachmentsCheckBox.putClientProperty("help", "tutti.genericFormatExport.field.exportAttachments.help");
    }

    protected void createExportBenthosCheckBox() {
        $objectMap.put("exportBenthosCheckBox", exportBenthosCheckBox = new JCheckBox());
        
        exportBenthosCheckBox.setName("exportBenthosCheckBox");
        exportBenthosCheckBox.setText(t("tutti.genericFormatExport.field.exportBenthos"));
        exportBenthosCheckBox.setToolTipText(t("tutti.genericFormatExport.field.exportBenthos.tip"));
        exportBenthosCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__exportBenthosCheckBox"));
        exportBenthosCheckBox.putClientProperty("help", "tutti.genericFormatExport.field.exportBenthos.help");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new JButton());
        
        exportButton.setName("exportButton");
        exportButton.setText(t("tutti.genericFormatExport.action.export"));
        exportButton.setToolTipText(t("tutti.genericFormatExport.action.export.tip"));
        exportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.GenericFormatExportAction.class);
        exportButton.putClientProperty("help", "tutti.genericFormatExport.action.export.help");
    }

    protected void createExportIndividualObservationCheckBox() {
        $objectMap.put("exportIndividualObservationCheckBox", exportIndividualObservationCheckBox = new JCheckBox());
        
        exportIndividualObservationCheckBox.setName("exportIndividualObservationCheckBox");
        exportIndividualObservationCheckBox.setText(t("tutti.genericFormatExport.field.exportIndividualObservation"));
        exportIndividualObservationCheckBox.setToolTipText(t("tutti.genericFormatExport.field.exportIndividualObservation.tip"));
        exportIndividualObservationCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__exportIndividualObservationCheckBox"));
        exportIndividualObservationCheckBox.putClientProperty("help", "tutti.genericFormatExport.field.exportIndividualObservation.help");
    }

    protected void createExportMarineLitterCheckBox() {
        $objectMap.put("exportMarineLitterCheckBox", exportMarineLitterCheckBox = new JCheckBox());
        
        exportMarineLitterCheckBox.setName("exportMarineLitterCheckBox");
        exportMarineLitterCheckBox.setText(t("tutti.genericFormatExport.field.exportMarineLitter"));
        exportMarineLitterCheckBox.setToolTipText(t("tutti.genericFormatExport.field.exportMarineLitter.tip"));
        exportMarineLitterCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__exportMarineLitterCheckBox"));
        exportMarineLitterCheckBox.putClientProperty("help", "tutti.genericFormatExport.field.exportMarineLitter.help");
    }

    protected void createExportOptions() {
        $objectMap.put("exportOptions", exportOptions = new JPanel());
        
        exportOptions.setName("exportOptions");
        exportOptions.setLayout(new BorderLayout());
    }

    protected void createExportSpeciesCheckBox() {
        $objectMap.put("exportSpeciesCheckBox", exportSpeciesCheckBox = new JCheckBox());
        
        exportSpeciesCheckBox.setName("exportSpeciesCheckBox");
        exportSpeciesCheckBox.setText(t("tutti.genericFormatExport.field.exportSpecies"));
        exportSpeciesCheckBox.setToolTipText(t("tutti.genericFormatExport.field.exportSpecies.tip"));
        exportSpeciesCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__exportSpeciesCheckBox"));
        exportSpeciesCheckBox.putClientProperty("help", "tutti.genericFormatExport.field.exportSpecies.help");
    }

    protected void createFoldAllButton() {
        $objectMap.put("foldAllButton", foldAllButton = new JButton());
        
        foldAllButton.setName("foldAllButton");
        foldAllButton.setToolTipText(t("tutti.genericFormatExport.action.foldAll.tip"));
        foldAllButton.putClientProperty("help", "tutti.genericFormatExport.action.foldAll.help");
        foldAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ExportFoldAllDataAction.class);
    }

    protected GenericFormatExportUIHandler createHandler() {
        return new GenericFormatExportUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(GenericFormatExportUIModel.class));
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("help", "tutti.genericFormatExport.field.program.help");
        programComboBox.putClientProperty("validatorLabel", t("tutti.genericFormatExport.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.genericFormatExport.field.program"));
        programLabel.setToolTipText(t("tutti.genericFormatExport.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.genericFormatExport.field.program.help");
    }

    protected void createSelectAllButton() {
        $objectMap.put("selectAllButton", selectAllButton = new JButton());
        
        selectAllButton.setName("selectAllButton");
        selectAllButton.setToolTipText(t("tutti.genericFormatExport.action.selectAll.tip"));
        selectAllButton.putClientProperty("help", "tutti.genericFormatExport.action.selectAll.help");
        selectAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ExportSelectAllDataAction.class);
    }

    protected void createTreeModel() {
        $objectMap.put("treeModel", treeModel = new DataSelectTreeModel());
    }

    protected void createUnfoldAllButton() {
        $objectMap.put("unfoldAllButton", unfoldAllButton = new JButton());
        
        unfoldAllButton.setName("unfoldAllButton");
        unfoldAllButton.setToolTipText(t("tutti.genericFormatExport.action.unfoldAll.tip"));
        unfoldAllButton.putClientProperty("help", "tutti.genericFormatExport.action.unfoldAll.help");
        unfoldAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ExportUnfoldAllDataAction.class);
    }

    protected void createUnselectAllButton() {
        $objectMap.put("unselectAllButton", unselectAllButton = new JButton());
        
        unselectAllButton.setName("unselectAllButton");
        unselectAllButton.setToolTipText(t("tutti.genericFormatExport.action.unselectAll.tip"));
        unselectAllButton.putClientProperty("help", "tutti.genericFormatExport.action.unselectAll.help");
        unselectAllButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.ExportUnselectAllDataAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(GenericFormatExportUIModel.class, "edit"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToGenericFormatImportTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(dataSelectionPane, BorderLayout.CENTER);
        $JPanel0.add(exportOptions, BorderLayout.EAST);
        $JPanel0.add(dataSelectionTreeHeader, BorderLayout.SOUTH);
        addChildrenToDataSelectionPane();
        addChildrenToExportOptions();
        // inline complete setup of $JPanel1
        $JPanel1.add(exportAttachmentsCheckBox);
        $JPanel1.add(exportSpeciesCheckBox);
        $JPanel1.add(exportBenthosCheckBox);
        $JPanel1.add(exportMarineLitterCheckBox);
        $JPanel1.add(exportAccidentalCatchCheckBox);
        $JPanel1.add(exportIndividualObservationCheckBox);
        addChildrenToDataSelectionTreeHeader();
        // inline complete setup of $JPanel2
        $JPanel2.add(closeButton);
        $JPanel2.add(exportButton);
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 21 property setters
        programComboBox.setBeanType(Program.class);
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        dataSelectionPane.setColumnHeaderView(dataSelectionTreeHeader);
        dataSelectionPane.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatExport.selectData.legend")));
        dataSelectionTree.setModel(treeModel);
        dataSelectionTree.setCellRenderer(new ExportDataSelectTreeCellRenderer());
        exportOptions.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatExport.exportOptions.legend")));
        unfoldAllButton.setIcon(SwingUtil.createActionIcon("expand"));
        foldAllButton.setIcon(SwingUtil.createActionIcon("collapse"));
        selectAllButton.setIcon(SwingUtil.createActionIcon("select"));
        unselectAllButton.setIcon(SwingUtil.createActionIcon("unselect"));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatExport.action.closeGenericFormatExport.mnemonic"),'Z'));
        exportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatExport.action.export.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, programLabel, "tutti.genericFormatExport.field.program.help");
        registerHelpId(_broker, programComboBox, "tutti.genericFormatExport.field.program.help");
        registerHelpId(_broker, exportAttachmentsCheckBox, "tutti.genericFormatExport.field.exportAttachments.help");
        registerHelpId(_broker, exportSpeciesCheckBox, "tutti.genericFormatExport.field.exportSpecies.help");
        registerHelpId(_broker, exportBenthosCheckBox, "tutti.genericFormatExport.field.exportBenthos.help");
        registerHelpId(_broker, exportMarineLitterCheckBox, "tutti.genericFormatExport.field.exportMarineLitter.help");
        registerHelpId(_broker, exportAccidentalCatchCheckBox, "tutti.genericFormatExport.field.exportAccidentalCatch.help");
        registerHelpId(_broker, exportIndividualObservationCheckBox, "tutti.genericFormatExport.field.exportIndividualObservation.help");
        registerHelpId(_broker, unfoldAllButton, "tutti.genericFormatExport.action.unfoldAll.help");
        registerHelpId(_broker, foldAllButton, "tutti.genericFormatExport.action.foldAll.help");
        registerHelpId(_broker, selectAllButton, "tutti.genericFormatExport.action.selectAll.help");
        registerHelpId(_broker, unselectAllButton, "tutti.genericFormatExport.action.unselectAll.help");
        registerHelpId(_broker, closeButton, "tutti.genericFormatExport.action.closeGenericFormatExport.help");
        registerHelpId(_broker, exportButton, "tutti.genericFormatExport.action.export.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("genericFormatImportTopPanel", genericFormatImportTopPanel);
        createModel();
        createTreeModel();
        createBroker();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createDataSelectionPane();
        createDataSelectionTree();
        createExportOptions();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0, 1));
        createExportAttachmentsCheckBox();
        createExportSpeciesCheckBox();
        createExportBenthosCheckBox();
        createExportMarineLitterCheckBox();
        createExportAccidentalCatchCheckBox();
        createExportIndividualObservationCheckBox();
        createDataSelectionTreeHeader();
        createUnfoldAllButton();
        createFoldAllButton();
        createSelectAllButton();
        createUnselectAllButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createExportButton();
        // inline creation of genericFormatImportTopPanel
        setName("genericFormatImportTopPanel");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_ATTACHMENTS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportAttachmentsCheckBox.setSelected(model.isExportAttachments());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_SPECIES_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportSpeciesCheckBox.setSelected(model.isExportSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_BENTHOS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportBenthos", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportBenthosCheckBox.setSelected(model.isExportBenthos());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportBenthos", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_MARINE_LITTER_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportMarineLitter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportMarineLitterCheckBox.setSelected(model.isExportMarineLitter());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportMarineLitter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_ACCIDENTAL_CATCH_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportAccidentalCatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportAccidentalCatchCheckBox.setSelected(model.isExportAccidentalCatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportAccidentalCatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_INDIVIDUAL_OBSERVATION_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("exportIndividualObservation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportIndividualObservationCheckBox.setSelected(model.isExportIndividualObservation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("exportIndividualObservation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNFOLD_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    unfoldAllButton.setEnabled(model.getProgram() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FOLD_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    foldAllButton.setEnabled(model.getProgram() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECT_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectAllButton.setEnabled(model.getProgram() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNSELECT_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    unselectAllButton.setEnabled(model.getProgram() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canExport", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportButton.setEnabled(model.isCanExport());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canExport", this);
                }
            }
        });
    }

}