/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.LinkedList;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.AbstractReportExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.AutoTextItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.CellExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.DataItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.DynamicTextItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExtendedItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.GridItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ImageItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.LabelItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ListBandExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ListGroupExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ListItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.RowExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TableBandExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TableGroupExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TableItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TemplateExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TextItemExecutor;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;

public class ExecutorManager {
    public static final int GRIDITEM = 0;
    public static final int IMAGEITEM = 1;
    public static final int LABELITEM = 2;
    public static final int LISTITEM = 3;
    public static final int TABLEITEM = 4;
    public static final int DYNAMICTEXTITEM = 5;
    public static final int TEXTITEM = 6;
    public static final int DATAITEM = 7;
    public static final int EXTENDEDITEM = 8;
    public static final int TEMPLATEITEM = 9;
    public static final int AUTOTEXTITEM = 10;
    public static final int LISTBANDITEM = 11;
    public static final int TABLEBANDITEM = 12;
    public static final int ROWITEM = 13;
    public static final int CELLITEM = 14;
    public static final int LISTGROUPITEM = 15;
    public static final int TABLEGROUPITEM = 16;
    public static final int NUMBER = 17;
    protected ExecutorFactory executorFactory;
    protected LinkedList[] freeList = new LinkedList[17];
    AbstractReportExecutor reportExecutor;

    public ExecutorManager(AbstractReportExecutor reportExecutor) {
        this.reportExecutor = reportExecutor;
        int i = 0;
        while (i < 17) {
            this.freeList[i] = new LinkedList();
            ++i;
        }
        this.executorFactory = new ExecutorFactory();
    }

    ExecutionContext getExecutionContext() {
        return this.reportExecutor.context;
    }

    long generateUniqueID() {
        return this.reportExecutor.uniqueId++;
    }

    void setUniqueID(long id) {
        this.reportExecutor.uniqueId = id;
    }

    CachedReportContentReaderV3 getReportReader() {
        return this.reportExecutor.reader;
    }

    CachedReportContentReaderV3 getPageReader() {
        return this.reportExecutor.pageReader;
    }

    PageHintReader getPageHintReader() {
        return this.reportExecutor.hintsReader;
    }

    protected ReportItemExecutor getItemExecutor(int type) {
        assert (type >= 0 && type < 17);
        if (!this.freeList[type].isEmpty()) {
            return (ReportItemExecutor)this.freeList[type].removeFirst();
        }
        switch (type) {
            case 0: {
                return new GridItemExecutor(this);
            }
            case 1: {
                return new ImageItemExecutor(this);
            }
            case 2: {
                return new LabelItemExecutor(this);
            }
            case 3: {
                return new ListItemExecutor(this);
            }
            case 4: {
                return new TableItemExecutor(this);
            }
            case 5: {
                return new DynamicTextItemExecutor(this);
            }
            case 6: {
                return new TextItemExecutor(this);
            }
            case 7: {
                return new DataItemExecutor(this);
            }
            case 8: {
                return new ExtendedItemExecutor(this);
            }
            case 9: {
                return new TemplateExecutor(this);
            }
            case 10: {
                return new AutoTextItemExecutor(this);
            }
            case 11: {
                return new ListBandExecutor(this);
            }
            case 12: {
                return new TableBandExecutor(this);
            }
            case 13: {
                return new RowExecutor(this);
            }
            case 14: {
                return new CellExecutor(this);
            }
            case 15: {
                return new ListGroupExecutor(this);
            }
            case 16: {
                return new TableGroupExecutor(this);
            }
        }
        throw new UnsupportedOperationException("unsupported executor!");
    }

    public ReportItemExecutor createExecutor(ReportItemExecutor parent, ReportItemDesign design, long offset) {
        ReportItemExecutor executor = this.executorFactory.createExecutor(design);
        if (executor != null) {
            executor.setParent(parent);
            executor.setDesign(design);
            executor.setOffset(offset);
        }
        return executor;
    }

    public void releaseExecutor(ReportItemExecutor itemExecutor) {
        int type = itemExecutor.getExecutorType();
        if (type >= 0 && type < 17) {
            this.freeList[type].add(itemExecutor);
        }
    }

    class ExecutorFactory
    extends DefaultReportItemVisitorImpl {
        ExecutorFactory() {
        }

        public ReportItemExecutor createExecutor(ReportItemDesign design) {
            if (design == null) {
                return ExecutorManager.this.getItemExecutor(8);
            }
            return (ReportItemExecutor)design.accept(this, null);
        }

        @Override
        public Object visitAutoTextItem(AutoTextItemDesign autoText, Object value) {
            return ExecutorManager.this.getItemExecutor(10);
        }

        @Override
        public Object visitCell(CellDesign cell, Object value) {
            return ExecutorManager.this.getItemExecutor(14);
        }

        @Override
        public Object visitDataItem(DataItemDesign data, Object value) {
            return ExecutorManager.this.getItemExecutor(7);
        }

        @Override
        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            return ExecutorManager.this.getItemExecutor(8);
        }

        @Override
        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            return null;
        }

        @Override
        public Object visitGridItem(GridItemDesign grid, Object value) {
            return ExecutorManager.this.getItemExecutor(0);
        }

        @Override
        public Object visitImageItem(ImageItemDesign image, Object value) {
            return ExecutorManager.this.getItemExecutor(1);
        }

        @Override
        public Object visitLabelItem(LabelItemDesign label, Object value) {
            return ExecutorManager.this.getItemExecutor(2);
        }

        @Override
        public Object visitListBand(ListBandDesign band, Object value) {
            return ExecutorManager.this.getItemExecutor(11);
        }

        @Override
        public Object visitListItem(ListItemDesign list, Object value) {
            return ExecutorManager.this.getItemExecutor(3);
        }

        @Override
        public Object visitDynamicTextItem(DynamicTextItemDesign dynText, Object value) {
            return ExecutorManager.this.getItemExecutor(5);
        }

        @Override
        public Object visitRow(RowDesign row, Object value) {
            return ExecutorManager.this.getItemExecutor(13);
        }

        @Override
        public Object visitTableBand(TableBandDesign band, Object value) {
            return ExecutorManager.this.getItemExecutor(12);
        }

        @Override
        public Object visitTableItem(TableItemDesign table, Object value) {
            return ExecutorManager.this.getItemExecutor(4);
        }

        @Override
        public Object visitTemplate(TemplateDesign template, Object value) {
            return ExecutorManager.this.getItemExecutor(9);
        }

        @Override
        public Object visitTextItem(TextItemDesign text, Object value) {
            return ExecutorManager.this.getItemExecutor(6);
        }

        @Override
        public Object visitListGroup(ListGroupDesign group, Object value) {
            return ExecutorManager.this.getItemExecutor(15);
        }

        @Override
        public Object visitTableGroup(TableGroupDesign group, Object value) {
            return ExecutorManager.this.getItemExecutor(16);
        }
    }
}

