package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class EditProgramUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditProgramUIModel, EditProgramUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_FIELD_TEXT = "descriptionField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_ZONE_COMBO_BOX_SELECTED_ITEM = "zoneComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XzW8bRRSfuLHzSdI2SiilSPloG7vQdUFCVEoEjROsJDikSgyqmkNY706SKeudZXec2FhB/An8CXDngsSNE+LAmQMXBPwHCHHginhvdr0f8a53UzVSVsm8j3nv/d77zcy3f5G8Y5OFZ2q7rdgtU7AmVbbXnjzZbTyjmtigjmYzS3CbuD9DOZI7IBO6v+4IsnRQQ/OyZ15e502Lm9QMWa/UyLgjOgZ1TigVgrwWtdAcp7zvi1faVsvuefWDivP69T9/577Sv/wmR0jbguimIZX5NKsgk+EayTFdkOuw06laNlTzGMKwmXkM8b6Ea+uG6jgfqk36GfmCjNRIwVJtcCbIYvaUpQ9p37YEmaE6E49tfmyrzTq3HqsmNQR558hW2JFNm9RWREsIprSY4pxBJIrGTQGOFcu1Ud4P7D/asizpuSBIvsl19LT6nJ520DxwV2jY/FNqC1JK9lfHfzfBqiJ1A+OxU9VgugpFEOT1CBy+wHOxj9+Pe4uBh+EjbjcFuREx9nZVG4aEYyzYzwSEamoD87+OsLU93W25iFqzUeUqowYAPxdRrtO2kIILBp8Dsr6jm1HhJAoB/Qav8LYgb8cEjIBDwg2qmkoFPlVmCGpjFj27qMvp3nAxbmJ7CPJyJMx9zeaGgZKo3dWQnZffbF9+azZVUX/JNxu9vS2b8MHF2snV6BYTmsEdWgHcoZXITETdXUXFUqBvU4eKQKJExeOOekr7pTZ5NVJGYAclYIdgfIcOSN5uwTI0ykE/oeyByKWSGxeoBB1K6X9zM7/+8Pv31R5/XIW9Z2NVQ/QHcw0TZMFwMNx62iWPlmBGeUe1Vg7ImEMN4E7JjbdiAtv3xBAc7HcNzRU0VzZV5wRc5Ed++/GnuU9+uUJyVTJucFWvqqi/RcbECVT0hBt623rvkYxo8mwUA4ffHIwNNpkgI11JBufQu6B8tocggFDYLdqGctyKKYcfU2Ps539n9r971CvJEIT4SqJ6UJb8U1JgpsFgVJBUPb6MJdEJy6EtnQe8GMeUBLhyLn5cPJp4KL+rfXUYEmTq0IVg16xyrQUwFLqY/Hm7hSYVmRb+tYG7jAeDn+45f3gChCfIze6iy4YhOldQtBizSTzrW+m7FRrc1pGFH3Qr8i+3ETqKBmMsaJ0Jg+qupFh0T66S2TKMUmwQklTTdh0GRjCQ7KrI3hNdny3PsYOgUNDT/ZkfoYaCumAjODfqzKpL5flByooAuvJreieupiHl5PIGB0Baelf8LK65Q6IcU4G9WSxBgtOH/gHlHSdLXVEcGNUi2r2gDLweTM0gWuHlpC1D54FbaL+dauntNCDtkN/FUjj9N5LTD8eSXIWLR192NItdwNGdALhOtGjRB3cjcFksxYN8bxDIkWxfZLJ95/XlRnOqG756ZJhOVM88naiceTql8oDe9i9QGTKcdJmb6luCNiNT+hS8yCkd9Y7fDuTsJnXJuUWjrHObklvk/peW3ggczdTEo0zHPd3MmANXb3bUKZbm796d763JO7HM1oP1dn+AMLzYYXiJ8pbgMHMXt/CuT4ZRBNe6Q9WyDKapKFmTckE+6GZ/KLg+4dQPdnLdKBqe2BDkJHvzoblj0iY3mSbI/SzBKk1fP9qUxUzWkea8HwdgjFEykKG76KVgXI6FcaG3uC6ZNQzkncRA5WU5Hsm87d7hYqGsPQeUe6G9BmOpZIo3EcxSNvMImssD0JRWA3AMPznSgCz4oCRHKV88oZfyBWAKmmpq8t0Zh0w1AzI9RHYtam7yJoXnHaXmYEzeyhxuIi7JI9rnIoJNeQA2bi3SZy38jMxyCzbUDgdlMrUKFK/ON5ipQwXf7XM9hN/xDB5H8Z1U71jyRfJnvJ+FVD+4/McAD/fAw/8rmAu2YBMAAA==";
    private static final Log log = LogFactory.getLog(EditProgramUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JTextArea descriptionField;
    @ValidatorField( validatorId = "validator",  propertyName = "description",  editorName = "descriptionPane")
    protected JScrollPane descriptionPane;
    protected EditProgramUI editProgramTopPanel = this;
    protected Table form;
    protected final EditProgramUIHandler handler = createHandler();
    protected EditProgramUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JButton resetButton;
    protected JButton saveButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProgramUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "zone",  editorName = "zoneComboBox")
    protected BeanFilterableComboBox<TuttiLocation> zoneComboBox;
    protected JLabel zoneLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProgramUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditProgramUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProgramUI() {
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProgramUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProgramUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProgramUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__descriptionPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        descriptionField.requestFocus();
    }

    public void doKeyReleased__on__descriptionField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "description");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getDescriptionField() {
        return descriptionField;
    }

    public JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public Table getForm() {
        return form;
    }

    public EditProgramUIHandler getHandler() {
        return handler;
    }

    public EditProgramUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public SwingValidator<EditProgramUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<TuttiLocation> getZoneComboBox() {
        return zoneComboBox;
    }

    public JLabel getZoneLabel() {
        return zoneLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(descriptionField);
    }

    protected void addChildrenToEditProgramTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(zoneLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(zoneComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(descriptionPane), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editProgram.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.editProgram.action.closeEditProgram"));
        closeButton.setToolTipText(t("tutti.editProgram.action.closeEditProgram.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
        closeButton.putClientProperty("help", "tutti.editProgram.action.cancelProgram.help");
    }

    protected void createDescriptionField() {
        $objectMap.put("descriptionField", descriptionField = new JTextArea());
        
        descriptionField.setName("descriptionField");
        descriptionField.setColumns(15);
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        descriptionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descriptionField"));
        descriptionField.putClientProperty("help", "tutti.editProgram.field.description.help");
        descriptionField.putClientProperty("validatorLabel", t("tutti.editProgram.field.description"));
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new JScrollPane());
        
        descriptionPane.setName("descriptionPane");
        descriptionPane.setToolTipText(t("tutti.editProgram.field.description.tip"));
        descriptionPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__descriptionPane"));
        descriptionPane.putClientProperty("help", "tutti.editProgram.field.description.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected EditProgramUIHandler createHandler() {
        return new EditProgramUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProgramUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("help", "tutti.editProgram.field.name.help");
        nameField.putClientProperty("validatorLabel", t("tutti.editProgram.field.name"));
        nameField.putClientProperty("selectOnFocus", true);
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("tutti.editProgram.field.name"));
        nameLabel.setToolTipText(t("tutti.editProgram.field.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editProgram.field.name.help");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setText(t("tutti.editProgram.action.resetProgram"));
        resetButton.setToolTipText(t("tutti.editProgram.action.resetProgram.tip"));
        resetButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.program.actions.ResetProgramAction.class);
        resetButton.putClientProperty("help", "tutti.editProgram.action.reset.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editProgram.action.saveProgram"));
        saveButton.setToolTipText(t("tutti.editProgram.action.saveProgram.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.program.actions.SaveProgramAction.class);
        saveButton.putClientProperty("help", "tutti.editProgram.action.saveProgram.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProgramUIModel.class, "edit"));
    }

    protected void createZoneComboBox() {
        $objectMap.put("zoneComboBox", zoneComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        zoneComboBox.setName("zoneComboBox");
        zoneComboBox.setProperty("zone");
        zoneComboBox.setShowReset(true);
        zoneComboBox.putClientProperty("help", "tutti.editProgram.field.zone.help");
        zoneComboBox.putClientProperty("validatorLabel", t("tutti.editProgram.field.zone"));
    }

    protected void createZoneLabel() {
        $objectMap.put("zoneLabel", zoneLabel = new JLabel());
        
        zoneLabel.setName("zoneLabel");
        zoneLabel.setText(t("tutti.editProgram.field.zone"));
        zoneLabel.setToolTipText(t("tutti.editProgram.field.zone.tip"));
        zoneLabel.putClientProperty("help", "tutti.editProgram.field.zone.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditProgramTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(resetButton);
        $JPanel0.add(saveButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        zoneComboBox.setBeanType(TuttiLocation.class);
        form.setBorder(BorderFactory.createTitledBorder((String)null));
        nameLabel.setLabelFor(nameField);
        zoneLabel.setLabelFor(zoneComboBox);
        zoneComboBox.setBean(model);
        descriptionPane.setBorder(BorderFactory.createTitledBorder(t("tutti.editProgram.field.description")));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProgram.action.closeEditProgram.mnemonic"),'Z'));
        resetButton.setIcon(SwingUtil.createActionIcon("reset"));
        resetButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProgram.action.resetProgram.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editProgram.action.saveProgram.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editProgramTopPanel, "tutti.editProgram.help");
        registerHelpId(_broker, nameLabel, "tutti.editProgram.field.name.help");
        registerHelpId(_broker, nameField, "tutti.editProgram.field.name.help");
        registerHelpId(_broker, zoneLabel, "tutti.editProgram.field.zone.help");
        registerHelpId(_broker, zoneComboBox, "tutti.editProgram.field.zone.help");
        registerHelpId(_broker, descriptionPane, "tutti.editProgram.field.description.help");
        registerHelpId(_broker, descriptionField, "tutti.editProgram.field.description.help");
        registerHelpId(_broker, closeButton, "tutti.editProgram.action.cancelProgram.help");
        registerHelpId(_broker, resetButton, "tutti.editProgram.action.reset.help");
        registerHelpId(_broker, saveButton, "tutti.editProgram.action.saveProgram.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editProgramTopPanel", editProgramTopPanel);
        createModel();
        createBroker();
        createValidator();
        createForm();
        createNameLabel();
        createNameField();
        createZoneLabel();
        createZoneComboBox();
        createDescriptionPane();
        createDescriptionField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createResetButton();
        createSaveButton();
        // inline creation of editProgramTopPanel
        setName("editProgramTopPanel");
        setLayout(new BorderLayout());
        editProgramTopPanel.putClientProperty("help", "tutti.editProgram.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZONE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("zone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    zoneComboBox.setSelectedItem(model.getZone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("zone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(descriptionField, getStringValue(model.getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("create", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resetButton.setEnabled(model.isModify() && !model.isCreate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("create", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}