/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.bidi.utils.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.data.bidi.utils.core.BidiEngine;

public abstract class BidiTransform {
    public static String transform(String txt, String inFormat, String outFormat) {
        return BidiEngine.INSTANCE.process(txt, inFormat, outFormat);
    }

    public Map<String, String> transform(Map<String, String> map, String inFormat, String outFormat) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            String str = BidiEngine.INSTANCE.process(key, inFormat, outFormat);
            String value = map.get(key);
            resultMap.put(str, value);
        }
        return resultMap;
    }

    public String transformProcName(String procName, String inFormat, String outFormat, boolean isSQLServer) {
        boolean isSpecialCase;
        String specialCaseStr = ";1";
        boolean bl = isSpecialCase = isSQLServer && procName.endsWith(specialCaseStr);
        if (isSpecialCase) {
            procName = procName.substring(0, procName.length() - specialCaseStr.length());
        }
        procName = BidiEngine.INSTANCE.process(procName, inFormat, outFormat);
        if (isSpecialCase) {
            procName = String.valueOf(procName) + specialCaseStr;
        }
        return procName;
    }

    public static String transformURL(String urlStr, String inFormat, String outFormat) {
        if (inFormat.equals(outFormat)) {
            return urlStr;
        }
        String str = urlStr;
        if (str.contains("db2")) {
            int dbStrStart = str.lastIndexOf("/");
            if (dbStrStart < 0) {
                return urlStr;
            }
            String dbName = str.substring(dbStrStart + 1);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = String.valueOf(str.substring(0, dbStrStart + 1)) + dbName;
        } else if (str.contains("sqlserver")) {
            int dbStrStart = -1;
            if (str.indexOf("databaseName") > 0) {
                dbStrStart = str.indexOf("databaseName") + "databaseName".length();
            } else if (str.indexOf("database") > 0) {
                dbStrStart = str.indexOf("database") + "database".length();
            } else {
                return urlStr;
            }
            String dbName = str.substring(dbStrStart);
            dbName = dbName.trim();
            dbName = dbName.substring(1).trim();
            int indx1 = dbName.indexOf(59);
            int indx2 = dbName.indexOf(44);
            int indx = -1;
            if (indx1 > -1) {
                indx = indx1;
            }
            if (indx2 > -1 && (indx2 < indx || indx == -1)) {
                indx = indx2;
            }
            if (indx == -1) {
                indx = dbName.length();
            }
            dbName = dbName.substring(0, indx);
            String dbNameNew = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = urlStr.replace(dbName, dbNameNew);
        } else if (str.contains("oracle")) {
            int dbStrStart = Math.max(str.lastIndexOf(58), str.lastIndexOf(47));
            if (dbStrStart < 0) {
                return urlStr;
            }
            String dbName = str.substring(dbStrStart + 1);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = String.valueOf(str.substring(0, dbStrStart + 1)) + dbName;
        } else if (str.contains("derby")) {
            int dbStrStart = str.lastIndexOf(47);
            if (dbStrStart < 0) {
                return urlStr;
            }
            String dbName = str.substring(dbStrStart + 1);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = String.valueOf(str.substring(0, dbStrStart + 1)) + dbName;
        } else if (str.contains("mysql")) {
            if (str.indexOf("//") < 0 || str.substring(str.indexOf("//") + 2).indexOf(47) < 0) {
                return urlStr;
            }
            int dbStrStart = str.indexOf("//") + 2 + str.substring(str.indexOf("//") + 2).indexOf(47) + 1;
            int dbStrEnd = str.length();
            if (str.substring(dbStrStart).contains("?")) {
                dbStrEnd = str.substring(dbStrStart).indexOf("?");
            }
            String dbName = str.substring(dbStrStart, dbStrStart + dbStrEnd);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = String.valueOf(str.substring(0, dbStrStart)) + dbName + str.substring(dbStrStart + dbStrEnd);
        }
        return urlStr;
    }
}

